//
//  WCNewCardFlowController.m
//  WorldCard
//
//


#import "WCNewCardFlowController.h"
#import "NCFCBaseFlowController+Private.h"
#import "NCFCCaptureFlowController.h"
#import "NCFCHelpScanCaptureFlowController.h"
#import "NCFCAlbumFlowController.h"
#import "NCFCTextSignatureFlowController.h"
#import "NCFCManualInputFlowController.h"
#import "NCFCImportFlowController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

NSInteger const WCNewCardFlowController_UnlimitedCount = -1;

#define WCNewCardFlowController_FrontSideSuffix     @"f"
#define WCNewCardFlowController_BackSideSuffix      @"b"
#define WCNewCardFlowController_DisplayFileSuffix   @"disp"
#define WCNewCardFlowController_RecogFileSuffix     @"recog"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCNewCardFlowController()
@property (nonatomic, retain) NCFCBaseFlowController *curFlowController;
@property (nonatomic, retain) id lastFlowController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCNewCardFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Life cycle methods

//===============================================================================
// 
//===============================================================================
- (id)init
{
    self = [super init];
    
	if(self)
	{
        self.maxNewCardCount = WCNewCardFlowController_UnlimitedCount;
        self.maxImportCardCount = WCNewCardFlowController_UnlimitedCount;
	}

	return self;
}


//===============================================================================
// 
//===============================================================================
- (void)dealloc
{
    self.helpScanTargetAccountName = nil;
    self.curFlowController = nil;
    self.lastFlowController = nil;
    
    //////////////////////////////////////////////////

	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods


//================================================================================
//
//================================================================================
- (void)newCardWithMode:(WCNewCardFlowController_Mode)mode superViewController:(UIViewController *)superViewController cloudKeyDictionary:(NSDictionary *)cloudKeyDictionary
{
    [[CardRecognitionController shareRecognitionInstance] suspendSilentRecognitionProcess:YES];
  
    //////////////////////////////////////////////////
    
    NCFCBaseFlowController *curFlowController = nil;
    
    switch (mode)
    {
        case WCNewCardFlowController_Mode_Capture:
        {
            curFlowController = [[[NCFCCaptureFlowController alloc] init] autorelease];
            
            break;
        }
        case WCNewCardFlowController_Mode_Album:
        {
            curFlowController = [[[NCFCAlbumFlowController alloc] init] autorelease];
            
            break;
        }
        case WCNewCardFlowController_Mode_TextSignature:
        {
            curFlowController = [[[NCFCTextSignatureFlowController alloc] init] autorelease];
            
            break;
        }
        case WCNewCardFlowController_Mode_ManualInput:
        {
            curFlowController = [[[NCFCManualInputFlowController alloc] init] autorelease];
            
            break;
        }
        case WCNewCardFlowController_Mode_Import:
        {
            curFlowController = [[[NCFCImportFlowController alloc] init] autorelease];
            
            break;
        }
        case WCNewCardFlowController_Mode_HelpScan:
        {
            curFlowController = [[[NCFCHelpScanCaptureFlowController alloc] init] autorelease];
            curFlowController.helpScanTargetAccountName = self.helpScanTargetAccountName;
            break;
        }
        default:
        {
            break;
        }
    }

    if(curFlowController!=nil)
    {
        // MARK: 這邊之後要修正，因為要從 Operation底層起來，不然 suspend 的時間點沒辦法擋住所有delegate method
        
        curFlowController.datasource = self.datasource;
        curFlowController.delegate = self.delegate;

        //////////////////////////////////////////////////
        
        curFlowController.superViewController = superViewController;
        
        if(mode==WCNewCardFlowController_Mode_Import)
        {
            curFlowController.maxNewCardCount = self.maxImportCardCount;
        }
        else
        {
            curFlowController.maxNewCardCount = self.maxNewCardCount;
        }
        
        //////////////////////////////////////////////////

        //匯入時不用參考辨識，所以不用修改辨識 delegate
        if([curFlowController isKindOfClass:[NCFCImportFlowController class]]==NO)
        {
            self.curFlowController = curFlowController;
            
            [[CardRecognitionController shareRecognitionInstance] setDelegate:self.curFlowController];
            
            self.lastFlowController = nil;
        }
        else
        {
            if([[CardRecognitionController shareRecognitionInstance] operationWorking]==YES)
            {
                self.lastFlowController = [[CardRecognitionController shareRecognitionInstance] delegate];
            }
            else
            {
                self.lastFlowController = nil;
            }
         
            //////////////////////////////////////////////////
            
            self.curFlowController = curFlowController;
        }
        
        //////////////////////////////////////////////////

        if([self.curFlowController respondsToSelector:@selector(setCloudKeyDictionary:)]==YES)
        {
            [self.curFlowController performSelector:@selector(setCloudKeyDictionary:) withObject:cloudKeyDictionary];
        }

        [self.curFlowController start];
    }
}


//================================================================================
//
//================================================================================
+ (void)suspendRecogOperation
{ 
    [[CardRecognitionController shareRecognitionInstance] cancelSilentRecognitionProcess];
    
    //////////////////////////////////////////////////

    while([[CardRecognitionController shareRecognitionInstance] operationWorking]==YES)
    {
        [NSThread sleepForTimeInterval:0.01];
    };
}


//================================================================================
//
//================================================================================
+ (void)resumeRecogOperation
{
    if([[CardRecognitionController shareRecognitionInstance] operationWorking]==NO)
    {
        [[CardRecognitionController shareRecognitionInstance] suspendSilentRecognitionProcess:YES];
        
        [[CardRecognitionController shareRecognitionInstance] startRecogWithMode:RecognitionOperationMode_Silent sources:nil];
    }
}


//================================================================================
//
//================================================================================
+ (void)cancelRecogOperation
{
    [self suspendRecogOperation];
    [[CardRecognitionController shareRecognitionInstance] removeAllLocalRecognitionAssets];
}
@end
