//
//  WCNewCardFlowController+ParameterDefine.h
//
//  NOTE
//  --------------------------------------------------
//  因為是給內部使用，所以prefix用物件名稱縮寫。
//  對外部呼叫端來說，這裏的定義值都用不到，只是整理參考。
//

#ifndef Pods_WCNewCardFlowController_ParameterDefine_h
#define Pods_WCNewCardFlowController_ParameterDefine_h

#import "UIColor+HexString.h"

//////////////////////////////////////////////////

/// 所有支援的新增模式
typedef NS_OPTIONS(NSInteger, WCNewCardFlowController_Mode)
{
    WCNewCardFlowController_Mode_None = 0,
    WCNewCardFlowController_Mode_Capture,
    WCNewCardFlowController_Mode_Album,
    WCNewCardFlowController_Mode_TextSignature,
    WCNewCardFlowController_Mode_ManualInput,
    WCNewCardFlowController_Mode_Import,
    WCNewCardFlowController_Mode_HelpScan
};


//////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCNewCardFlowControllerAddCardMode)
{
    WCNewCardFlowControllerAddCardMode_Single,
    WCNewCardFlowControllerAddCardMode_Multi,
};

//////////////////////////////////////////////////

// Card Recognition Translang

//[註2]:辨識結果轉換的語系(辨識語系為中文語系才有作用).
//當aTranLang=0:視名片語系(如:核心辨認出的語系可能與設定不同)
//當aTranLang=1:將結果轉換為簡體.
//當aTranLang=2:將結果轉換為繁體.

typedef NS_ENUM(NSUInteger, WCNewCardFlowControllerCardChineseRecognition)
{
    WCNewCardFlowControllerCardChineseRecognition_Same,
    WCNewCardFlowControllerCardChineseRecognition_GB,
    WCNewCardFlowControllerCardChineseRecognition_TC,
};

//////////////////////////////////////////////////

// NCFCAlbumFlowController Parameter

#define WCNCFC_DefaultImageSize CGSizeMake(1200,1600)

static CGFloat const WCNCFC_SaveImageQualityMinimun = 0.5;

//////////////////////////////////////////////////

#endif
