//
//  PPSignatureNavigationBarView.m
//
//
//  Created by Howard.Lin on 14/1/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPSignatureNavigationBarView.h"

// Define
#import "PPSignatureViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSignatureNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        
        self.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        
        _backButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                       tag:PPSignatureNavigationBarViewButtonTag_Back
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:nil
                                           imageEdgeInsets:UIEdgeInsetsZero] retain];
    
        if(_backButton!=nil)
        {
            [_backButton addControlEvents:UIControlEventTouchUpInside];

            //////////////////////////////////////////////////

            PPBarViewItemModel *backItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_backButton];
            
            if(backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        
        _recognitionButton = [[PPButton ppButtonWithIconImageName:ImageNameForPPSignatureConrollerButtonRecog
                                                             tag:PPSignatureNavigationBarViewButtonTag_Recognition
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:nil
                                                 imageEdgeInsets:UIEdgeInsetsZero] retain];
        
        if(_recognitionButton!=nil)
        {
            [_recognitionButton addControlEvents:UIControlEventTouchUpInside];

            //////////////////////////////////////////////////
            
            PPBarViewItemModel *recogItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_recognitionButton];
            
            if(recogItemModel!=nil)
            {
                recogItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self setItemModels:@[recogItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_backButton removeControlEvents:UIControlEventTouchUpInside];
    [_backButton release];
    _backButton = nil;
    
    [_recognitionButton removeControlEvents:UIControlEventTouchUpInside];
    [_recognitionButton release];
    _recognitionButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(ppSignatureNavigationBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate ppSignatureNavigationBarView:self
                                           ppButton:ppButton
                                       controlEvent:controlEvent];
    }
}

@end
