//
//  PPSignatureBottomBarView.m
//
//  Created by Howard.Lin on 14/1/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPSignatureBottomBarView.h"

// Define
#import "PPSignatureViewController+ResourceDefine.h"
// Category
#import "NSString+Additions.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSignatureBottomBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        _tutorialButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_MediumRect];
        
        if(_tutorialButton!=nil)
        {
            _tutorialButton.delegate = self;
            _tutorialButton.tag      = PPSignatureBottomBarViewButtonTag_Tutorial;
            
            [_tutorialButton addControlEvents:UIControlEventTouchUpInside];

            [_tutorialButton setImageWithName:ImageNameForPPSignatureConrollerButtonTip];
      
            [self addSubview:_tutorialButton];
        }
        
        //////////////////////////////////////////////////

        _tipLabel = [[UILabel alloc] init];
        
        if(_tipLabel!=nil)
        {
            _tipLabel.numberOfLines = 0;
            _tipLabel.lineBreakMode = NSLineBreakByWordWrapping;
            _tipLabel.text = PPSTV_MLS_SignatureTip;
            
            [self addSubview:_tipLabel];
        }

    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_tutorialButton removeControlEvents:UIControlEventTouchUpInside];
    [_tutorialButton removeFromSuperview];
    [_tutorialButton release];
    _tutorialButton = nil;
    
    [_tipLabel release];
    _tipLabel = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    CGRect frame = self.bounds;
    

    self.tipLabel.frame = CGRectMake(self.tipLabelEdgeInset.left+frame.origin.x,
                                     self.tipLabelEdgeInset.top+frame.origin.y,
                                     frame.size.width-UIButtonAdditions_DefaultRect.size.width-self.tipLabelEdgeInset.left-self.tipLabelEdgeInset.right,
                                     frame.size.height-self.tipLabelEdgeInset.top-self.tipLabelEdgeInset.bottom);
    
    self.tutorialButton.frame = CGRectMake(self.tipLabel.frame.origin.x+self.tipLabel.frame.size.width,
                                           0,
                                           UIButtonAdditions_DefaultRect.size.width,
                                           frame.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(ppSignatureBottomBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate ppSignatureBottomBarView:self
                                       ppButton:ppButton
                                   controlEvent:controlEvent];
    }
}


@end
