//
//  PPSignatureViewController.m
//
//  Created by Howard.Lin on 14/1/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPSignatureViewController.h"

// Define
#import "WCNewCardFlowController+SettingsKey.h"
#import "PPSignatureViewController+PrivateParameterDefine.h"
#import "PPSignatureViewController+ResourceDefine.h"

// Controller
#import "PPGuideController.h"
#import "PPSettingsController.h"

// View
#import "DemoStringTextView.h"
#import "PPAlertView.h"
#import "PPTextView.h"
#import "PPSignatureBottomBarView.h"
#import "PPSignatureNavigationBarView.h"

// Category
#import "UIView+PPGuideController.h"
#import "WCCaptureViewController+ResourceDefine.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSignatureViewController () <PPGuideControllerDelegate,PPSignatureNavigationBarViewDelegate,PPSignatureBottomBarViewDelegate>

@property (nonatomic,retain) PPSignatureBottomBarView     *signatureBottomBarView;
@property (nonatomic,retain) PPSignatureNavigationBarView *signatureNavigationBarView;
@property (nonatomic,retain) PPTextView                   *signatureRecognitionView;
@property (nonatomic,retain) DemoStringTextView           *demoStringTextView;
@property (nonatomic,assign) BOOL                         showDemoRecogSelectedString;
@property (nonatomic,assign) BOOL                         stillShowMenu;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSignatureViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        if([[[UIDevice currentDevice]systemVersion]floatValue]>=7.0)
        {
            self.edgesForExtendedLayout=UIRectEdgeNone;
        }
        
        //////////////////////////////////////////////////

        _bottomBarBackgroundColor = [[UIColor clearColor] retain];
        
        //////////////////////////////////////////////////

        _bottomBarFontColor = [[UIColor blackColor] retain];
        
        //////////////////////////////////////////////////

        _controllerTitle = PPSTV_MLS_SignatureEmailRecognize;
        
        //////////////////////////////////////////////////

        // Handle setting
        [PPSettingsController setDefaultIntegerValue:1
                                             withKey:WCNewCardFlowController_SettingsKey_ShowSignatureRecognitionGuide];

    }

    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_signatureBottomBarView removeFromSuperview];
    [_signatureBottomBarView release];
    _signatureBottomBarView = nil;
    
    [_signatureNavigationBarView removeFromSuperview];
    [_signatureNavigationBarView release];
    _signatureNavigationBarView = nil;
    
    [_signatureRecognitionView removeFromSuperview];
    [_signatureRecognitionView release];
    _signatureRecognitionView = nil;
    
    [_bottomBarBackgroundColor release];
    _bottomBarBackgroundColor = nil;
    
    [_bottomBarFontColor release];
    _bottomBarFontColor = nil;
    
    [_textViewTextColor release];
    [_textViewTextColor release];
    
    [_topBarButtonHighlightedBackgroundColor release];
    _topBarButtonHighlightedBackgroundColor = nil;
    
    [_controllerTitle release];
    _controllerTitle = nil;
    
    [_demoStringTextView removeFromSuperview];
    [_demoStringTextView release];
    _demoStringTextView = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    //////////////////////////////////////////////////

    [PPGuideController setDelegate:self];
    
    //////////////////////////////////////////////////

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(reciveAppBecomeActive:)
                                                 name:UIApplicationDidBecomeActiveNotification
                                               object:nil];
    
    //////////////////////////////////////////////////
    
    if(self.signatureBottomBarView==nil)
    {
        _signatureBottomBarView = [[PPSignatureBottomBarView alloc] init];
    }
    
    if(self.signatureBottomBarView!=nil)
    {
        self.signatureBottomBarView.delegate = self;
        self.signatureBottomBarView.backgroundColor = self.bottomBarBackgroundColor;
        self.signatureBottomBarView.tutorialButton.imageEdgeInsets = self.buttonImageEdgeInset;
    
        //////////////////////////////////////////////////

        if(self.bottomBarFontSize>0)
        {
            [self.signatureBottomBarView.tipLabel setFont:[UIFont systemFontOfSize:self.bottomBarFontSize]];
        }
        
        //////////////////////////////////////////////////
        
        [self.signatureBottomBarView.tipLabel setTextColor:self.bottomBarFontColor];
        self.signatureBottomBarView.tipLabelEdgeInset = UIEdgeInsetsMake(0, PPSignatureViewControllerTitleEdgeInsets.left, 0, 0);
        
        //////////////////////////////////////////////////

        [self.view addSubview:self.signatureBottomBarView];
    }
    
    //////////////////////////////////////////////////
    
    if(self.navigationController!=nil)
    {
        if(self.signatureNavigationBarView==nil)
        {
            _signatureNavigationBarView = [[PPSignatureNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        }
        
        if(self.signatureNavigationBarView!=nil)
        {
            self.signatureNavigationBarView.titleLabel.text = self.controllerTitle;
            self.signatureNavigationBarView.delegate =self;
           
            if(self.topBarButtonHighlightedBackgroundColor!=nil)
            {
                [self.signatureNavigationBarView.backButton setBackgroundImage:[UIImage imageWithColor:self.topBarButtonHighlightedBackgroundColor]
                                                                      forState:UIControlStateHighlighted];
                
                //////////////////////////////////////////////////

                [self.signatureNavigationBarView.recognitionButton setBackgroundImage:[UIImage imageWithColor:self.topBarButtonHighlightedBackgroundColor]
                                                                             forState:UIControlStateHighlighted];
            }
            
            //////////////////////////////////////////////////

            self.signatureNavigationBarView.backButton.imageEdgeInsets = self.buttonImageEdgeInset;
            self.signatureNavigationBarView.recognitionButton.imageEdgeInsets = self.buttonImageEdgeInset;
            
            self.signatureNavigationBarView.recognitionButton.ppGuideIndex = PPSignatureViewControllerGuideIndex_Recognition;
        }
        
        //////////////////////////////////////////////////
        
        UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.signatureNavigationBarView];
        
        self.navigationItem.leftBarButtonItem = leftBarButtonItem;
        
        [leftBarButtonItem release];
    }

    //////////////////////////////////////////////////
    
    if(self.signatureRecognitionView==nil)
    {
        _signatureRecognitionView = [[PPTextView alloc] initWithFrame:[self layoutFrame]];
    }
    
    if(self.signatureRecognitionView!=nil)
    {
        if(self.textViewTextColor!=nil)
        {
            [self.signatureRecognitionView setTextColor:self.textViewTextColor];
        }
        
        //////////////////////////////////////////////////

        self.signatureRecognitionView.textContainerInset = PPSignatureViewControllerTitleEdgeInsets;
        
        if(self.contentFontSize>0)
        {
            [self.signatureRecognitionView setFont:[UIFont systemFontOfSize:self.contentFontSize]];
        }
        
        //////////////////////////////////////////////////

        [self.view addSubview:self.signatureRecognitionView];
    }

    //////////////////////////////////////////////////

    self.demoStringTextView = [[[DemoStringTextView alloc] init] autorelease];
    
    if(self.demoStringTextView!=nil)
    {
        self.demoStringTextView.hidden = YES;
 
        //////////////////////////////////////////////////

        self.demoStringTextView.ppGuideIndex = PPSignatureViewControllerGuideIndex_SignatureInformation;

        [self.demoStringTextView setText:[self demoRecogtionString]];
        [self.demoStringTextView setTextColor:self.textViewTextColor];
        [self.demoStringTextView setFont:[UIFont systemFontOfSize:16]];
         
        //////////////////////////////////////////////////

        [self.view addSubview:self.demoStringTextView];

        //////////////////////////////////////////////////
        
        self.demoStringTextView.frame = CGRectMake(PPSignatureViewControllerTitleEdgeInsets.left,
                                                PPSignatureViewControllerTitleEdgeInsets.top,
                                                PPSignatureViewControllerDemoTextLabelWidth,
                                                self.view.bounds.size.height*0.33);
    }
    
    //////////////////////////////////////////////////

    if([self showGuideIfNeeded]==YES)
    {
        self.showDemoRecogSelectedString = YES;
    }
    else
    {
        [self fetchClipboardDataToRecogString];
    }
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    CGRect visibleFrame = [self layoutFrame];
    
    CGFloat contentViewHeight = visibleFrame.size.height;
    
    contentViewHeight -= PPSignatureViewControllerBottomBarViewHeight;
    
    //////////////////////////////////////////////////
    
    self.signatureRecognitionView.frame = CGRectMake(visibleFrame.origin.x, visibleFrame.origin.y, visibleFrame.size.width,contentViewHeight);
    
    self.signatureBottomBarView.frame = CGRectMake(visibleFrame.origin.x, self.signatureRecognitionView.frame.origin.y+self.signatureRecognitionView.frame.size.height, visibleFrame.size.width, PPSignatureViewControllerBottomBarViewHeight);
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////

    [PPGuideController setDelegate:nil];

    //////////////////////////////////////////////////

    [super viewWillDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////

    
    //////////////////////////////////////////////////
    
    [self.signatureBottomBarView removeFromSuperview];
    self.signatureBottomBarView = nil;
    
    [self.signatureNavigationBarView removeFromSuperview];
    self.signatureNavigationBarView = nil;
    
    [self.demoStringTextView hideMenu];
    [self.demoStringTextView removeFromSuperview];
    self.demoStringTextView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View's Rotate Event

//================================================================================
//
//================================================================================
- (void)didRotateFromInterfaceOrientation:(UIInterfaceOrientation)fromInterfaceOrientation
{
    [super didRotateFromInterfaceOrientation:fromInterfaceOrientation];
    
    //////////////////////////////////////////////////
    
    UIMenuController *menu = [UIMenuController sharedMenuController];

    if(self.stillShowMenu==YES &&
       [menu isMenuVisible]==NO)
    {
        [self.demoStringTextView hideMenu];
        [self.demoStringTextView showMenu];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private GuideView Method

//================================================================================
//
//================================================================================
- (BOOL)showGuideIfNeeded
{
    BOOL result = NO;
    
    if([PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_ShowSignatureRecognitionGuide]==1)
    {
        result = YES;
        
        //////////////////////////////////////////////////
        
        self.demoStringTextView.hidden = NO;
        
        //////////////////////////////////////////////////
        
        [PPGuideController clearAllGuideScripts];
        
        [PPGuideController addGuideScriptWithName:PPSTV_Guide guideDataModels:[self guideDataModelsWithClassName:NSStringFromClass([self class])]];
        
        //////////////////////////////////////////////////
        
        [PPGuideController monitorSignalWithViewController:self];
    }
    else
    {
        self.demoStringTextView.hidden = YES;
    }
    return result;
}


//================================================================================
//
//================================================================================
- (NSArray *)guideDataModelsWithClassName:(NSString *)className
{
    
    return @[[PPGuideDataModel modelWithTargetClassName:className
                                             guideIndex:PPSignatureViewControllerGuideIndex_SignatureInformation
                                                  title:PPSTV_MLS_Guide_SelectTitle
                                                message:PPSTV_MLS_Guide_Select
                                        layoutDirection:PPGuideDataModel_LayoutDirection_Vert],
             
             [PPGuideDataModel modelWithTargetClassName:className
                                             guideIndex:PPSignatureViewControllerGuideIndex_SignatureInformation
                                                  title:PPSTV_MLS_Guide_CopyTitle
                                                message:PPSTV_MLS_Guide_Copy
                                        layoutDirection:PPGuideDataModel_LayoutDirection_Vert],
             
//             [PPGuideDataModel modelWithTargetClassName:className
//                                             guideIndex:PPSignatureViewControllerGuideIndex_SignatureInformation
//                                                  title:@""
//                                                message:PPSTV_MLS_Guide_Recognition
//                                        layoutDirection:PPGuideDataModel_LayoutDirection_Vert],
             
             [PPGuideDataModel modelWithTargetClassName:className
                                             guideIndex:PPSignatureViewControllerGuideIndex_Recognition
                                                  title:PPSTV_MLS_Guide_RecognitionTitle
                                                message:PPSTV_MLS_Guide_Recognition
                                        layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private GuideView Recognition Text Method

//================================================================================
//
//================================================================================
- (NSString *)demoRecogtionString
{
    return @"PenPower Technical Support\nPenPower Technology Ltd.\nios_support@penpowerinc.com\nwww.penpower.net\n";
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Clipboard Method

//================================================================================
//
//================================================================================
- (void)fetchClipboardDataToRecogString
{
    NSString *recognitionString = [self demoRecogtionString];
    
    //檢查剪貼簿是否有文字
    UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
    
    //剪貼簿有文字，切入辨識模式
    if([self validClipboardText]==YES)
    {
        recognitionString = pasteboard.string;
    }
    
    //////////////////////////////////////////////////

    if(recognitionString!=nil)
    {
        [self setRecognitionString:recognitionString];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)validClipboardText
{
    BOOL hasSignatureString = NO;
    
    //檢查剪貼簿是否有文字
    UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
    NSArray *types           = [pasteboard pasteboardTypes];
    NSArray *textTypeArray   = [NSArray arrayWithObjects:@"public.utf8-plain-text", @"public.text", nil];
    
    
    for(NSString *oneType in textTypeArray)
    {
        if([types containsObject:oneType])
        {
            hasSignatureString = YES;
            break;
        }
    }
    
    return hasSignatureString;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Notification Method

//================================================================================
//
//================================================================================
- (void)reciveAppBecomeActive:(NSNotification *)notification
{
    if([PPGuideController isGuideDisplaying]==NO)
    {
        [self fetchClipboardDataToRecogString];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGuideViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)guideControllerDidClickConfirmButton:(UIButton *)confirmButton
{
    if(self.showDemoRecogSelectedString==YES)
    {
        [self.demoStringTextView showMenu];
        
        //////////////////////////////////////////////////

        self.showDemoRecogSelectedString = NO;
        
        //////////////////////////////////////////////////

        self.stillShowMenu = YES;
    }
    else
    {
        [self.demoStringTextView hideMenu];
        
        //////////////////////////////////////////////////

        self.stillShowMenu = NO;
    }
}


//================================================================================
//
//================================================================================
- (void)guideControllerDidFinishScript:(NSString *)guideScriptName
{
    if([guideScriptName isEqualToString:PPSTV_Guide] == YES)
    {
        [PPSettingsController setIntegerValue:0 withKey:WCNewCardFlowController_SettingsKey_ShowSignatureRecognitionGuide];
    }
    
    //////////////////////////////////////////////////

    self.demoStringTextView.hidden = YES;
    
    //////////////////////////////////////////////////

    [self fetchClipboardDataToRecogString];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSignatureBottomBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)ppSignatureBottomBarView:(PPSignatureBottomBarView *)ppSignatureBottomBarView
                        ppButton:(PPButton *)ppButton
                    controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPSignatureBottomBarViewButtonTag_Tutorial:
        {
            self.showDemoRecogSelectedString = YES;
            
            //////////////////////////////////////////////////

            self.recognitionString = nil;
            
            //////////////////////////////////////////////////
            
            self.demoStringTextView.hidden = NO;
            
            //////////////////////////////////////////////////
            
            [PPGuideController clearAllGuideScripts];
            
            //////////////////////////////////////////////////
            
            [PPGuideController addGuideScriptWithName:PPSTV_Guide guideDataModels:[self guideDataModelsWithClassName:NSStringFromClass([self class])]];
            
            //////////////////////////////////////////////////
            
            [PPGuideController manuallyShowGuideWithViewController:self];
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSignatureNavigationBarView Method

//================================================================================
//
//================================================================================
- (void)ppSignatureNavigationBarView:(PPSignatureNavigationBarView *)ppSignatureNavigationBarView
                            ppButton:(PPButton *)ppButton
                        controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPSignatureNavigationBarViewButtonTag_Back:
        {
            if([self.delegate respondsToSelector:@selector(ppSignatureViewController:action:)]==YES)
            {
                [self.delegate ppSignatureViewController:self action:PPSignatureViewControllerAction_Back];
            }
            
            break;
        }
        case PPSignatureNavigationBarViewButtonTag_Recognition:
        {
            // guild state
            if(self.demoStringTextView.hidden==NO)
            {
                self.demoStringTextView.hidden = YES;
            }
            else if([self recognitionString].length<=0)
            {
                [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                     title:@""
                                   message:PPSTV_MLS_CantBeEmpty
                         cancelButtonTitle:NSLocalizedString(@"MLS_OK", nil)
                         otherButtonTitles:nil];
            }
            else if([self.delegate respondsToSelector:@selector(ppSignatureViewController:action:)]==YES)
            {
                [self.delegate ppSignatureViewController:self
                                                  action:PPSignatureViewControllerAction_Recognition];
            }
        
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSString *)recognitionString
{
    NSString *recognitionString = self.signatureRecognitionView.text;
    
    //過濾字串前後空白or跳行符號
    do
    {
        if(recognitionString==nil ||
           recognitionString.length<=0)
        {
            break;
        }
        else if([recognitionString hasPrefix:@" "]==YES)
        {
            if(recognitionString.length>1)
            {
                recognitionString = [recognitionString substringFromIndex:1];
            }
            else
            {
                recognitionString = @"";
            }
        }
        else if([recognitionString hasPrefix:@"\n"]==YES)
        {
            if(recognitionString.length>1)
            {
                recognitionString = [recognitionString substringFromIndex:1];
            }
            else
            {
                recognitionString = @"";
            }
        }
        else if([recognitionString hasSuffix:@" "]==YES)
        {
            if(recognitionString.length>1)
            {
                recognitionString = [recognitionString substringToIndex:recognitionString.length-1];
            }
            else
            {
                recognitionString = @"";
            }
        }
        else if([recognitionString hasSuffix:@"\n"]==YES)
        {
            if(recognitionString.length>1)
            {
                recognitionString = [recognitionString substringToIndex:recognitionString.length-1];
            }
            else
            {
                recognitionString = @"";
            }
        }
        else
        {
            break;
        }
    }
    while (1);
    
    return recognitionString;
}


//================================================================================
//
//================================================================================
- (void)setRecognitionString:(NSString *)recognitionString;
{
    if(self.signatureRecognitionView==nil)
    {
        _signatureRecognitionView = [[PPTextView alloc] initWithFrame:[self layoutFrame]];
    }
    
    if(self.signatureRecognitionView!=nil)
    {
        self.signatureRecognitionView.text = recognitionString;
    }
}

@end
