//
//  NCFCManualInputFlowController.m
//  Pods
//
//  Created by eddie on 2015/7/13.
//
//

#import "NCFCManualInputFlowController.h"

// Category
#import "NCFCBaseFlowController+Private.h"
#import "WCNewCardFlowController+ResourceDefine.h"

@implementation NCFCManualInputFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (void)start
{
    self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCount];
    
    //////////////////////////////////////////////////

    do
    {
        NSError *error = nil;
        
        __block typeof(self) blockSelf = self;
        
        if([self canNewCardWithError:&error] == NO)
        {
            [self showAlertWithError:error title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
                
                [blockSelf didFinishWithError:error];
            }];
            
            //////////////////////////////////////////////////
            
            break;
        }

        //////////////////////////////////////////////////
        
        [self showContactEditViewControllerWithCardModel:nil
                                            idPhotoImage:nil
                                          frontCardImage:nil
                                           rearCardImage:nil];
    }
    while (0);
}

@end
