//
//  NCFCImportFlowController.m
//
//

#import "NCFCImportFlowController.h"

// Define
#import "WCABDataController+ResourceDefine.h"
#import "WCNewCardFlowController+ResourceDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"
#import "NSError+Custom.h"

// Model


// View


// Controller
#import "PPLogController.h"
#import "WCABDataController.h"
#import "WCImportFlowController.h"
#import "PPSettingsController.h"

// Category
#import "NSError+Custom.h"
#import "NCFCBaseFlowController+Private.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCImportFlowController() <WCImportFlowControllerDatasource,WCImportFlowControllerDelegate>

@property (nonatomic,retain) WCImportFlowController *importFlowController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCImportFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

- (id)init
{
    if(self=[super init])
    {
        _importFlowController = [[WCImportFlowController alloc] init];
        
        _importFlowController.importFlowDatasource = self;
        _importFlowController.importFlowDelegate = self;
    }
    
    return self;
}


//================================================================================
//
//=================================================================================
- (void)dealloc
{
    [_importFlowController release];
    _importFlowController = nil;
    
    [_cloudKeyDictionary release];
    _cloudKeyDictionary = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}



//================================================================================
//
//================================================================================
- (void)start
{
    self.curNewCardCount = 0;
    
    //////////////////////////////////////////////////

    NSError *error = nil;

    //////////////////////////////////////////////////
    
    __block typeof(self) blockSelf = self;
    
    if([self canNewCardWithError:&error] == NO)
    {
        [self showAlertWithError:error title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
            
            [blockSelf didFinishWithError:error];
        }];
        
        return;
    }
    
    //////////////////////////////////////////////////
    
    NSMutableArray *storageSpaces = [self requestSpaceTypeArray];

    if(storageSpaces==nil ||
       storageSpaces.count<=0)
    {
        [self didFinishWithError:PPErrorMake(NSErrorCustom_Code_ParameterInvalidity, @"ParameterInvalidity", nil)];
    }
    else
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequesetEnableSpecificSpace)]==YES)
        {
            BOOL result = [self.delegate newCardFlowRequesetEnableSpecificSpace];
            
            //////////////////////////////////////////////////

            if(result==YES)
            {
                [storageSpaces insertObject:@(PPStorageSpaceSelectControllerSpaceType_Specific) atIndex:0];
            }
        }

        //////////////////////////////////////////////////
        
        [self.importFlowController showStorageSpaceViewControllerWithCloudKeyDictionary:self.cloudKeyDictionary
                                                                         spaceTypeArray:storageSpaces
                                                                    superViewController:blockSelf.superViewController];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCImportFlowDatasource Method

//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)importFlowControllerEastDisplayNameOrder
{
    return [self requestDisplayNameOrderWithEasternName:YES];
}


//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)importFlowControllerWestDisplayNameOrder
{
    return [self requestDisplayNameOrderWithEasternName:NO];
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)importFlowWithAllGroupModelsWithCardID:(NSString *)cardID
{
    return [self requestCardModelWithAllGroupModelsWithCardID:cardID];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCImportFlowDelegate Method

//================================================================================
//
//================================================================================
- (NSString *)importFlowRequestMessageWithError:(NSError *)error
{
    PPLogFunction();
    
    return [self requestMessageWithError:error];
}


//================================================================================
//
//================================================================================
- (BOOL)importFlowRequestShowError:(NSError *)error
{
    PPLogFunction();
    
    return [self requestShowWithError:error];
}



//================================================================================
//
//================================================================================
- (void)importFlowImportTaskAtIndex:(NSUInteger)index totalCount:(NSUInteger)totalCount
{
    PPLogFunction();
    
    [self requestRecogTaskAtIndex:index totalCount:totalCount];
}


//==============================================================================
//
//==============================================================================
- (NSString *)specificStringWithimportFlowController:(WCImportFlowController*)importFlowController
{
    return [self requestSpecificString];
}


//================================================================================
//
//================================================================================
- (WC_GroupID)importFlowRequestGroupIDWithGroupName:(NSString *)groupName
                                              error:(NSError **)error;
{
    PPLogFunction();
    
    WCGroupModel *groupModel = nil;
    WC_GroupID groupID = WC_GID_None;
    
    if([self requestCardModelWithExistGroupNamed:groupName]==YES)
    {
        groupModel = [self requestCardModelWithGroupModelByExistGroupName:groupName];
    }
    else
    {
        groupModel = [self requestCardModelWithGroupModelByNewGroupName:groupName error:error];
    }
    
    //////////////////////////////////////////////////
    
    if(groupModel!=nil)
    {
        groupID = groupModel.ID;
    }
    
    //////////////////////////////////////////////////
    
    return groupID;
}


//================================================================================
//
//================================================================================
- (BOOL)importFlowRequestImportWithWCCardModel:(WCCardModel *)cardModel
                                  idPhotoImage:(UIImage *)idPhotoImage
                                frontSideImage:(UIImage *)frontSideImage
                                 backSideImage:(UIImage *)backSideImage
                                         error:(NSError **)error
{
    PPLogFunction();
    
    //////////////////////////////////////////////////
    
    if([self canNewCardWithError:error] == NO)
    {
        return NO;
    }
    else
    {
        self.curNewCardCount++;
        
        return [self requestSaveWithCardModel:cardModel
                                 idPhotoImage:idPhotoImage
                               frontSideImage:frontSideImage
                                backSideImage:backSideImage
                                        error:error];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)importFlowRequestImportWithWCABCardModel:(WCABCardModel *)cardModel
                                           error:(NSError **)error
{
    PPLogFunction();

    //////////////////////////////////////////////////
    
    if([self canNewCardWithError:error] == NO)
    {
        return NO;
    }
    else
    {
        self.curNewCardCount++;
        
        return [self requestSaveWithWCABCardModel:cardModel
                                            error:error];
    }
}


//================================================================================
//
//================================================================================
- (void)importFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    [self requestDidSelectStorageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
}


//================================================================================
//
//================================================================================
- (void)importFlowDidFinishWithError:(NSError *)lastError
{
    PPLogFunction();
    
    return [self didFinishWithError:lastError];
}


@end
