//
//  NCFCCaptureFlowController.m
//

#import "NCFCCaptureFlowController.h"

// Define
#import "NCFCBaseFlowController+ParameterDefine.h"
#import "WCNewCardFlowController+ResourceDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"
#import "WCCaptureViewController+SettingsKey.h"
#import "WCCaptureFlowController+SettingKey.h"

// Controller
#import "WCImageBrowseViewController.h"
#import "PPLogController.h"
#import "PPNavigationController.h"
#import "PPSettingsController.h"
#import "WCVCFDataController.h"
#import "WCCaptureFlowController.h"

// Category
#import "NSError+Custom.h"
#import "NCFCBaseFlowController+Private.h"

#if defined (PRODUCTLINE_WCE)
#import "WCECardModel.h"
#import "WCEFieldModel.h"
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCCaptureFlowController () <WCCaptureFlowControllerDatasource,WCCaptureFlowControllerDelegate>

@property (nonatomic,assign) BOOL noQRCodeResult;
@property (nonatomic,retain) WCCaptureFlowController *captureFlowController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCCaptureFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        // 設定預設值
        [PPSettingsController setDefaultIntegerValue:CaptureMode_Manual
                                             withKey:WCNewCardFlowController_SettingsKey_LastCaptureMode];
    }
    
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.captureFlowController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (void)start
{
    self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCount];

    //////////////////////////////////////////////////

    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage]
                                  withKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage]
                                  withKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage];

    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_LastCaptureMode]
                                  withKey:WCCaptureFlowController_SettingsKey_LastCaptureMode];
    
    //////////////////////////////////////////////////

    self.captureFlowController = [[[WCCaptureFlowController alloc] init] autorelease];
    
    if(self.captureFlowController!=nil)
    {
        [self.captureFlowController setCaptureFlowDatasource:self];
        [self.captureFlowController setCaptureFlowDelegate:self];
        [self.captureFlowController setCurCaptureCardCount:self.curNewCardCount];
        [self.captureFlowController setMaxCaptureCardCount:self.maxNewCardCount];
        
        // !! adding my card要隱藏拍下一張
        BOOL isAddingMyCard = NO;
        if([self.datasource respondsToSelector:@selector(isAddingMyCard)])
        {
            isAddingMyCard = [self.datasource isAddingMyCard];
        }
        [self.captureFlowController setHideNextCardButton:isAddingMyCard];
        
#if defined (PRODUCTLINE_WCSF) ||defined (PRODUCTLINE_WCO365)
        self.captureFlowController.showSubscribeWhenReachMaxCount = YES;
#endif
        //////////////////////////////////////////////////

        NSArray *captureModes = nil;
        
        //IPad 沒有基座模式
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            captureModes = @[@(CaptureMode_Manual),
                             @(CaptureMode_QRCode)];
        }
        else
        {
#if defined (PRODUCTLINE_WCSF) ||defined (PRODUCTLINE_WCO365)
            captureModes = @[@(CaptureMode_Manual),
                             @(CaptureMode_QRCode)];
#else
            captureModes = @[@(CaptureMode_Docking),
                             @(CaptureMode_Manual),
                             @(CaptureMode_QRCode)];
#endif
        }
        
        //////////////////////////////////////////////////

        [self.captureFlowController presentMultiModeFromViewController:self.superViewController
                                                           captureSide:CaptureSide_Front
                                                          captureCount:0
                                                   supportCaptureModes:captureModes
                                                     activeCaptureMode:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_LastCaptureMode]
                                                     presentCompletion:nil];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Setting Key Write Method

//================================================================================
//
//================================================================================
- (void)updateNewCardFlowSettingKeyWithCapture
{
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_LastCaptureMode]
                                  withKey:WCNewCardFlowController_SettingsKey_LastCaptureMode];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage]
                                  withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage]
                                  withKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCaptureFlowControllerDatasource Method

//================================================================================
//
//================================================================================
- (NSArray *)recogLanguagesWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide
{
    if(captureSide==CaptureSide_Front)
    {
        return [self recogLangTitlesWithSelectedTitle:[self recogTitleWithRecogLangCode:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage]]];
    }
    else
    {
        return [self recogLangTitlesWithSelectedTitle:[self recogTitleWithRecogLangCode:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage]]];
    }
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfCard
{
    return [self numberOfWholeCard];
}


//================================================================================
//
//================================================================================
- (NSUInteger)recogLangCodeWithRecogTitle:(NSString *)recogTitle
{
    return [super requestRecogLangCodeWithRecogLangauge:recogTitle];
}


//================================================================================
//
//================================================================================
- (WCRecogSourceModel *)recogSourceModelForImageType:(WC_ImageType)imageType
                                       recogLanguage:(NSString *)recogLanguage
                                   activeCaptureMode:(WCCaptureViewController_CaptureMode)acitveCaptureMode
{
    NSString *cardID = nil;
    
    if(imageType==WC_IT_FrontSide)
    {
        cardID = [NSString GUID];
    }
    else
    {
        //取前一張
        WCRecogSourceModel *recogSourceModel = [self.recogSourceModels lastObject];
        
        cardID = recogSourceModel.cardID;
    }
    
    //////////////////////////////////////////////////

    WCRecogSourceModel *recogSourceModel = [self nextRecogSourceModelWithCardID:cardID imageType:imageType addMode:WCRecogSourceModelAddMode_Camera];
    
    if(recogSourceModel!=nil)
    {
        recogSourceModel.imageEnhance = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableImageEnhance];
        recogSourceModel.imageSegment = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableAutoCrop];

        recogSourceModel.recogLang = [self requestRecogLangCodeWithRecogLangauge:recogLanguage];
    }

    return recogSourceModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCaptureFlowControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     didRecongizeQRCodeString:(NSString *)string
{
    do
    {
        if(self.noQRCodeResult==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.noQRCodeResult = YES;

        //////////////////////////////////////////////////
        
        NSError *returnError = nil;
        
        WCCardModel *cardModel = [self requestRecogWithQRCodeString:string
                                                        newCardMode:WCNewCardFlowController_Mode_Capture
                                                              error:&returnError];
        
        //////////////////////////////////////////////////
        
        //vCard String 轉換 CardModel 失敗
        if(cardModel==nil)
        {
            // 改用電子郵件辨識語系
            cardModel = [self requestRecogWithSourceString:string
                                               newCardMode:WCNewCardFlowController_Mode_Capture
                                                     error:&returnError];
        }
        
        //////////////////////////////////////////////////
        
        cardModel.ID = [NSString GUID];
        
        //////////////////////////////////////////////////
        
        [cardModel setGroupIDArray:[self requestCardModelWithCardModelDefaultGroupIDArray]
                        isInitCard:YES];
        
        //////////////////////////////////////////////////
#ifdef PRODUCTLINE_WCE
        // !! WCE 情況下，要塞 CategoryGuid
        if([[cardModel groupIDArray] count]>0 &&
           [cardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
        {
            [cardModel performSelector:@selector(setCategoryGuid:) withObject:[[cardModel groupIDArray] firstObject]];
        }
#endif
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        PPLogFunction(@" cardModel:%@",cardModel);
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            // QRCode不套用規則
            blockself.adjustFlowBySettings = NO;
            [blockself showContactEditViewControllerWithCardModel:cardModel
                                                     idPhotoImage:nil
                                                   frontCardImage:nil
                                                    rearCardImage:nil];
        });
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
      dockModeDidCaptureImage:(UIImage *)image
                recogLanguage:(NSString *)recogLanguage
                  captureSide:(WCCaptureViewController_CaptureSide)captureSide
             isDoubleSideMode:(BOOL)isDoubleSideMode
{
    do
    {
        WC_ImageType imageType = WC_IT_FrontSide;
        
        if(captureSide==CaptureSide_Back)
        {
            imageType = WC_IT_BackSide;
        }
        
        //////////////////////////////////////////////////
        
        NSString *cardID = nil;
        
        if(imageType==WC_IT_FrontSide)
        {
            cardID = [NSString GUID];
        }
        else
        {
            //取前一張
            WCRecogSourceModel *recogSourceModel = [self.recogSourceModels lastObject];
            
            cardID = recogSourceModel.cardID;
        }
        
        //////////////////////////////////////////////////
        
        //取圖資訊
        WCRecogSourceModel *recogSourceModel = [self nextRecogSourceModelWithCardID:cardID imageType:imageType addMode:WCRecogSourceModelAddMode_Camera];
        
        if(recogSourceModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        recogSourceModel.imageEnhance = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableImageEnhance];
        recogSourceModel.imageSegment = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableAutoCrop];
        
        recogSourceModel.dockMode = YES;
        
        //////////////////////////////////////////////////
        
        //存原始圖
        NSString *path = [self pathForSavingImage:image
                                          imageID:recogSourceModel.cardID
                                        imageType:recogSourceModel.imageType
                                      lightEnable:NO];
        
        //原始圖位置
        recogSourceModel.imageSource = path;
        
        //////////////////////////////////////////////////
        
        //辨識語系
        recogSourceModel.recogLang = [self requestRecogLangCodeWithRecogLangauge:recogLanguage];
        
        //////////////////////////////////////////////////
        
        //自動旋轉
        recogSourceModel.rotateDegree = 255;
        
        //////////////////////////////////////////////////
        
        [self.recogSourceModels addObject:recogSourceModel];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     fromCaptureViewControler:(WCCaptureViewController *)captureViewController
     manualModeDidSelectImage:(UIImage *)image
             recogSourceModel:(WCRecogSourceModel *)recogSourceModel
                      isFinal:(BOOL)isFinal
{
    //存原始圖
    NSString *path = [self pathForSavingImage:image
                                      imageID:recogSourceModel.cardID
                                    imageType:recogSourceModel.imageType
                                  lightEnable:NO];
    
    //原始圖位置
    recogSourceModel.imageSource = path;
    
    //////////////////////////////////////////////////
    
    //有做影像優化才要存亮化圖
    if(recogSourceModel.imageEnhance==YES)
    {
        //存亮化圖
        path = [self pathForSavingImage:image
                                imageID:recogSourceModel.cardID
                              imageType:recogSourceModel.imageType
                            lightEnable:YES];
        
        //亮化圖位置
        recogSourceModel.lightImageSource = path;
    }
    
    //////////////////////////////////////////////////
    
    //中文名片輸出設定
    recogSourceModel.outputTranslate = [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_ChineseCardOutput];
    
    //////////////////////////////////////////////////
    
    if(recogSourceModel.imageType==WC_IT_BackSide)
    {
        [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                      withKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
    }
    else if(recogSourceModel.imageType==WC_IT_FrontSide)
    {
        [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                      withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
    }
    
    //////////////////////////////////////////////////
    
    PPLogFunction(@" %s, recogSourceModel.CardID:%@, recogSourceModel.imageType:%td",__func__,recogSourceModel.cardID,recogSourceModel.imageType);
    
    [self.recogSourceModels addObject:recogSourceModel];
  
    //////////////////////////////////////////////////

    if(isFinal==YES)
    {
        // TODO: 進單張編輯頁面
        if([self numberOfWholeCard]==1)
        {
            [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                            fromViewController:captureViewController];
            
        }
        else
        {
            [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                            fromViewController:captureViewController];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidClickCancel:(WCCaptureFlowController *)captureFlowController fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    if(self.recogSourceModels.count<=0)
    {
        [captureViewController dismissAnimated:YES completion:^{
        }];
    }
    else
    {
        [self showAgainRecogtionAlert];
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidClickDone:(WCCaptureFlowController *)captureFlowController
                fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    if(captureViewController.captureCount==1)
    {
        [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                        fromViewController:captureViewController];
    }
    else
    {
        [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                        fromViewController:captureViewController];
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidFinish:(WCCaptureFlowController *)captureFlowController
{
    [self updateNewCardFlowSettingKeyWithCapture];
    
    //////////////////////////////////////////////////
    
    self.captureFlowController = nil;
    
    //////////////////////////////////////////////////

    [self didFinishWithError:nil];
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidFinishWithSubscribe:(WCCaptureFlowController *)captureFlowController
{
    [self updateNewCardFlowSettingKeyWithCapture];

    //////////////////////////////////////////////////

    self.captureFlowController = nil;

    //////////////////////////////////////////////////
    NSError *error = PPErrorMake(WCNewCardFlow_Error_SubscribeNow, @"馬上訂閱", nil);
    [self didFinishWithError:error];
}

//================================================================================
//
//================================================================================
- (BOOL)captureFlowRequestShowError:(NSError *)error
{
    return YES;
}


//================================================================================
//
//================================================================================
- (NSString *)captureFlowRequestTitleWithError:(NSError *)error
{
    NSString *customTitle = nil;
    
    if(error.code==WCCaptureFlowControllerErrorCode_ReachMaximumCount)
    {
        customTitle = WCNCFC_MLS_FailedToNewCard;
    }
    
    return customTitle;
}


//================================================================================
//
//================================================================================
- (NSString *)captureFlowRequestMessageWithError:(NSError *)error
{
    NSString *customMessage = nil;
    
    customMessage = [self requestMessageWithError:error];
    
    if (customMessage==nil)
    {
        if(error.code==WCCaptureFlowControllerErrorCode_ReachMaximumCount)
        {
            customMessage = WCNCFC_MLS_ReachMaxNewCardCount;
        }
    }
    return customMessage;
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerShowDockPromotion:(WCCaptureFlowController *)captureFlowController
                     fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    [self requestShowPromotionFomrCaptureViewController:captureViewController];
}

@end
