//
//  NCFCBaseFlowController.m
//

#import "WCNewCardFlowController+ResourceDefine.h"

// Controller
#import "NCFCBaseFlowController.h"
#import "PPSettingsController.h"

// Define
#import "NCFCBaseFlowController+Private.h"
#import "WCNewCardFlowController+ParameterDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"
#import "namecard_define.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCBaseFlowController ()
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCBaseFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Lify cycle methods

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _defaultImageSize = WCNCFC_DefaultImageSize;
        _imageQuality     = WCNCFC_SaveImageQualityMinimun;
        
        //////////////////////////////////////////////////

        self.recogSourceModels = [[[NSMutableArray alloc] init] autorelease];
        
        //////////////////////////////////////////////////
        if ([PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage]==PPSettingsController_UnsetIntValue)
        {
            [PPSettingsController setDefaultIntegerValue:EN_LANG
                                                 withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
        }
        
        if ([PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage]==PPSettingsController_UnsetIntValue)
        {
            [PPSettingsController setDefaultIntegerValue:EN_LANG
                                                 withKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
        }
        //////////////////////////////////////////////////

        [PPSettingsController setDefaultIntegerValue:WCNewCardFlowControllerCardChineseRecognition_Same
                                             withKey:WCNewCardFlowController_SettingsKey_ChineseCardOutput];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    //////////////////////////////////////////////////

    [_superViewController release];
    _superViewController = nil;
    
    _firstViewController = nil;
    
    //////////////////////////////////////////////////

    self.recogSourceModels = nil;
    
    //////////////////////////////////////////////////

    self.recogLangModels = nil;

    //////////////////////////////////////////////////

    self.contactAccessFlowController = nil;
    self.helpScanTargetAccountName = nil;
    
    //////////////////////////////////////////////////

    self.headImage = nil;
    self.frontCardImage = nil;
    self.rearCardImage = nil;
    self.lastError = nil;
    self.alertComplete = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (void)start
{
    // implement in subClass object
}





@end
