//
//  NCFCBaseFlowController+Private.m
//
//


#import <objc/runtime.h>

// Define
#import "WCFieldTypeConverter.h"
#import "namecard_define.h"
#import "NCFCBaseFlowController+ParameterDefine.h"
#import "NCFCBaseFlowController+Private.h"
#import "WCCaptureViewController+SettingsKey.h"
#import "WCNewCardFlowController+ResourceDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"

// Model
#import "PPQuadrilateralModel.h"
#import "WCKernelRecogLangModel.h"


// View

// Controller
#import "AlbumPathController.h"
#import "CardRecognitionController.h"
#import "PPLogController.h"
#import "PPNavigationController.h"
#import "PPImageEnhanceController.h"
#import "PPPatternOCRController.h"
#import "PPSettingsController.h"
#import "CardRecognitionController.h"
#import "WCCaptureViewController.h"
#import "WCAlbumContentViewController.h"
#import "NoteViewController.h"

// Category
#import "NSError+Custom.h"
#import "NSString+Additions.h"
#import "UIViewController+Additions.h"


#if defined (PRODUCTLINE_WCE)

#import "WCECardModel.h"

#elif defined (PRODUCTLINE_WCT)

#import "WCTFieldLengthDefine.h"

#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCBaseFlowController (Private)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property


//================================================================================
//
//================================================================================
- (AlertBlock)alertComplete
{
    return objc_getAssociatedObject(self, @selector(alertComplete));
}


//================================================================================
//
//================================================================================
- (void)setAlertComplete:(AlertBlock)alertComplete
{
    objc_setAssociatedObject(self, @selector(alertComplete), alertComplete, OBJC_ASSOCIATION_COPY);
}


//================================================================================
//
//================================================================================
- (BOOL)addFrontCard
{
    NSNumber *addFrontCardNumber = objc_getAssociatedObject(self, @selector(addFrontCard));
    return [addFrontCardNumber boolValue];
}


//================================================================================
//
//================================================================================
- (void)setAddFrontCard:(BOOL)addFrontCard
{
    objc_setAssociatedObject(self, @selector(addFrontCard), @(addFrontCard), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (BOOL)adjustFlowBySettings
{
    NSNumber *adjustFlowBySettingsNumber = objc_getAssociatedObject(self, @selector(adjustFlowBySettings));
    return [adjustFlowBySettingsNumber boolValue];
}


//================================================================================
//
//================================================================================
- (void)setAdjustFlowBySettings:(BOOL)adjustFlowBySettings
{
    objc_setAssociatedObject(self, @selector(adjustFlowBySettings), @(adjustFlowBySettings), OBJC_ASSOCIATION_RETAIN);
}



//================================================================================
//
//================================================================================
- (NSString *)defaultSourceID
{
    NSString *defaultSourceIDString = objc_getAssociatedObject(self, @selector(defaultSourceID));
    return defaultSourceIDString;
}


//================================================================================
//
//================================================================================
- (void)setDefaultSourceID:(NSString *)defaultSourceID
{
    objc_setAssociatedObject(self, @selector(defaultSourceID), defaultSourceID, OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSString *)defaultGroupID
{
    NSString *defaultGroupIDString = objc_getAssociatedObject(self, @selector(defaultGroupID));
    return defaultGroupIDString;
}


//================================================================================
//
//================================================================================
- (void)setDefaultGroupID:(NSString *)defaultGroupID
{
    objc_setAssociatedObject(self, @selector(defaultGroupID), defaultGroupID, OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSString *)personID
{
    NSString *personIDString = objc_getAssociatedObject(self, @selector(personID));
    return personIDString;
}


//================================================================================
//
//================================================================================
- (void)setPersonID:(NSString *)personID
{
    objc_setAssociatedObject(self, @selector(personID), personID, OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)recogSourceModels
{
    return objc_getAssociatedObject(self, @selector(recogSourceModels));
}


//================================================================================
//
//================================================================================
- (void)setRecogSourceModels:(NSMutableArray *)recogSourceModels
{
    PPLogFunction(@" %s, recogSourceModels:%@",__func__,recogSourceModels);
    
    objc_setAssociatedObject(self, @selector(recogSourceModels), recogSourceModels, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (NSArray *)recogLangModels
{
    return objc_getAssociatedObject(self, @selector(recogLangModels));
}


//================================================================================
//
//================================================================================
- (void)setRecogLangModels:(NSArray *)recogLangModels
{
    objc_setAssociatedObject(self, @selector(recogLangModels), recogLangModels, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (WCContactAccessFlowController *)contactAccessFlowController
{
    return objc_getAssociatedObject(self, @selector(contactAccessFlowController));
}


//================================================================================
//
//================================================================================
- (void)setContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    objc_setAssociatedObject(self, @selector(contactAccessFlowController), contactAccessFlowController, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (UIImage *)frontCardImage
{
    return objc_getAssociatedObject(self, @selector(frontCardImage));
}


//================================================================================
//
//================================================================================
- (void)setFrontCardImage:(UIImage *)frontCardImage
{
    objc_setAssociatedObject(self, @selector(frontCardImage), frontCardImage, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (UIImage *)rearCardImage
{
    return objc_getAssociatedObject(self, @selector(rearCardImage));
}


//================================================================================
//
//================================================================================
- (void)setRearCardImage:(UIImage *)rearCardImage
{
    objc_setAssociatedObject(self, @selector(rearCardImage), rearCardImage, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
//
//================================================================================
- (UIImage *)headImage
{
    return objc_getAssociatedObject(self, @selector((headImage)));
}


//================================================================================
//
//================================================================================
- (void)setHeadImage:(UIImage *)headImage
{
    objc_setAssociatedObject(self, @selector(headImage), headImage, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIAlertViewDelegate methods

//================================================================================
//
//================================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    // MARK: AlertView 退開流程
    switch (alertView.tag)
    {
        case NCFCBaseFlowControllerAlertTag_AgainRecognition:
        {
            if([[alertView buttonTitleAtIndex:buttonIndex] compare:WCNCFC_MLS_OK]==NSOrderedSame)
            {
                if([self numberOfCardFromRecogSourceModels]==1)
                {
                    [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                                    fromViewController:self.superViewController];
                }
                else
                {
                    [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                                    fromViewController:self.superViewController];
                }
       
            }
            else
            {
                __block typeof(self) blockself =self;
                
                [self.superViewController dismissAnimated:YES completion:^{
                    if([[alertView buttonTitleAtIndex:buttonIndex] compare:WCNCFC_MLS_OK]!=NSOrderedSame)
                    {
                        [blockself didFinishWithError:nil];
                    }
                }];
            }

            break;
        }
        case NCFCBaseFlowControllerAlertTag_SalesforceFailed:
        {
            if([[alertView buttonTitleAtIndex:buttonIndex] compare:WCNCFC_MLS_ContinueEdit]==NSOrderedSame)
            {
                //
                if (self.contactAccessFlowController.isEditing)
                {
                    [self.contactAccessFlowController onClickContinueEditWithViewController:self.contactAccessFlowController.contactEditViewController];
                }
                self.alertComplete(NO);
                self.alertComplete = nil;
            }
            else
            {
                __block typeof(self) blockself =self;
                
                [self.superViewController dismissAnimated:YES completion:^{
                    if([[alertView buttonTitleAtIndex:buttonIndex] compare:WCNCFC_MLS_CancelEdit]!=NSOrderedSame)
                    {
                        [blockself didFinishWithError:nil];
                    }
                }];
            }
            break;
        }
        default:
        {
            NSString *buttonTitle = [alertView buttonTitleAtIndex:buttonIndex];
            self.alertComplete([buttonTitle isEqualToString:WCNCFC_MLS_SubscribeNow]);
            self.alertComplete = nil;
            
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (NSUInteger)numberOfCardFromRecogSourceModels
{
    NSUInteger numberOfCard = 0;
    
    do
    {
        if(self.recogSourceModels==nil ||
           self.recogSourceModels.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *lastCardID = nil;
        
        for(WCRecogSourceModel *recogSourceModel in self.recogSourceModels)
        {
            if(lastCardID==nil)
            {
                lastCardID = recogSourceModel.cardID;
                numberOfCard++;
            }
            // CardID 不一樣，代表不同名片
            else if([lastCardID compare:recogSourceModel.cardID]!=NSOrderedSame)
            {
                numberOfCard++;
            }
        }
    }
    while (0);
    
    return numberOfCard;
}


//==============================================================================
//
//==============================================================================
- (BOOL)saveCardProcessWithCardModel:(WCCardModel *)cardModel
{
    __block BOOL saveCard = NO;
    
    //////////////////////////////////////////////////
    
    __block NSError *returnError = nil;
    
    if([NSStringFromClass([self class]) compare:@"NCFCImportFlowController"]==NSOrderedSame)
    {
        saveCard = [self requestSaveWithWCABCardModel:(WCABCardModel *)cardModel error:&returnError];
    }
    else
    {
        saveCard = [self requestSaveWithSingleCardModel:cardModel
                                           idPhotoImage:self.headImage
                                         frontSideImage:self.frontCardImage
                                          backSideImage:self.rearCardImage
                                               sourceID:self.defaultSourceID
                                                groupID:self.defaultGroupID
                                               personID:self.personID
                                                  error:&returnError];
    }
    
    if(saveCard==NO)
    {
        [returnError retain];
    }
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        
        if(saveCard==YES)
        {
            //
            [self.superViewController dismissAnimated:YES completion:^{
                [blockself didFinishWithError:nil];
            }];
        }
        else
        {
#if defined (PRODUCTLINE_WCSF) || defined (PRODUCTLINE_WCO365)
            [self showSalesforceAlertWithError:returnError completion:^(BOOL didSubscribeNow) {
                [blockself didFinishWithError:returnError];
                [returnError release];
            }];
#else
            [self showAlertWithError:returnError title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
                
                [blockself didFinishWithError:returnError];
                [returnError release];
            }];
#endif
        }
        
    });
    
    return saveCard;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CardRecognitionController Delegate Method

//================================================================================
//
//================================================================================
- (void)cardRecognitionControllerStartAllRecognition:(CardRecognitionController *)cardRecognitionController
{
    PPLogFunction(@"%s",__func__);
    
    //////////////////////////////////////////////////

    if([self.delegate respondsToSelector:@selector(newCardFlowRequestStartRecognition)]==YES)
    {
        [self.delegate newCardFlowRequestStartRecognition];
    }
}


//================================================================================
//
//================================================================================
- (void)cardRecognitionController:(CardRecognitionController *)cardRecognitionController
        didFinishAllRecogWithMode:(RecognitionOperationMode)recogMode
{
    PPLogFunction(@"%s",__func__);
    
    __block typeof(self) blockself = self;
    
    //////////////////////////////////////////////////
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestFinishRecognition)]==YES)
    {
        [self.delegate newCardFlowRequestFinishRecognition];
    }
    
    //////////////////////////////////////////////////

    if(self.lastError==nil)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockself didFinishWithError:nil];
        });
    }
    else if(self.lastError.code!=NSErrorCustom_Code_OperationCancel)
    {
        [self showAlertWithError:self.lastError title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
            dispatch_async(dispatch_get_main_queue(), ^{
                [blockself didFinishWithError:blockself.lastError];
            });
        }];
    }

}


//================================================================================
// 自動裁切
//================================================================================
- (UIImage *)resetImageBeforeRecognizing:(UIImage *)image
           withCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                             recogSource:(WCRecogSourceModel *)recogSource
{
    // do nothing
    UIImage *resetImage = image;
    
    do
    {
        if(recogSource.dockMode==NO ||
           recogSource.imageSegment==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPQuadrilateralModel *quadriateralModel = [PPImageEnhanceController houghTransformQuadrilateralModelForImage:image];
        
        PPLogFunction(@" %s, HoughTrans_Color_LinkQR, image.size:%@, topLeft:%@, topRight:%@, bottomLeft:%@, bottomRight:%@",__func__,NSStringFromCGSize(image.size),NSStringFromCGPoint(quadriateralModel.topLeft),NSStringFromCGPoint(quadriateralModel.topRight),NSStringFromCGPoint(quadriateralModel.bottomLeft),NSStringFromCGPoint(quadriateralModel.bottomRight));
        
        //裁切
        resetImage = [PPImageEnhanceController deskewImage:image withQuadrilateralModel:quadriateralModel];
        
        //裁切失敗, 指定原先圖片
        if(resetImage==nil)
        {
            resetImage = image;
        }
        
    } while (0);
    
    return resetImage;
}


//================================================================================
// 亮化
//=================================================================================
- (UIImage *)resetImageBeforeSaving:(UIImage *)image
      withCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                        recogSource:(WCRecogSourceModel *)recogSource
{
    UIImage *resetImage = image;
    
    do
    {
        // 旋轉
        UIImage *lightImage = [image imageRotatedByDegrees:recogSource.rotateDegree];
        
        if(lightImage==nil)
        {
            break;
        }
        
        resetImage = lightImage;
        
        //////////////////////////////////////////////////

        if(recogSource.imageEnhance==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 亮化
        resetImage = [PPImageEnhanceController lightCorrectImage:lightImage];
        
        //亮化失敗
        if(resetImage==nil)
        {
            resetImage = lightImage;
        }
        
    } while (0);
    
    return resetImage;
}


//================================================================================
//
//================================================================================
- (void)cardRecognitionController:(CardRecognitionController *)cardRecognitionController
                  recogFrontImage:(UIImage *)recogFrontImage
                   recogBackImage:(UIImage *)recogBackImage
             resultFrontCardModel:(WCCardModel *)frontCardModel
              resultBackCardModel:(WCCardModel *)backCardModel
       ppRecognitionOperationMode:(RecognitionOperationMode)recognitionOperationMode
        frontCardRecognitionError:(NSError *)frontCardRecognitionError
         backCardRecognitionError:(NSError *)backCardRecognitionError
{
    PPLogFunction(@"%s",__func__);
    
    // MARK: 一次辨識一張圖片，有錯誤立刻停止辨識
   
    if(self.lastError==nil)
    {
        if(frontCardRecognitionError!=nil ||
           backCardRecognitionError!=nil)
        {
            NSError *error = nil;
            
            if([self requestSaveWithCardModel:frontCardModel
                                 idPhotoImage:nil
                               frontSideImage:recogFrontImage
                                backSideImage:recogBackImage
                                        error:&error]==NO)
            {
                [[CardRecognitionController shareRecognitionInstance] cancelSilentRecognitionProcess];
                [[CardRecognitionController shareRecognitionInstance] removeAllLocalRecognitionAssets];
                
                self.lastError = error;
            }
        }
        else
        {
            WCCardModel *newCardModel = [frontCardModel copy];
            
            if(newCardModel!=nil &&
               backCardModel!=nil)
            {
                [newCardModel combineCard:backCardModel];
                
                newCardModel.backRecogLang = backCardModel.frontRecogLang;
            }
            
            //////////////////////////////////////////////////
            
            NSError *error = nil;
            
            if([self requestSaveWithCardModel:newCardModel
                                 idPhotoImage:nil
                               frontSideImage:recogFrontImage
                                backSideImage:recogBackImage
                                        error:&error]==NO)
            {
                [[CardRecognitionController shareRecognitionInstance] cancelSilentRecognitionProcess];
                [[CardRecognitionController shareRecognitionInstance] removeAllLocalRecognitionAssets];
            
                //////////////////////////////////////////////////

                self.lastError = error;
            }

            [newCardModel release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)cardRecognitionControllerDidRecogOneSource:(WCRecogSourceModel *)recogSource
                                        recogImage:(UIImage *)recogImage
                        ppRecognitionOperationMode:(RecognitionOperationMode)recognitionOperationMode
                                   resultCardModel:(WCCardModel *)cardModel
                                             error:(NSError *)error
{
    PPLogFunction(@"%s, error:%@",__func__,error);
}


//================================================================================
//
//================================================================================
- (WCCardModel *)cardModelWithCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                                             recogImage:(UIImage *)recogImage
                                            recogSource:(WCRecogSourceModel *)recogSource
                                                  error:(NSError **)error
{
    PPLogFunction(@" %s",__func__);

    //////////////////////////////////////////////////

    [self requestRecogTaskAtIndex:[[CardRecognitionController shareRecognitionInstance] silentRecognitionCountForUserCount]
                       totalCount:self.curNewCardCount];
    

    //////////////////////////////////////////////////

    [cardRecognitionController minusRecognitionCountForCardID:recogSource.cardID];
    
    //////////////////////////////////////////////////

    WCCardModel *cardModel = [self requestRecogWithSourceModel:recogSource
                                                         image:recogImage
                                                         error:error];
    
    //////////////////////////////////////////////////

    [cardModel setGroupIDArray:recogSource.groupIDArray isInitCard:YES];
    
    
    //////////////////////////////////////////////////
    
#ifdef PRODUCTLINE_WCE
    if([[cardModel groupIDArray] count]>0 &&
       [cardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
    {
        [cardModel performSelector:@selector(setCategoryGuid:) withObject:[[cardModel groupIDArray] firstObject]];
    }
#endif
    
    //////////////////////////////////////////////////

    return cardModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactAccessFlowController Delegate Method

//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)nameOrderForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isEasternName:(BOOL)isEasternName
{
    // MARK: 語言順序
    return [self requestDisplayNameOrderWithEasternName:isEasternName];
}


//================================================================================
//
//================================================================================
- (NSArray *)supportRecognizeLangugaesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 辨識語系
    return [self requestRecogLangModels];
}


//================================================================================
//
//================================================================================
- (NSArray *)supportRecognizeFieldTypesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 辨識欄位
    return [self requestRecogTypes];
}


//================================================================================
//
//================================================================================
- (NSData *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageDataWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType
{
    // TODO: 名片圖的data
    
    return nil;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController allGroupModelsWithCardID:(NSString *)cardID
{
    // MARK: 群組選擇
    
    PPLogFunction(@" %s",__func__);
    
    return [self requestCardModelWithAllGroupModelsWithCardID:cardID];
}


//================================================================================
//
//================================================================================
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    clipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                           originalCardModel:(WCCardModel *)originalCardModel
                                       error:(NSError **)error
{
    // MARK: 手括辨識
    PPLogFunction(@" %s",__func__);
    
    return [self requestClipRecogWithSourceModel:recogSourceModel originalCardModel:originalCardModel error:error];
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupNamesWithGroupIDArray:(NSArray *)groupIDArray
{
    // MARK: 群組名稱
    
    PPLogFunction(@" %s",__func__);
    
    return [self requestCardModelWithGroupNamesWithGroupIDArray:groupIDArray];
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isExistGroupNamed:(NSString*)groupNamed;
{
    // MARK: 群組存不存在
    
    PPLogFunction(@" %s",__func__);
    
    return [self requestCardModelWithExistGroupNamed:groupNamed];
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupModelByNewGroupName:(NSString *)groupName;
{
    // MARK: 新增群組
    
    PPLogFunction(@" %s",__func__);
    
    // 手動名片，新增群組, Error 帶 nil
    return [self requestCardModelWithGroupModelByNewGroupName:groupName
                                                        error:nil];
}


//================================================================================
//
//================================================================================
- (NSArray *)contactAccessFlowControllerRequestDefaultGroupIDArray:(WCContactAccessFlowController *)contactAccessFlowController
{
    return [self requestCardModelWithCardModelDefaultGroupIDArray];
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isCardIDExist:(NSString *)cardID
{
    BOOL result = NO;
    
    do
    {
        if([contactAccessFlowController.userInfo respondsToSelector:@selector(ID)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *existCardID = [contactAccessFlowController.userInfo performSelector:@selector(ID)];
        
        if(existCardID==nil || existCardID.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([existCardID compare:cardID options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            result = YES;
        }
    }
    while (0);

    
    return result;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardModelWithCardID:(NSString *)cardID;
{
    // MARK: 回傳名片資料
    PPLogFunction(@" %s",__func__);
    
    WC_CardModel *cardModel = nil;
    
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WC_CardModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cardModel = userInfo;
    }
    while (0);
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isFavoriteWithCardID:(NSString *)cardID;
{
    // MARK: 我的最愛
    PPLogFunction(@" %s",__func__);
    return NO;
}


//================================================================================
//
//================================================================================
- (UIImage *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType;
{
    // MARK: 名片圖
    PPLogFunction(@" %s",__func__);
    
    UIImage *image = nil;
    
    switch (imageType)
    {
        case WC_IT_BackSide:
        {
            image = self.rearCardImage;
            break;
        }
        case WC_IT_FrontSide:
        {
            image = self.frontCardImage;
            break;
        }
        case WC_IT_IDPhoto:
        {
            image = self.headImage;
            break;
        }
        default:
        {
            break;
        }
    }
    
    return image;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               phoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                    sourceValue:(NSString *)sourceValue
                              isCompanyPhonetic:(BOOL)isCompanyPhonetic
{
    // MARK: 讀音
    PPLogFunction(@" %s",__func__);
    return [self requestPhoneticArrayWithClickedPhonetic:phonetic
                                             sourceValue:sourceValue
                                       isCompanyPhonetic:isCompanyPhonetic];
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                             action:(WCContactFlowControllerAction)action
                         withCardID:(NSString *)cardID
                              error:(NSError **)error
{
    // MARK: 動作
    PPLogFunction(@" %s",__func__);
    
    //////////////////////////////////////////////////

    switch (action)
    {
        case WCContactFlowControllerAction_Delete:
        {
            // 新增連絡人不會刪除
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsFront:
        {
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SetFrontFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SwitchFavorite:
        {
            // TODO: 新增連絡人至我的最愛
            break;
        }
        case WCContactFlowControllerAction_EditSuccessful:
        {
            PPLogFunction(@"WCContactFlowControllerAction_EditSuccessful:%@", self);
            
            __block BOOL saveCard = NO;
            
            //////////////////////////////////////////////////
            // !! 如果有開啟編輯時編輯備註的設定，要先進入備註頁面
            BOOL shouldShowNoteBeforeSave = NO;
            BOOL isCapture = [self isKindOfClass:NSClassFromString(@"NCFCCaptureFlowController")];
            
            if(isCapture && self.adjustFlowBySettings==YES)
            {
                shouldShowNoteBeforeSave = [self requestShouldEditNoteBeforeSave];
            }
                        
            if(shouldShowNoteBeforeSave)
            {
                // !! 進編輯後，又進入備註，算已校正
                __block typeof(self) blockSelf = self;
                __block WCFieldModel *noteField = [[[blockSelf.contactAccessFlowController.userInfo fieldArrayWithType:WC_FT_Note] firstObject] retain];

                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    [blockSelf showNoteFromViewController:blockSelf.contactAccessFlowController.contactEditViewController
                                               noteString:(noteField.value?:@"")
                                          completeHandler:^(NoteViewController *noteViewController, PPButton *ppButton, UIControlEvents controllEvent) {
                        
                        dispatch_async(dispatch_get_main_queue(), ^{
                            
                            if (ppButton.tag==NoteViewControllerButtonTag_Done)
                            {
                                if([noteViewController.noteTextString length]>0)
                                {
                                    if(noteField==nil)
                                    {
                                        noteField = [[WCFieldModel newFieldModel] retain];
                                        noteField.type = WC_FT_Note;
                                        [blockSelf.contactAccessFlowController.userInfo addField:noteField];
                                    }
                                    noteField.value = noteViewController.noteTextString;
                                }
                                saveCard = [blockSelf saveCardProcessWithCardModel:blockSelf.contactAccessFlowController.userInfo];
                            }
                            else
                            {
                                // 有進編輯，所以這邊cancel也要儲存
                                saveCard = [blockSelf saveCardProcessWithCardModel:blockSelf.contactAccessFlowController.userInfo];
                                
                                [blockSelf.superViewController dismissAnimated:YES completion:^{
                                    [blockSelf didFinishWithError:nil];
                                }];
                            }
                            
                            [noteField release];
                        });
                    }];
                });
                
            }
            else
            {
                // !! 進編輯，不進備註，算已校正
                saveCard = [self saveCardProcessWithCardModel:self.contactAccessFlowController.userInfo];
            }
            
            return saveCard;
        }
        case WCContactFlowControllerAction_GoBack:
        {
            PPLogFunction(@"WCContactFlowControllerAction_GoBack");
            
            __block typeof(self) blockself = self;
            
            [self.superViewController dismissViewControllerAnimated:YES completion:^{
                [blockself didFinishWithError:nil];
            }];
            
            break;
        }
        default:
        {
            break;
        }
    }
    return YES;
}


//================================================================================
//
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardModel:(WCCardModel *)cardModel
                     withABSourceID:(NSString *)abSourceID
                          abGroupID:(NSString *)abGroupID
                         abPersonID:(NSString *)abPersonID
                              error:(NSError **)error
{
    // MARK: 名片資訊
    PPLogFunction(@" %s",__func__);
    
    //////////////////////////////////////////////////

    self.defaultSourceID = abSourceID;
    self.defaultGroupID = abGroupID;
    self.personID = abPersonID;
    
    //////////////////////////////////////////////////

    id object = contactAccessFlowController.userInfo;
    
    if(object==nil)
    {
        contactAccessFlowController.userInfo = cardModel;
    }
    else if([object isKindOfClass:[WCCardModel class]]==YES)
    {
        contactAccessFlowController.userInfo = cardModel;
    }
    else if([object isKindOfClass:[WCABCardModel class]]==YES)
    {
        WCABCardModel *exitAbCardModel = (WCABCardModel *)object;
        
        WCABCardModel *newABCardModel = [cardModel copy];
        
        //////////////////////////////////////////////////
        
        newABCardModel.abSourceID = exitAbCardModel.abSourceID;
        newABCardModel.abGroupID  = exitAbCardModel.abGroupID;
        newABCardModel.abPersonID = exitAbCardModel.abPersonID;
        newABCardModel.abPhotoImage = exitAbCardModel.abPhotoImage;
        
        //////////////////////////////////////////////////
        
        contactAccessFlowController.userInfo = [newABCardModel autorelease];
    }
}


//================================================================================
//
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardImage:(UIImage *)cardImage
                         withCardID:(NSString *)cardID
                          imageType:(WC_ImageType)imageType
                              error:(NSError **)error
{
    // MARK: 更新名片圖
    PPLogFunction(@" %s",__func__);
    
    switch (imageType)
    {
        case WC_IT_BackSide:
        {
            self.rearCardImage = cardImage;
            break;
        }
        case WC_IT_FrontSide:
        {
            self.frontCardImage = cardImage;
            break;
        }
        case WC_IT_IDPhoto:
        {
            self.headImage = cardImage;
            break;
        }
        default:
        {
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController hasCardImageWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType
{
    BOOL existCardImage = NO;
    
    switch (imageType)
    {
        case WC_IT_BackSide:
        {
            if(self.rearCardImage!=nil)
            {
                existCardImage = YES;
            }
            break;
        }
        case WC_IT_FrontSide:
        {
            if(self.frontCardImage!=nil)
            {
                existCardImage = YES;
            }
            break;
        }
        case WC_IT_IDPhoto:
        {
            if(self.headImage!=nil)
            {
                existCardImage = YES;
            }
            break;
        }
        default:
        {
            break;
        }
    }
    
    return existCardImage;
}


//================================================================================
//
//================================================================================
- (BOOL)autoFormatPhoneNumberWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 自動電話格式化
    BOOL result = NO;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestAutoFormatPhoneNumber)]==YES)
    {
        result = [self.delegate newCardFlowRequestAutoFormatPhoneNumber];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)appendCountryCodeWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 電話加上國碼
    BOOL result = NO;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestAppendCountryCode)]==YES)
    {
        result = [self.delegate newCardFlowRequestAppendCountryCode];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestFrontRecogLang:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 正面名片圖語系
    return [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
}

//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestBackRecogLang:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 反面名片圖語系
    return [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
}


//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestOutputTranslate:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 中文名片輸出
    return [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_ChineseCardOutput];
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowControllerRequestEnableSaveToiPhoneContact:(WCContactAccessFlowController *)contactAccessFlowController;
{
    BOOL result = NO;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowControllerRequestEnableSaveToiPhoneContact)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        result = [self.delegate newCardFlowControllerRequestEnableSaveToiPhoneContact];
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestDefaultABSourceID:(WCContactAccessFlowController *)contactAccessFlowController;
{
    NSString *sourceID = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowControllerRequestDefaultABSourceID)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        sourceID = [self.delegate newCardFlowControllerRequestDefaultABSourceID];
    }
    while (0);
    
    return sourceID;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestDefaultABGroupID:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSString *groupID = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowControllerRequestDefaultABGroupID)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        groupID = [self.delegate newCardFlowControllerRequestDefaultABGroupID];
    }
    while (0);

    return groupID;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestGoogleSyncAccount:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSString *googleSyncAccount = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestGoogleSyncAccount)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        googleSyncAccount = [self.delegate newCardFlowRequestGoogleSyncAccount];
    }
    while (0);
    
    return googleSyncAccount;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactAccessFlowController Delegate Method (WCT Related)

//================================================================================
// MARK:取得自已帳號的guid
//================================================================================
- (NSString *)selfAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSString *selfAccountGuid = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestSelfAccountGuid)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        selfAccountGuid = [self.delegate newCardFlowRequestSelfAccountGuid];
    }
    while (0);
    
    return selfAccountGuid;
}


//================================================================================
// MARK:取得boss guid
//================================================================================
- (NSString *)bossAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSString *bossAccountGuid = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestBossAccountGuid)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        bossAccountGuid = [self.delegate newCardFlowRequestBossAccountGuid];
    }
    while (0);
    
    return bossAccountGuid;
}


//================================================================================
// MARK:guid取得帳號關係
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                  requestRelationWithGuid:(NSString *)guid
{
    NSString *relationString = nil;
    
    do
    {
        if(guid.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.delegate respondsToSelector:@selector(newCardFlowRequestRelationWithGuid:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        relationString = [self.delegate newCardFlowRequestRelationWithGuid:guid];
    }
    while (0);
    
    return relationString;

}


//================================================================================
// MARK:依guid取得帳號名稱
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestAccountNameWithGuid:(NSString *)guid
{
    NSString *requestAccountName = nil;
    
    do
    {
        if([guid length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.delegate respondsToSelector:@selector(newCardFlowRequestAccountNameWithGuid:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        requestAccountName = [self.delegate newCardFlowRequestAccountNameWithGuid:guid];
    }
    while (0);
    
    return requestAccountName;
}


//================================================================================
// MARK: 取得帳號匯出權限
//================================================================================
- (BOOL)accountExportAbilityWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    BOOL accountExportAbility = NO;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestAccountExportAbility)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        accountExportAbility = [self.delegate newCardFlowRequestAccountExportAbility];
    }
    while (0);
    
    return accountExportAbility;
}


//================================================================================
// MARK:  取得所有帳號列表
//================================================================================
- (BOOL)checkAndAlertChangeVisibleAccontWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    BOOL check = NO;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestCheckAndAlertChangeVisibleAccontWithContactAccessFlowController:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        check = [self.delegate newCardFlowRequestCheckAndAlertChangeVisibleAccontWithContactAccessFlowController:contactAccessFlowController];
    }
    while (0);
    
    return check;
}


//================================================================================
// MARK:  取得所有帳號列表
//================================================================================
- (NSArray *)allAccountsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;
{
    NSArray *allAccounts = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestAllAccounts)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        allAccounts = [self.delegate newCardFlowRequestAllAccounts];
    }
    while (0);
    
    return allAccounts;
}


//================================================================================
// MARK: 依card id取得名片所屬的owner guid
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestOwnerGuidWithCardID:(NSString *)cardID;
{
    NSString *ownerGuid = nil;
    
    do
    {
        if([[contactAccessFlowController userInfo] isKindOfClass:[WCCardModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCCardModel *cardModel = [contactAccessFlowController userInfo];
        
        if([cardModel.ID compare:cardID options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            break;
        }
        
        ownerGuid = cardModel.owner;
    }
    while (0);
    
    return ownerGuid;

}


//================================================================================
// MARK:id取得可檢視用戶
//================================================================================
- (NSArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
      requestSharedAccountGuidWithCardID:(NSString *)cardID
{
    NSArray *requestSharedAccountGuids = nil;
    
    do
    {
        if([[contactAccessFlowController userInfo] isKindOfClass:[WCCardModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCCardModel *cardModel = [contactAccessFlowController userInfo];
        
        if([cardModel.ID compare:cardID options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            break;
        }
        
        requestSharedAccountGuids = cardModel.sharedAccountGUIDArray;
    }
    while (0);
    
    return requestSharedAccountGuids;
}


//================================================================================
// MARK:通知選取的可檢視用戶
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
          updateVisibleAccountGuids:(NSArray *)visibleAccountGuids
                         withCardID:(NSString *)cardID
{
    WCCardModel *cardModel = nil;
    
    do
    {
        if([[contactAccessFlowController userInfo] isKindOfClass:[WCCardModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cardModel = [contactAccessFlowController userInfo];
        
        if([cardModel.ID compare:cardID options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            break;
        }
        
        cardModel.sharedAccountGUIDArray = visibleAccountGuids;
    }
    while (0);
}


//================================================================================
// MARK: 取得所有自訂欄位
//================================================================================
- (NSArray *)contactAccessFlowControllerRequestCustomFieldInfos:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSArray *customFieldInfos = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowControllerRequestCustomFieldInfos)]==YES)
    {
        customFieldInfos = [self.delegate newCardFlowControllerRequestCustomFieldInfos];
    }
    
    return customFieldInfos;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCSF專用


//==============================================================================
// 取得picklist items
//==============================================================================
- (NSArray *)salesforcePicklistItemsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController fieldName:(NSString *)fieldName defaultItemIndex:(NSInteger*)defaultItemIndex editable:(BOOL *)editable
{
    NSArray *items = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestSalesforcePicklistItemsWithFieldName:defaultItemIndex:editable:)]==YES)
    {
        items = [self.delegate newCardFlowRequestSalesforcePicklistItemsWithFieldName:fieldName defaultItemIndex:defaultItemIndex editable:editable];
    }
    
    return items;
}


//==============================================================================
//
//==============================================================================
- (NSArray *)salesforceSupportedSaveAsArrayWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    if ([self.delegate respondsToSelector:@selector(newCardFlowRequestSalesforceSupportedSaveAsArray)])
    {
        return [self.delegate newCardFlowRequestSalesforceSupportedSaveAsArray];
    }
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private WCCardModel to FieldDictionary Method

//================================================================================
//
//================================================================================
- (NSDictionary *)fieldDictionaryTransformWithObject:(id)object forPPContactMainTypeArray:(NSArray *)contactMainTypeArray
{
    NSMutableDictionary *fieldDictionary = nil;
    
    do
    {
        if([object isKindOfClass:[WCCardModel class]]==NO)
        {
            break;
        }
        
        WCCardModel *cardModel = (WCCardModel *)object;
        
        //////////////////////////////////////////////////

        fieldDictionary = [NSMutableDictionary dictionary];
        
        if(fieldDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for (NSNumber *mainTypeNumber in contactMainTypeArray)
        {
            WC_FieldType type = [WCFieldTypeConverter fieldTypeFromPPContactMainType:[mainTypeNumber integerValue]];
            
            NSArray *fieldArray = [cardModel fieldArrayWithType:type];
            
            NSMutableArray *mainTypeDataArray= [[NSMutableArray alloc] init];
            NSMutableArray *birthDayTypeDataArray= [[NSMutableArray alloc] init];
            
            
            for (WCFieldModel *fieldModel in fieldArray)
            {
                switch (type)
                {
                    case WC_FT_Name:
                    {
                        ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                        
                        for (NSInteger subType2 = WC_FST2_Name_First; subType2 <=WC_FST2_Name_Suffix; subType2++)
                        {
                            if ([fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                            {
                                WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                                NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                                
                                NSString *valueString = subFieldModel.value;
                                
// MARK: 新增名片要翻譯??
//                                if (needTranslate)
//                                {
//                                    NSError *error = nil;
//                                    NSString *translatedString =
//                                    [PPDictionaryTranslationController translationWithString:valueString
//                                                                                fromLanguage:MLS_English
//                                                                                  toLanguage:MLS_ChineseTraditional
//                                                                                       error:&error
//                                                                                  engineType:DictionaryTranslationEngineType_Google];
//                                    
//                                    if (error==nil && [translatedString length]>0)
//                                    {
//                                        valueString = translatedString;
//                                    }
//                                }
                                
                                [dataModel.propertyDictionary setObject:valueString forKey:dictKey];
                                
                                NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                                [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                                
                                dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                            }
                        }
                        
                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        
                        [mainTypeDataArray addObject:dataModel];
                        [dataModel release];
                        
                        break;
                    }
                    case WC_FT_Company:
                    {
                        ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                        
                        for (NSInteger subType2 = WC_FST2_Company_Name; subType2 <=WC_FST2_Company_JobTitle; subType2++)
                        {
                            if ([fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                            {
                                WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                                NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                                [dataModel.propertyDictionary setObject:subFieldModel.value forKey:dictKey];
            
                                NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                                [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                                
                                dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                            }
                        }
                        
                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        
                        [mainTypeDataArray addObject:dataModel];
                        [dataModel release];
                        
                        break;
                    }
                    case WC_FT_Address:
                    {
                        ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                        
                        for (NSInteger subType2 = WC_FST2_Address_Street; subType2 <=WC_FST2_Address_Location; subType2++)
                        {
                            if ([fieldModel hasFieldWithSubType2:(WC_FieldSubType2)subType2])
                            {
                                
                                WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:(WC_FieldSubType2)subType2];
                                NSNumber *dictKey = @([WCFieldTypeConverter contactSubTypeFromFieldSubType2:(WC_FieldSubType2)subType2]);
                                // !! WC_FST2_Address_Format要特殊處理
                                if (subType2==WC_FST2_Address_Format)
                                {
                                    NSString *format = subFieldModel.value;
                                    NSNumber *formatNumber = @([format integerValue]);
                                    [dataModel.propertyDictionary setObject:formatNumber forKey:dictKey];
                                }
                                else
                                {
                                    [dataModel.propertyDictionary setObject:subFieldModel.value forKey:dictKey];
                                }
                                NSString *rectString=NSStringFromCGRect(subFieldModel.recogRect);
                                [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                                
                                dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                            }
                        }
                        
                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        
                        [mainTypeDataArray addObject:dataModel];
                        [dataModel release];
                        
                        break;
                    }
                    case WC_FT_Date:
                    {
                        ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                        NSString *rectString=NSStringFromCGRect(fieldModel.recogRect);
                        NSDateFormatter *formatter_ = [[NSDateFormatter alloc] init];
                        [formatter_ setFormatterBehavior:NSDateFormatterBehavior10_4];
                        [formatter_ setDateFormat:@"yyyy/MM/dd"];
                        
                        NSString *dateString = [formatter_ stringFromDate:fieldModel.value];
                        NSNumber *dateDictKey = @(PPContactMainType_Date);
                        NSNumber *birthDictKey = @(PPContactMainType_BirthDay);
                        [formatter_ release];
                        
                        //////////////////////////////////////////////////

                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        
                        
                        if(fieldModel.subType1==WC_FST1_Date_Birthday)
                        {
                            [dataModel.imageRectDictionary setObject:rectString forKey:birthDictKey];
                            [dataModel.propertyDictionary setObject:dateString forKey:birthDictKey];
                            [birthDayTypeDataArray addObject:dataModel];
                        }
                        else
                        {
                            [dataModel.imageRectDictionary setObject:rectString forKey:dateDictKey];
                            [dataModel.propertyDictionary setObject:dateString forKey:dateDictKey];
                            [mainTypeDataArray addObject:dataModel];
                        }
                        
                        [dataModel release];
                        
                        break;
                    }
                    case WC_FT_Phone:
                    case WC_FT_Email:
                    case WC_FT_URL:
                    case WC_FT_InstantMessage:
                    case WC_FT_Note:
                    case WC_FT_Nickname:
                    case WC_FT_UnifiedBusinessNo:
                    {
                        ContactDataExchangeModel *dataModel=[[ContactDataExchangeModel alloc] init];
                        NSString *rectString = NSStringFromCGRect(fieldModel.recogRect);
                        NSNumber *dictKey = mainTypeNumber;
                        
                        [dataModel.imageRectDictionary setObject:rectString forKey:dictKey];
                        [dataModel.propertyDictionary setObject:fieldModel.value forKey:dictKey];
                        dataModel.labelText = [WCFieldTypeConverter subTypeStringWithFieldType:type associateType:fieldModel.subType1];
                        dataModel.labelType = [WCFieldTypeConverter contactLabelTypeFromFieldSubType1:fieldModel.subType1];
                        dataModel.contactFieldSource = [WCFieldTypeConverter contactFieldSourceFromFieldSource:fieldModel.source];
                        
                        [mainTypeDataArray addObject:dataModel];
                        [dataModel release];
                        
                        break;
                    }
                    default:
                        break;
                }
            }
            
            
            
            switch (type)
            {
                case WC_FT_Name:
                case WC_FT_Company:
                case WC_FT_Address:
                case WC_FT_Phone:
                case WC_FT_Email:
                case WC_FT_URL:
                case WC_FT_InstantMessage:
                case WC_FT_Note:
                case WC_FT_Nickname:
                case WC_FT_UnifiedBusinessNo:
                {
                    if([mainTypeDataArray count]>0)
                    {
                        [fieldDictionary setObject:mainTypeDataArray forKey:mainTypeNumber];
                    }
                    break;
                }
                case WC_FT_Date:
                {
                    if([mainTypeDataArray count]>0)
                    {
                        NSNumber *dictKey=[NSNumber numberWithInt:PPContactMainType_Date];
                        
                        [fieldDictionary setObject:mainTypeDataArray forKey:dictKey];
                    }
                    if([birthDayTypeDataArray count]>0)
                    {
                        NSNumber *dictKey=[NSNumber numberWithInt:PPContactMainType_BirthDay];
                        
                        [fieldDictionary setObject:birthDayTypeDataArray forKey:dictKey];
                    }
                    
                    break;
                }
                default:
                    break;
            }
            
            
            [mainTypeDataArray release];
            [birthDayTypeDataArray release];
        }
        
        
        //////////////////////////////////////////////////

        // MARK: 新增有群組選擇 ??
//        do
//        {
//            
//            NSArray *groupArray = [self prepareGroupArrayWithCardID:contactIdentifier];
//            [fieldDictionary setObject:groupArray forKey:@(PPContactMainType_Group)];
//        }while(0);

    }
    while (0);
    
    return fieldDictionary;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Methods


//================================================================================
//
//================================================================================
- (void)showSalesforceAlertWithError:(NSError *)error completion:(AlertBlock)completion
{
    self.alertComplete = completion;
    
    if(error!=nil)
    {
        if([PPAlertView canAlert]==YES)
        {
            NSString *message = nil;
            // 先跟外部詢問有沒有特別的解釋
            if([self.delegate respondsToSelector:@selector(newCardFlowRequestMessageWithError:)])
            {
                message = [self.delegate newCardFlowRequestMessageWithError:error];
            }
            
            // 沒有的話就直接使用error code敘述
            if([message length] == 0)
            {
                message = [error alertMessage];
            }

            //////////////////////////////////////////////////
            // show alert
            
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:message
                              delegate:self
                                   tag:NCFCBaseFlowControllerAlertTag_SalesforceFailed
                     cancelButtonTitle:WCNCFC_MLS_CancelEdit
                     otherButtonTitles:WCNCFC_MLS_ContinueEdit, nil];
        }
    }
    else
    {
        self.alertComplete(NO);
        self.alertComplete = nil;
    }
}

//================================================================================
//
//================================================================================
- (void)showAlertWithError:(NSError *)error title:(NSString *)title completion:(AlertBlock)completion
{
    self.alertComplete = completion;
    
    if(error!=nil)
    {
        if([PPAlertView canAlert]==YES)
        {
            NSString *message = nil;
            BOOL messageFromOutSide = NO;
            // 先跟外部詢問有沒有特別的解釋
            if([self.delegate respondsToSelector:@selector(newCardFlowRequestMessageWithError:)])
            {
                message = [self.delegate newCardFlowRequestMessageWithError:error];
            }
            
            // 沒有的話就直接使用error code敘述
            if([message length] == 0)
            {
                message = [error alertMessage];
            }
            else
            {
                messageFromOutSide = YES;
            }
            
            //////////////////////////////////////////////////
            // show alert

#if defined (PRODUCTLINE_WCSF) ||defined (PRODUCTLINE_WCO365)
            if(messageFromOutSide)
            {
                if (self.showSubscribeWhenReachMaxCount)
                {
                    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                         title:title
                                       message:message
                                      delegate:self
                             cancelButtonTitle:WCNCFC_MLS_OK
                             otherButtonTitles:WCNCFC_MLS_SubscribeNow,nil];
                }
                else
                {
                    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                         title:title
                                       message:message
                                      delegate:self
                             cancelButtonTitle:WCNCFC_MLS_OK
                             otherButtonTitles:nil];
                }
            }
            else
            {
                [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                     title:@""
                                   message:message
                                  delegate:self
                                       tag:NCFCBaseFlowControllerAlertTag_SalesforceFailed
                         cancelButtonTitle:WCNCFC_MLS_CancelEdit
                         otherButtonTitles:WCNCFC_MLS_ContinueEdit, nil];
            }
#else
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:title
                               message:message
                              delegate:self
                     cancelButtonTitle:WCNCFC_MLS_OK
                     otherButtonTitles:nil];
#endif
        }
    }
    else
    {
        self.alertComplete(NO);
        self.alertComplete = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)showAgainRecogtionAlert
{
    NSString *message = nil;
    
    if([NSStringFromClass([self class]) compare:@"NCFCCaptureFlowController"]==NSOrderedSame)
    {
        message = WCNCFC_MLS_RecogPrevCapturedImages;
    }
    else
    {
        message = WCNCFC_MLS_RecogPrevSelectedImages;
    }

    //////////////////////////////////////////////////
    
    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                         title:@""
                       message:message
                      delegate:self
                           tag:NCFCBaseFlowControllerAlertTag_AgainRecognition
             cancelButtonTitle:WCNCFC_MLS_Cancel
             otherButtonTitles:WCNCFC_MLS_OK, nil];
}


//================================================================================
// 檢查是否可以新增
//================================================================================
- (BOOL)canNewCardWithError:(NSError **)error
{
    // 數量檢查
    
    if(self.maxNewCardCount >= 0 &&
       self.maxNewCardCount <= self.curNewCardCount)
    {
        // !! 不要用PPErrorMake來產生，因為domian需要統一 !!
        if(error)
        {
            (*error) = [NSError errorWithDomain:WCNCFC
                                           code:WCNewCardFlow_Error_ReachMaxNewCardCount
                                     lineNumber:(__LINE__)
                         localizedFailureReason:WCNCFC_MLS_ReachMaxNewCardCount
                                         object:nil];
        }
        
        return NO;
    }
    
    return YES;
}


//==============================================================================
//
//==============================================================================
- (void)showNoteFromViewController:(PPViewController *)viewController noteString:(NSString *)noteString completeHandler:(NoteCompleteHandler)completeHandler
{
    NoteViewController *noteViewController = [[NoteViewController alloc] init];
    
    if(noteViewController!=nil)
    {
        noteViewController.noteCompleteHandler = completeHandler;
        noteViewController.noteEditting = YES;
        [noteViewController setTitleText:WCCV_MLS_Note];
#if defined (PRODUCTLINE_WCT)
        noteViewController.maxLength = WCT_FML_Note;
#endif
        noteViewController.noteTextString = noteString;
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:noteViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
//        [viewController.navigationController pushViewController:noteViewController animated:YES];
    }
    
    [noteViewController release];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method (Send Datasource)

//================================================================================
//
//================================================================================
- (NSArray *)requestRecogLangModels
{
    NSArray *recogLangModels = nil;
    
    if([self.datasource respondsToSelector:@selector(newCardFlowRequestRecogLangModels)]==YES)
    {
        recogLangModels = [self.datasource newCardFlowRequestRecogLangModels];
    }
    
    return recogLangModels;
}


//================================================================================
//
//================================================================================
- (NSArray *)requestRecogTypes
{
    NSArray *recogTypes = nil;
    
    if([self.datasource respondsToSelector:@selector(newCardFlowRecognizeFieldTypes)]==YES)
    {
        recogTypes = [self.datasource newCardFlowRecognizeFieldTypes];
    }
    
    return recogTypes;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)requestPhoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                                sourceValue:(NSString *)sourceValue
                                          isCompanyPhonetic:(BOOL)isCompanyPhonetic
{
    NSMutableArray *phoneticArrray = nil;
    
    if([self.datasource respondsToSelector:@selector(newCardFlowRequestPhoneticArrayWithClickedPhonetic:sourceValue:isCompanyPhonetic:)]==YES)
    {
        phoneticArrray = [self.datasource newCardFlowRequestPhoneticArrayWithClickedPhonetic:phonetic
                                                                                 sourceValue:sourceValue
                                                                           isCompanyPhonetic:isCompanyPhonetic];
    }
    
    return phoneticArrray;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Methods (send datasource)

//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)requestDisplayNameOrderWithEasternName:(BOOL)easterName
{
    WCDisplayNameOrder displayNameOrder = WCDisplayNameOrder_FirstLast;
    
    if([self.datasource respondsToSelector:@selector(displayNameOrderWithEasternName:)]==YES)
    {
        displayNameOrder = [self.datasource displayNameOrderWithEasternName:easterName];
    }
    
    return displayNameOrder;
}


//==============================================================================
//
//==============================================================================
- (BOOL)requestShouldEditNoteBeforeSave
{
    BOOL editNoteBeforeSave = NO;
    
    if([self.datasource respondsToSelector:@selector(shouldEditNoteBeforeSave)]==YES)
    {
        editNoteBeforeSave = [self.datasource shouldEditNoteBeforeSave];
    }
    
    return editNoteBeforeSave;
}


//==============================================================================
//
//==============================================================================
- (BOOL)requestShouldShowEditBeforeSave
{
    BOOL showEditBeforeSave = NO;
    
    if([self.datasource respondsToSelector:@selector(shouldShowEditViewBeforeSave)]==YES)
    {
        showEditBeforeSave = [self.datasource shouldShowEditViewBeforeSave];
    }
    
    return showEditBeforeSave;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Methods (Send delegate)

//================================================================================
//
//================================================================================
- (BOOL)requestShowWithError:(NSError *)error
{
    BOOL result = YES;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequesetShowError:)]==YES)
    {
        result = [self.delegate newCardFlowRequesetShowError:error];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSString *)requestMessageWithError:(NSError *)error
{
    NSString *message = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestMessageWithError:)])
    {
        message = [self.delegate newCardFlowRequestMessageWithError:error];
    }
    
    return message;
}


//================================================================================
//
//================================================================================
- (void)requestRecogTaskAtIndex:(NSUInteger)index totalCount:(NSUInteger)totalCount
{
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogTaskAtIndex:totalCount:)]==YES)
    {
        [self.delegate newCardFlowRequestRecogTaskAtIndex:index totalCount:totalCount];
    }
}


//================================================================================
//
//================================================================================
- (WCCardModel *)requestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogWithSourceModel:error:)])
    {
        cardModel = [self.delegate newCardFlowRequestRecogWithSourceModel:recogSourceModel
                                                                    error:error];
    }

    return cardModel;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)requestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel image:(UIImage *)image error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogWithSourceModel:image:error:)])
    {
        cardModel = [self.delegate newCardFlowRequestRecogWithSourceModel:recogSourceModel
                                                                    image:image
                                                                    error:error];
    }
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)requestClipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                        originalCardModel:(WCCardModel *)originalCardModel
                                                    error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestClipRecogWithSourceModel:originalCardModel:error:)])
    {
        cardModel = [self.delegate newCardFlowRequestClipRecogWithSourceModel:recogSourceModel
                                                            originalCardModel:originalCardModel
                                                                        error:error];
    }
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (NSArray *)requestCardModelWithCardModelDefaultGroupIDArray
{
    NSArray *defaultGroupIDArray = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestCardModelDefaultGroupIDArray)]==YES)
    {
        defaultGroupIDArray = [self.delegate newCardFlowRequestCardModelDefaultGroupIDArray];
    }
    
    return defaultGroupIDArray;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)requestCardModelWithAllGroupModelsWithCardID:(NSString *)cardID
{
    NSMutableArray *allGroupModels = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowhWithAllGroupModelsWithCardID:)]==YES)
    {
        allGroupModels = [self.delegate newCardFlowhWithAllGroupModelsWithCardID:cardID];
    }

    return allGroupModels;
}


//================================================================================
//
//================================================================================
- (NSString *)requestCardModelWithGroupNamesWithGroupIDArray:(NSArray *)groupIDArray
{
    NSString *groupNames = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowWithGroupNamesWithGroupIDArray:)]==YES)
    {
        groupNames = [self.delegate newCardFlowWithGroupNamesWithGroupIDArray:groupIDArray];
    }
    
    return groupNames;
}


//================================================================================
//
//================================================================================
- (BOOL)requestCardModelWithExistGroupNamed:(NSString *)groupNamed
{
    BOOL existGroupNamed = NO;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowWithExistGroupNamed:)]==YES)
    {
        existGroupNamed = [self.delegate newCardFlowWithExistGroupNamed:groupNamed];
    }
    
    return existGroupNamed;
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)requestCardModelWithGroupModelByNewGroupName:(NSString *)groupName error:(NSError **)error
{
    WCGroupModel *newGroupModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowWithGroupModelByNewGroupName:error:)]==YES)
    {
        newGroupModel = [self.delegate newCardFlowWithGroupModelByNewGroupName:groupName
                                                                         error:error];
    }
    
    return newGroupModel;
}


//==============================================================================
//
//==============================================================================
- (NSString*)requestSpecificString
{
    if([self.delegate respondsToSelector:@selector(requestSpecificString)]==YES)
    {
        return [self.delegate requestSpecificString];
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)requestCardModelWithGroupModelByExistGroupName:(NSString *)groupName
{
    WCGroupModel *newGroupModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowWithGroupModelByExistGroupName:)]==YES)
    {
        newGroupModel = [self.delegate newCardFlowWithGroupModelByExistGroupName:groupName];
    }
    
    return newGroupModel;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)requestRecogWithQRCodeString:(NSString *)qrCodeString
                                  newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                        error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogWithQRCodeString:newCardMode:error:)])
    {
        cardModel = [self.delegate newCardFlowRequestRecogWithQRCodeString:qrCodeString newCardMode:newCardMode error:error];
    }
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)requestRecogWithSourceString:(NSString *)sourceString
                                  newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                        error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogWithSourceString:newCardMode:error:)])
    {
        cardModel = [self.delegate newCardFlowRequestRecogWithSourceString:sourceString newCardMode:newCardMode error:error];
    }
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (void)requestRecogWithWithSourceModels:(NSMutableArray *)recogSourceModels
{
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestRecogWithWithSourceModels:)])
    {
        [self.delegate newCardFlowRequestRecogWithWithSourceModels:recogSourceModels];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)requestSaveWithCardModel:(WCCardModel *)cardModel
                    idPhotoImage:(UIImage *)idPhotoImage
                  frontSideImage:(UIImage *)frontSideImage
                   backSideImage:(UIImage *)backSideImage
                           error:(NSError **)error
{
    PPLog(NCFCBaseFlowControllerLogMask_AddCard,@" cardModel.ID:%@",cardModel.ID);
    
    BOOL result = NO;
    
    if([NSStringFromClass([self class]) compare:@"NCFCImportFlowController"]==NSOrderedSame)
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestSaveWithImportWCCardModel:idPhotoImage:frontSideImage:backSideImage:error:)]==YES)
        {
            result = [self.delegate newCardFlowRequestSaveWithImportWCCardModel:cardModel
                                                                   idPhotoImage:idPhotoImage
                                                                 frontSideImage:frontSideImage
                                                                  backSideImage:backSideImage
                                                                          error:error];
        }
    }
    else
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestSaveWithWCCardModel:idPhotoImage:frontSideImage:backSideImage:error:)]==YES)
        {
            result = [self.delegate newCardFlowRequestSaveWithWCCardModel:cardModel
                                                             idPhotoImage:idPhotoImage
                                                           frontSideImage:frontSideImage
                                                            backSideImage:backSideImage
                                                                    error:error];
        }
    }

    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)requestSaveWithSingleCardModel:(WCCardModel *)cardModel
                          idPhotoImage:(UIImage *)idPhotoImage
                        frontSideImage:(UIImage *)frontSideImage
                         backSideImage:(UIImage *)backSideImage
                              sourceID:(NSString *)sourceID
                               groupID:(NSString *)groupID
                              personID:(NSString *)personID
                                 error:(NSError **)error
{
    BOOL result = NO;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestSaveWithSingleWCCardModel:idPhotoImage:frontSideImage:backSideImage:sourceID:groupID:personID:error:)]==YES)
    {
        result = [self.delegate newCardFlowRequestSaveWithSingleWCCardModel:cardModel
                                                               idPhotoImage:idPhotoImage
                                                             frontSideImage:frontSideImage
                                                              backSideImage:backSideImage
                                                                   sourceID:sourceID
                                                                    groupID:groupID
                                                                   personID:personID
                                                                      error:error];
    }
    
    return result;
}





//================================================================================
//
//================================================================================
- (BOOL)requestSaveWithWCABCardModel:(WCABCardModel *)cardModel
                               error:(NSError **)error
{
    BOOL result = NO;
    
    if([self.delegate respondsToSelector:@selector(newCardFlowRequestSaveWithWCABCardModel:error:)])
    {
        result = [self.delegate newCardFlowRequestSaveWithWCABCardModel:cardModel
                                                                  error:error];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)requestShowPromotionFomrCaptureViewController:(WCCaptureViewController *)captureViewController
{
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowControllerShowDockPromotionFromCaptureViewController:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate newCardFlowControllerShowDockPromotionFromCaptureViewController:captureViewController];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)requestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType
{
    do
    {
        if([self.delegate respondsToSelector:@selector(newCardFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate newCardFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:storageSpaceSelectControllerSpaceType];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (NSArray *)requestDefaultSharedAccountGuidsWithCardID:(NSString *)cardID
{
    NSArray *defaultSharedAccountGuids = nil;
    
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.delegate respondsToSelector:@selector(newCardFlowRequestDefaultSharedAccountGuidsWithCardID:)]==NO)
        {
            break;
        }
        
        defaultSharedAccountGuids = [self.delegate newCardFlowRequestDefaultSharedAccountGuidsWithCardID:cardID];
    }
    while (0);
    
    return defaultSharedAccountGuids;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)requestSpaceTypeArray
{
    NSMutableArray *spaceTypeArray = nil;
    
    do
    {
        if(self.delegate==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        spaceTypeArray = [self.delegate newCardFlowRequestSpaceTypeArray];
    }
    while (0);
    
    return spaceTypeArray;
}


//================================================================================
//
//================================================================================
- (void)didFinishWithError:(NSError *)lastError
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{

        [[CardRecognitionController shareRecognitionInstance] suspendSilentRecognitionProcess:NO];
     
        //////////////////////////////////////////////////

        if([blockSelf.delegate respondsToSelector:@selector(newCardFlowDidFinishWithError:)])
        {
            [blockSelf.delegate newCardFlowDidFinishWithError:lastError];
        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance RecogSouceModel Method

//================================================================================
//
//================================================================================
- (NSString *)pathForSavingImage:(UIImage *)image
                         imageID:(NSString *)imageID
                       imageType:(WC_ImageType)imageType
                     lightEnable:(BOOL)lightEnable
{
    NSString    *imagePath  = nil;
    NSData      *imageData  = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(image==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(MAX(self.defaultImageSize.width, self.defaultImageSize.height)<MAX(image.size.width, image.size.height) ||
           MIN(self.defaultImageSize.width, self.defaultImageSize.height)<MIN(image.size.width, image.size.height))
        {
            image = [image imageScalingMaxLength:MAX(self.defaultImageSize.width,self.defaultImageSize.height)];
            
            PPLogFunction(@"%s, imageScalingMaxLength:%f",__func__,MAX(self.defaultImageSize.width,self.defaultImageSize.height));
            
            imageData = nil;
        }
        
        if(imageData==nil)
        {
            imageData = UIImageJPEGRepresentation(image, self.imageQuality);
        }
        
        //////////////////////////////////////////////////
        
        if(imageData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        imagePath = [AlbumPathController tempDataOriginalDirectoryPathWithImageName:imageID];
        
        if(imagePath!=nil)
        {
            imagePath = [imagePath stringByAppendingString:[NSString stringWithFormat:@"_%td_%d.jpg",imageType,lightEnable]];
        }
        
        if(imagePath==nil)
        {
            break;
        }

        //////////////////////////////////////////////////

        if([imageData writeToFile:imagePath atomically:YES]==NO)
        {
            imagePath = nil;
        }
        else
        {
            //////////////////////////////////////////////////
            
            if([PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_OutputRecogImage]==1 &&
               lightEnable==NO)
            {
                NSString *path = [[AlbumPathController documentDataDirectory] stringByAppendingString:[NSString stringWithFormat:@"/%td_%d.jpg",imageType,lightEnable]];
                
                if(path!=nil)
                {
                    [[NSFileManager defaultManager] copyItemAtPath:imagePath toPath:path error:nil];
                }
            }
            
            PPLogFunction(@"%s, write file ok, image.size:%@, path:%@",__func__,NSStringFromCGSize(image.size),imagePath);
        }
    }
    while (0);
    
    return imagePath;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instace RecogSourceModel Method

//================================================================================
//
//================================================================================
- (WCRecogSourceModel *)nextRecogSourceModelWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType addMode:(WCRecogSourceModelAddMode)addMode
{
    WCRecogSourceModel *nextRecogSourceModel = [[WCRecogSourceModel alloc] init];
    
    if(nextRecogSourceModel!=nil)
    {
        nextRecogSourceModel.addMode = addMode;
        nextRecogSourceModel.cardID    = cardID;
        nextRecogSourceModel.imageType = imageType;
        
        nextRecogSourceModel.groupIDArray = [self requestCardModelWithCardModelDefaultGroupIDArray];
    
        //////////////////////////////////////////////////
        
        //中文名片輸出設定
        nextRecogSourceModel.outputTranslate = [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_ChineseCardOutput];
        
    }
    
    return [nextRecogSourceModel autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instace ContactEditViewController Method

//================================================================================
//
//================================================================================
- (BOOL)showContactEditViewControllerWithCardModel:(WCCardModel *)cardModel
                                      idPhotoImage:(UIImage *)idPhotoImage
                                    frontCardImage:(UIImage *)frontCardImage
                                     rearCardImage:(UIImage *)rearCardImage
{
    BOOL result = NO;
    
    do
    {
        WCContactAccessFlowController *contactAccessFlowController = [[WCContactAccessFlowController alloc] init];
        
        if(contactAccessFlowController==nil)
        {
            break;
        }

        //////////////////////////////////////////////////

        self.headImage = idPhotoImage;
        self.frontCardImage = frontCardImage;
        self.rearCardImage  = rearCardImage;

        //////////////////////////////////////////////////

        NSString *contactGUID = nil;
        
        BOOL manual = NO;
        
        if(cardModel==nil)
        {
            manual = YES;
            
            //////////////////////////////////////////////////

            // !! 手動新增時，不會有currentEditingCardModel， 所以要自已建
            WC_CardModel *manualCardModel = [[[WC_CardModel alloc] init] autorelease];
            
            if(manualCardModel!=nil)
            {
                manualCardModel.ID = [NSString GUID];
                
                [manualCardModel setGroupIDArray:[self requestCardModelWithCardModelDefaultGroupIDArray] isInitCard:YES];
                
                //////////////////////////////////////////////////

#ifdef PRODUCTLINE_WCE
                // !! WCE 情況下，要塞 CategoryGuid
                if([[manualCardModel groupIDArray] count]>0 &&
                   [manualCardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
                {
                    [manualCardModel performSelector:@selector(setCategoryGuid:) withObject:[[manualCardModel groupIDArray] firstObject]];
                }
#endif
            
                //////////////////////////////////////////////////
                
                manualCardModel.createdTime = [NSDate date];
                manualCardModel.modifiedTime = [NSDate date];
            }

            //////////////////////////////////////////////////

            contactAccessFlowController.userInfo = manualCardModel;
            contactGUID = manualCardModel.ID;
        }
        else
        {
            contactAccessFlowController.userInfo = cardModel;
            contactGUID = cardModel.ID;
        }
        
        //////////////////////////////////////////////////

        BOOL isForWCTMode = NO;
        
#if defined(PRODUCTLINE_WCT)
        isForWCTMode = YES;
#endif
        //////////////////////////////////////////////////

        if(isForWCTMode==YES)
        {
            WCCardModel *tempCardModel = contactAccessFlowController.userInfo;
            
            NSString *selfAccountGuid = [self selfAccountGuidWithContactAccessFlowController:contactAccessFlowController];
            
            tempCardModel.creator = selfAccountGuid?:@"";
            tempCardModel.owner = selfAccountGuid?:@"";
            tempCardModel.editor = selfAccountGuid?:@"";
            
            tempCardModel.sharedAccountGUIDArray = [self requestDefaultSharedAccountGuidsWithCardID:contactGUID];
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        BOOL isAddingMyCard = NO;
        
        if([self.datasource respondsToSelector:@selector(isAddingMyCard)])
        {
            isAddingMyCard = [self.datasource isAddingMyCard];
        }
        
        if(self.superViewController.presentedViewController==nil)
        {
            [contactAccessFlowController showContactEditFromViewController:self.superViewController
                                                                    cardID:contactGUID
                                                                  delegate:blockself
                                            contacEditViewControllerLayout:isAddingMyCard?WCContactEditViewControllerLayout_MyCard:WCContactEditViewControllerLayout_Add
                                                                    manual:manual];
        }
        else
        {
            [self.superViewController dismissAnimated:YES completion:^{
                
                [contactAccessFlowController showContactEditFromViewController:blockself.superViewController
                                                                        cardID:contactGUID
                                                                      delegate:blockself
                                                contacEditViewControllerLayout:isAddingMyCard?WCContactEditViewControllerLayout_MyCard:WCContactEditViewControllerLayout_Add
                                                                        manual:manual];
            }];
        }
        
        //////////////////////////////////////////////////

        self.contactAccessFlowController = contactAccessFlowController;
        
        [contactAccessFlowController release];
        
        //////////////////////////////////////////////////
        
        result = YES;
    }
    while (0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Recognition Method

//================================================================================
//
//================================================================================
- (NSString *)recogTitleWithRecogLangCode:(NSUInteger)recogLangCode
{
    NSString *recogTitle = nil;
    
    if(self.recogLangModels==nil)
    {
        if(self.datasource!=nil ||
           [self.datasource respondsToSelector:@selector(newCardFlowRequestRecogLangModels)]==YES)
        {
            self.recogLangModels = [self.datasource newCardFlowRequestRecogLangModels];
        }
    }
    
    //////////////////////////////////////////////////
    
    //辨識語系
    for(WCKernelRecogLangModel *kernelRecoLangModel in self.recogLangModels)
    {
        recogTitle = kernelRecoLangModel.localizedString;
        
        //////////////////////////////////////////////////

        //找到目前語系
        if(kernelRecoLangModel.langCode==recogLangCode)
        {
            break;
        }
    }
    
    return recogTitle;
}


//================================================================================
//
//================================================================================
- (NSUInteger)requestRecogLangCodeWithRecogLangauge:(NSString *)recogTitle
{
    NSUInteger recogLang = EN_LANG;
    
    if(recogTitle!=nil &&
       recogTitle.length>0)
    {
        if(self.recogLangModels==nil)
        {
            if(self.datasource!=nil ||
               [self.datasource respondsToSelector:@selector(newCardFlowRequestRecogLangModels)]==YES)
            {
                 self.recogLangModels = [self.datasource newCardFlowRequestRecogLangModels];
            }
        }
        
        //////////////////////////////////////////////////

        //辨識語系
        for(WCKernelRecogLangModel *kernelRecoLangModel in self.recogLangModels)
        {
            //找到目前語系
            if([kernelRecoLangModel.localizedString compare:recogTitle]==NSOrderedSame)
            {
                recogLang = kernelRecoLangModel.langCode;
                break;
            }
        }
    }

    return recogLang;
}

//================================================================================
//
//================================================================================
- (NSArray *)recogLangTitlesWithSelectedTitle:(NSString *)selectedTitle
{
    NSMutableArray *kernelRecogLangModes = nil;
    
    do
    {
        kernelRecogLangModes = [NSMutableArray array];
        
        if(kernelRecogLangModes==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.datasource==nil ||
           [self.datasource respondsToSelector:@selector(newCardFlowRequestRecogLangModels)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.recogLangModels==nil)
        {
            self.recogLangModels = [self.datasource newCardFlowRequestRecogLangModels];
        }
        
        //////////////////////////////////////////////////

        for(WCKernelRecogLangModel *kernelRecoLangModel in self.recogLangModels)
        {
            if([kernelRecoLangModel.localizedString compare:selectedTitle]==NSOrderedSame)
            {
                [kernelRecogLangModes insertObject:kernelRecoLangModel.localizedString atIndex:0];
            }
            else
            {
                [kernelRecogLangModes addObject:kernelRecoLangModel.localizedString];
            }
        }
    }
    while (0);
    
    return kernelRecogLangModes;
}


//================================================================================
// 開始呼叫外部辨識
//================================================================================
- (void)prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:(WCNewCardFlowControllerAddCardMode)addCardMode
                                                  fromViewController:(UIViewController *)fromViewController;
{
    __block NSError *returnError = nil;
    
    do
    {
        NSUInteger numberOfCard = [self numberOfCardFromRecogSourceModels];
        
        if(numberOfCard==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
  
        // 單張辨識
        if(addCardMode==WCNewCardFlowControllerAddCardMode_Single)
        {
            __block PPBusyView *busyView = nil;
            
            if([fromViewController isKindOfClass:[WCImageBrowseViewController class]]==YES)
            {
                WCImageBrowseViewController *browseImageViewController = (WCImageBrowseViewController *)fromViewController;
                
                [browseImageViewController showBusyView:YES withSuperView:[UIApplication sharedApplication].keyWindow];
            }
            else
            {
                busyView = [[PPBusyView alloc] initWithSuperView:[UIApplication sharedApplication].keyWindow];
            }
            
            //////////////////////////////////////////////////

            __block typeof(self) blockself = self;
         
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^(void){
                
                WCCardModel *frontCardModel = nil;
                
                WCRecogSourceModel *frontCardRecogSourceModel = [blockself.recogSourceModels firstObject];

                //////////////////////////////////////////////////

                UIImage *frontCardImage = nil;
                
                //////////////////////////////////////////////////

                //基座模式單張名片情況，前名片圖處理
                if(frontCardRecogSourceModel.dockMode==YES)
                {
                    // 後面判斷是否顯示編輯與備註時會用到, dock不套用規則
                    blockself.adjustFlowBySettings = NO;
                    frontCardImage = [UIImage imageWithContentsOfFile:(NSString *)frontCardRecogSourceModel.imageSource];
                    
                    //////////////////////////////////////////////////

                    frontCardImage = [self resetImageBeforeRecognizing:frontCardImage
                                         withCardRecognitionController:nil
                                                           recogSource:frontCardRecogSourceModel];
                    
                    //////////////////////////////////////////////////

                    frontCardModel = [blockself requestRecogWithSourceModel:frontCardRecogSourceModel
                                                                      image:frontCardImage
                                                                      error:&returnError];
                    
                    //////////////////////////////////////////////////

                    frontCardImage = [self resetImageBeforeSaving:frontCardImage
                                    withCardRecognitionController:nil
                                                      recogSource:frontCardRecogSourceModel];
                    
                }
                else
                {
                    // 單張拍照，要判斷是否顯示編輯與備註
                    self.adjustFlowBySettings = YES;
                    frontCardModel = [blockself requestRecogWithSourceModel:frontCardRecogSourceModel error:&returnError];
                    
                    //////////////////////////////////////////////////

                    if([frontCardRecogSourceModel lightImageSource]!=nil)
                    {
                        frontCardImage = [CardRecognitionController imageFromRecogSource:frontCardRecogSourceModel lightImage:YES];
                    }
                    else
                    {
                        frontCardImage = [CardRecognitionController imageFromRecogSource:frontCardRecogSourceModel lightImage:NO];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    frontCardImage = [self resetImageBeforeSaving:frontCardImage
                                    withCardRecognitionController:nil
                                                      recogSource:frontCardRecogSourceModel];
                }
                
                //////////////////////////////////////////////////
                
                UIImage *rearCardImage = nil;
                
                NSArray *groupIDArray = [blockself requestCardModelWithCardModelDefaultGroupIDArray];
                
                [frontCardModel setGroupIDArray:groupIDArray isInitCard:YES];
                
                //////////////////////////////////////////////////

#ifdef PRODUCTLINE_WCE
                // !! WCE 情況下，要塞 CategoryGuid
                if([[frontCardModel groupIDArray] count]>0 &&
                   [frontCardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
                {
                    [frontCardModel performSelector:@selector(setCategoryGuid:) withObject:[[frontCardModel groupIDArray] firstObject]];
                }
#endif
                //////////////////////////////////////////////////
                
                WCRecogSourceModel *rearCardRecogSourceModel = nil;
                WCCardModel *rearCardModel = nil;
                
                //背面圖處理
                if([self.recogSourceModels count]>1)
                {
                    rearCardRecogSourceModel = [blockself.recogSourceModels lastObject];
                    
                    //////////////////////////////////////////////////
                    
                    //基座模式單張名片情況，背面名片圖處理
                    if(rearCardRecogSourceModel.dockMode==YES)
                    {
                        rearCardImage = [UIImage imageWithContentsOfFile:(NSString *)rearCardRecogSourceModel.imageSource];
                        
                        //////////////////////////////////////////////////
                        
                        rearCardImage = [self resetImageBeforeRecognizing:rearCardImage
                                            withCardRecognitionController:nil
                                                              recogSource:rearCardRecogSourceModel];
                        
                        //////////////////////////////////////////////////
                        
                        rearCardModel = [blockself requestRecogWithSourceModel:rearCardRecogSourceModel
                                                                         image:rearCardImage
                                                                         error:&returnError];
                        
                        //////////////////////////////////////////////////
                        
                        rearCardImage = [self resetImageBeforeSaving:rearCardImage
                                       withCardRecognitionController:nil
                                                         recogSource:rearCardRecogSourceModel];
                        
                    }
                    else
                    {
                        if([self.recogSourceModels count]>1)
                        {
                            if([rearCardRecogSourceModel lightImageSource]!=nil)
                            {
                                rearCardImage = [CardRecognitionController imageFromRecogSource:rearCardRecogSourceModel lightImage:YES];
                            }
                            else
                            {
                                rearCardImage = [CardRecognitionController imageFromRecogSource:rearCardRecogSourceModel lightImage:NO];
                            }
                        }
                        
                        //////////////////////////////////////////////////
                        
                        rearCardModel = [blockself requestRecogWithSourceModel:rearCardRecogSourceModel error:&returnError];
                        
                        //////////////////////////////////////////////////
                        
                        rearCardImage = [self resetImageBeforeSaving:rearCardImage
                                       withCardRecognitionController:nil
                                                         recogSource:rearCardRecogSourceModel];
                    }
                    
                    [rearCardModel setGroupIDArray:groupIDArray isInitCard:YES];
                    
                    //////////////////////////////////////////////////
                    
                    [frontCardModel combineCard:rearCardModel];
                    
                    frontCardModel.backRecogLang = rearCardModel.frontRecogLang;
                }
                
                //////////////////////////////////////////////////
                
                //清從所有暫存辨識資訊
                [self.recogSourceModels removeAllObjects];
                
                //////////////////////////////////////////////////
                
                [frontCardModel retain];
                [frontCardImage retain];
                [rearCardImage retain];
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    if(busyView!=nil)
                    {
                        [busyView removeFromSuperview];
                        [busyView release];
                        busyView = nil;
                    }
                    else if([fromViewController isKindOfClass:[WCImageBrowseViewController class]]==YES)
                    {
                        WCImageBrowseViewController *browseImageViewController = (WCImageBrowseViewController *)fromViewController;
                        
                        [browseImageViewController showBusyView:NO withSuperView:[UIApplication sharedApplication].keyWindow];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    //單張名片進編輯元件
                    // !!  只有從相機拍照後，才要跑這個流程，其他都用原本流程
                    // dock mode不套用
                    BOOL shouldShowEdit = YES;
                    BOOL isCapture = [self isKindOfClass:NSClassFromString(@"NCFCCaptureFlowController")];
                    
                    if(isCapture && self.adjustFlowBySettings==YES)
                    {
                        shouldShowEdit = [self requestShouldShowEditBeforeSave];
                    }
                    
                    if(shouldShowEdit)
                    {
                        [blockself showContactEditViewControllerWithCardModel:frontCardModel
                                                                 idPhotoImage:nil
                                                               frontCardImage:frontCardImage
                                                                rearCardImage:rearCardImage];
                        
                        
                        [frontCardModel release];
                        [frontCardImage release];
                        [rearCardImage release];
                    }
                    else
                    {
                        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                            
                            self.frontCardImage = frontCardImage;
                            self.rearCardImage = rearCardImage;
                            
                            //////////////////////////////////////////////////
                            // !! 如果有開啟編輯時編輯備註的設定，要先進入備註頁面
                            // 只進備註，算未校正
                            
                            BOOL shouldShowNoteBeforeSave = [self requestShouldEditNoteBeforeSave];
                            
                            if(shouldShowNoteBeforeSave)
                            {
                                
                                __block typeof(self) blockSelf = self;
                                __block WCFieldModel *noteField = [[[blockSelf.contactAccessFlowController.userInfo fieldArrayWithType:WC_FT_Note] firstObject] retain];
                                
                                dispatch_async(dispatch_get_main_queue(), ^{
                                    
                                    [blockSelf.superViewController dismissAnimated:YES completion:^{
                                        
                                        [blockSelf showNoteFromViewController:blockSelf.superViewController
                                                                   noteString:(noteField.value?:@"")
                                                              completeHandler:^(NoteViewController *noteViewController, PPButton *ppButton, UIControlEvents controllEvent) {
                                            
                                            dispatch_async(dispatch_get_main_queue(), ^{
                                                
                                                if (ppButton.tag==NoteViewControllerButtonTag_Done)
                                                {
                                                    if([noteViewController.noteTextString length]>0)
                                                    {
                                                        if(noteField==nil)
                                                        {
                                                            noteField = [WCFieldModel newFieldModel];
                                                            noteField.type = WC_FT_Note;
                                                            [frontCardModel addField:noteField];
                                                        }
                                                        noteField.value = noteViewController.noteTextString;
                                                    }
                                                    
                                                    __block typeof(self) blockSelf = self; 
                                                    
                                                    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                                                        
                                                        // !!沒進編輯要使用多張的儲存流程，才會參考儲存到系統聯絡人的值
                                                        [blockSelf requestSaveWithCardModel:frontCardModel idPhotoImage:blockSelf.headImage frontSideImage:blockSelf.frontCardImage backSideImage:blockSelf.rearCardImage error:&returnError];
                                                        
//                                                        [blockSelf saveCardProcessWithCardModel:frontCardModel];
                                                        [frontCardModel release];
                                                        [frontCardImage release];
                                                        [rearCardImage release];

                                                        //////////////////////////////////////////////////
                                                        dispatch_async(dispatch_get_main_queue(), ^{
                                                            [blockSelf.superViewController dismissAnimated:YES completion:^{
                                                                [blockSelf didFinishWithError:nil];
                                                            }];
                                                        });
                                                    });

                                                }
                                                else
                                                {
                                                    __block typeof(self) blockSelf = self;
                                                    
                                                    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                                                        
                                                        [blockSelf saveCardProcessWithCardModel:frontCardModel];
                                                        [frontCardModel release];
                                                        [frontCardImage release];
                                                        [rearCardImage release];
                                                        
                                                        //////////////////////////////////////////////////
                                                        dispatch_async(dispatch_get_main_queue(), ^{
                                                            [blockSelf.superViewController dismissAnimated:YES completion:^{
                                                                [blockSelf didFinishWithError:nil];
                                                            }];
                                                        });
                                                    });
                                                }
                                                
                                                [noteField release];
                                                

                                                
                                            });
                                        }];
                                    }];
                                    
                                });
                                
                            }
                            else
                            {
                                // !! 不進編輯也不進備註，直接儲存，算未校正
                                // !!沒進編輯要使用多張的儲存流程，才會參考儲存到系統聯絡人的值
                                [self requestSaveWithCardModel:frontCardModel idPhotoImage:self.headImage frontSideImage:self.frontCardImage backSideImage:self.rearCardImage error:&returnError];
                                [frontCardModel release];
                                [frontCardImage release];
                                [rearCardImage release];
                                
                                //////////////////////////////////////////////////
                                __block typeof(self) blockSelf = self;
                                dispatch_async(dispatch_get_main_queue(), ^{
                                    [blockSelf.superViewController dismissAnimated:YES completion:^{
                                        [blockSelf didFinishWithError:nil];
                                    }];
                                });

                            }

                        });

                    }
                });
            });
        }
        else
        {
            CardRecognitionController *cardRecognitionController = [CardRecognitionController shareRecognitionInstance];
            
            if(cardRecognitionController==nil)
            {
                returnError = PPErrorParameterInvalidity(returnError);
                break;
            }
            
            [cardRecognitionController setDelegate:self];
            [cardRecognitionController setTotalSource:self.recogSourceModels.count];
            
            [cardRecognitionController startRecogWithMode:RecognitionOperationMode_Silent sources:self.recogSourceModels];
         
            //////////////////////////////////////////////////

            //清從所有暫存辨識資訊
            [self.recogSourceModels removeAllObjects];
            
            //////////////////////////////////////////////////
            
            self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCountForUserCount];
            
            //////////////////////////////////////////////////

            [self.superViewController dismissViewControllerAnimated:YES completion:^{
            }];
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(returnError!=nil)
    {
        [self showAlertWithError:returnError title:returnError.localizedFailureReason completion:nil];
    }
}


//================================================================================
//
//================================================================================
- (NSUInteger)numberOfWholeCard
{
    WCRecogSourceModel *sourceModel = nil;
    NSInteger count = 0;

    for(NSUInteger i=0; i<[self.recogSourceModels count]; i++)
    {
        sourceModel = [self.recogSourceModels objectAtIndex:i];

        if(sourceModel.imageType == WC_IT_FrontSide)
        {
            count++;
        }
    }
    
    return count;
}
@end
