//
//  AlbumPathController.m
//
//  Created by Mike on 2011/6/3.
//  Copyright 2011年 Penpower. All rights reserved.
//

#import <NSString+Additions.h>
#import "NSFileManager+Additions.h"
#import "AlbumPathController.h"
#import "PPLogController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation AlbumPathController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (NSString *)dumpDirectory
{
	NSString *path = [[AlbumPathController documentsDirectory] stringByAppendingPathComponent:@"Dump"];
    
    if(path!=nil && [path length]>0) 
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
	
	return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)documentDataDirectory
{
    return [self documentDataDirectoryWithCheck:YES];
}


//================================================================================
//
//================================================================================
+ (NSString *)documentDataDirectoryWithCheck:(BOOL)check
{
    NSString *path = [[AlbumPathController documentsDirectory]stringByAppendingPathComponent:@"Data"];
    
    if(check==YES &&  path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
    
	return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)documentDirectoryPathWithAlbumPathControllerImageSize:(AlbumPathControllerImageSize)imageSize
                                                            imageID:(NSInteger)imageID
                                      albumPathControllerImageStyle:(AlbumPathControllerImageStyle)style;
{
    NSString *path = nil;
    
    switch(imageSize)
    {
        case AlbumPathControllerImageSize_Small:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Small_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Small_%zd.jpg", imageID]];
            }
            
            break;
        }
        case AlbumPathControllerImageSize_Medium:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Medium_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Medium_%zd.jpg", imageID]];
            }
            
            break;
        }
        case AlbumPathControllerImageSize_Large:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Large_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Large_%zd.jpg", imageID]];
            }
            
            
            break;
        }
        case AlbumPathControllerImageSize_Original:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Original_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController documentDataDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Original_%zd.jpg", imageID]];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
    
    return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tmpDirectoryPathWithAlbumPathControllerImageSize:(AlbumPathControllerImageSize)imageSize
                                                       imageID:(NSInteger)imageID
                                 albumPathControllerImageStyle:(AlbumPathControllerImageStyle)style
{
    NSString *path = nil;
    
    switch(imageSize)
    {
        case AlbumPathControllerImageSize_Small:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController tempDataSmallDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Small_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController tempDataSmallDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Front_Small_%zd.jpg", imageID]];
            }
            
            break;
        }
        case AlbumPathControllerImageSize_Medium:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController tempDataLargeDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Medium_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController tempDataMediumDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Front_Medium_%zd.jpg", imageID]];
            }

            break;
        }
        case AlbumPathControllerImageSize_Large:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController tempDataLargeDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Large_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController tempDataLargeDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Front_Large_%zd.jpg", imageID]];
            }
            
            
            break;
        }
        case AlbumPathControllerImageSize_Original:
        {
            if(style==AlbumPathControllerImageStyle_Back)
            {
                path = [[AlbumPathController tempDataOriginalDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Back_Original_%zd.jpg", imageID]];
            }
            else
            {
                path = [[AlbumPathController tempDataOriginalDirectory] stringByAppendingPathComponent:[NSString stringWithFormat:@"Front_Original_%zd.jpg", imageID]];
            }
         
            break;
        }
        default:
        {
            break;
        }
    }
    
    return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataDirectory
{
    return [AlbumPathController tempDataDirectoryWithCheck:YES];
}


//================================================================================
// tmp/data/Original
//================================================================================
+ (NSString *)tempDataOriginalDirectory
{
    NSString *path = [[AlbumPathController tempDataDirectory] stringByAppendingPathComponent:@"Original"];
	
    if(path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
	
	return path;
}


//================================================================================
// tmp/data/Small
//================================================================================
+ (NSString *)tempDataSmallDirectory
{
    NSString *path = [[AlbumPathController tempDataDirectory] stringByAppendingPathComponent:@"Small"];
	
    if(path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
	
	return path;
}


//================================================================================
// tmp/data/Medium
//================================================================================
+ (NSString *)tempDataMediumDirectory
{
    NSString *path = [[AlbumPathController tempDataDirectory] stringByAppendingPathComponent:@"Medium"];
	
    if(path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
	
	return path;

}


//================================================================================
// tmp/data/Large
//================================================================================
+ (NSString *)tempDataLargeDirectory
{
    NSString *path = [[AlbumPathController tempDataDirectory] stringByAppendingPathComponent:@"Large"];
	
    if(path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
    
	return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataDirectoryWithCheck:(BOOL)check
{
    NSString *path = [[AlbumPathController tempDirectory]stringByAppendingPathComponent:@"Data"];
        
    if(check==YES &&  path!=nil && [path length]>0)
    {
        NSError *error;
        
        [NSFileManager createDirectoryAtPath:path error:&error];
    }
    
	return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataSmallDirectoryPathWithImageName:(NSString *)imageName
{
    NSString *path = nil;
    
    path = [[AlbumPathController tempDataSmallDirectory] stringByAppendingPathComponent:imageName];
    
    return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataMediumDirectoryPathWithImageName:(NSString *)imageName
{
    NSString *path = nil;
    
    path = [[AlbumPathController tempDataMediumDirectory] stringByAppendingPathComponent:imageName];
    
    return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataLargeDirectoryPathWithImageName:(NSString *)imageName
{
    NSString *path = nil;
    
    path = [[AlbumPathController tempDataLargeDirectory] stringByAppendingPathComponent:imageName];
    
    return path;
}


//================================================================================
//
//================================================================================
+ (NSString *)tempDataOriginalDirectoryPathWithImageName:(NSString *)imageName
{
    NSString *path = nil;
    
    path = [[AlbumPathController tempDataOriginalDirectory] stringByAppendingPathComponent:imageName];
    
    return path;
}


//================================================================================
//
//================================================================================
+ (void)clearTempDirectory
{
    NSFileManager *fileManager   = [NSFileManager defaultManager];
    NSString      *tempDirectory = [PPPathController tempDirectory];
    
    if(fileManager!=nil && tempDirectory!=nil && [tempDirectory length]>0)
    {
        NSArray *tempContents = [fileManager contentsOfDirectoryAtPath:tempDirectory error:nil];
        
        for(NSString *content in tempContents)
        {
            [NSFileManager removeItemAtPath:[tempDirectory stringByAppendingPathComponent:content] error:nil];
        }
    }
}


//================================================================================
//
//================================================================================
+ (void)removeDocumentDirectory
{
    NSError *error;
    
    [NSFileManager removeItemAtPath:[AlbumPathController documentsDirectory]
                              error:&error];
}


//================================================================================
//
//================================================================================
+ (void)removeDumpDirectory
{
    NSError *error;
    
    [NSFileManager removeItemAtPath:[AlbumPathController dumpDirectory]
                              error:&error];
}


//================================================================================
//
//================================================================================
+ (void)removeItemPath:(NSString *)itemPath
{
    NSError *error;
    
    if([NSFileManager removeItemAtPath:itemPath error:&error]==NO)
    {
        PPLogFunction(@"error:%@",error);
    }
    else
    {
        PPLogFunction(@"successful remove file path:%@",itemPath);
    }
}

@end
