//
//  WCMultiSelectViewController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/9.
//  Modified by Andrew on 2016/3/23.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCMultiSelectViewController.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCCardModel.h"

// caterories
#import "PPButton+Factory.h"

// views
#import "PPNavigationBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//static PPMessageComposeViewController* ppMessageController = nil;
NSString *const MultiSelectView_SelectAll = @"MultiSelect_SelectAll";

////////////////////////////////////////////////////////////////////////////////////////////////////
// button tag
typedef NS_ENUM(NSInteger, WCMultiSelectViewControllerButtonTag)
{
    WCMultiSelectViewControllerButtonTag_None = 0,
    WCMultiSelectViewControllerButtonTag_SelectAll,
    WCMultiSelectViewControllerButtonTag_Close
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCMultiSelectViewController  ()
<
UINavigationControllerDelegate,
PPButtonDelegate
>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonSelectAll;
@property (nonatomic, retain) PPButton *ppButtonClose;

@property (nonatomic, retain) PPBarView *ppToolBar;

@property (nonatomic, retain) NSArray *toolbarConstraints;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCMultiSelectViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods

//==============================================================================
//
//==============================================================================
+ (void)initialize
{
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithMode:(PPSIC_Mode)mode
{
    self = [super initWithMode:mode];
    if (self)
    {
        self.enableMultiSelectMode = YES;
        self.reserveBottomToolbarSpace = 44;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    [self removeToolbarConstraints];
    [self removeNavigationBarView];
    [self removeMainUI];
    
    self.navigationBarTitleString = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle

//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self prepareNavigationBarView];
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    // 如果有預設選取的話，移動到第一個選取的地方
    [self scrollFirstCheckedCellToVisible];
    
    //////////////////////////////////////////////////
    // 通知外部可以開始呈現導覽Guide
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(wcMultiSelectViewControllerShowGuideIfNeeded:)]==YES)
    {
        [self.delegate wcMultiSelectViewControllerShowGuideIfNeeded:self];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    [self removeNavigationBarView];
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    
    //////////////////////////////////////////////////
    [self resetToolbarConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    //////////////////////////////////////////////////
    [self resetToolbarConstraints];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setNavigationBarTitleString:(NSString *)navigationBarTitleString
{
    [_navigationBarTitleString release];
    _navigationBarTitleString = [navigationBarTitleString retain];
    
    //////////////////////////////////////////////////
    
    if (self.ppNavigationBarView!=nil)
    {
        [self.ppNavigationBarView.titleLabel setText:self.navigationBarTitleString];
        [self.ppNavigationBarView.titleLabel sizeToFit];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui

//==============================================================================
//
//==============================================================================
- (void)prepareNavigationBarView
{
    if(self.ppButtonClose==nil)
    {
        self.ppButtonClose = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                             tag:WCMultiSelectViewControllerButtonTag_Close
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                 imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if (self.ppButtonSelectAll==nil)
    {
        
        self.ppButtonSelectAll = [PPButton ppButtonWithIconImageName:MultiSelectView_SelectAll
                                                                 tag:WCMultiSelectViewControllerButtonTag_SelectAll
                                                            delegate:self
                                               normalBackgroundColor:nil
                                          highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                     imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];;
        
    }
    //////////////////////////////////////////////////
    
    if(_ppNavigationBarView==nil)
    {
        _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(wcMultiSelectViewController:selectedContactChangeWithCount:)]==YES)
        {
            [self.delegate wcMultiSelectViewController:self selectedContactChangeWithCount:[self.multiSelectCardIDSet count]];
        }
         
        //////////////////////////////////////////////////
        if (self.ppButtonClose)
        {
            PPBarViewItemModel * leftItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonClose];
            leftItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;

            [self.ppNavigationBarView  setItemModels:@[leftItemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        if (self.ppButtonSelectAll)
        {
            PPBarViewItemModel * rightItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonSelectAll];
            rightItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;

            [self.ppNavigationBarView  setItemModels:@[rightItemModel] forBlockType:PPBarViewBlockType_Right];
        }

        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeNavigationBarView
{
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppNavigationBarView  = nil;
    self.ppButtonSelectAll = nil;
    self.ppButtonClose = nil;
}


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    do
    {
        //////////////////////////////////////////////////
        // 確認有按鈕清單才進行創建ToolBar
        
        if(_ppToolBar==nil)
        {
            _ppToolBar  = [[PPBarView alloc] init];
        }
        if (self.ppToolBar==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.ppToolBar setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.ppToolBar setStyle:PPBarViewStyle_Average];
        [self.ppToolBar setBackgroundColor:self.navigationBarBackgroundColor];
            
        //////////////////////////////////////////////////
        // 創建按鈕各自的blockModel，並添加入toolBar內
        NSArray *toolBarButtonArray = nil;
        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(bottomToolBarButtonArrayInWCMultiSelectViewController:)]==YES)
        {
            toolBarButtonArray = [self.delegate bottomToolBarButtonArrayInWCMultiSelectViewController:self];
            if (toolBarButtonArray==nil)
            {
                break;
            }
        }
        
        NSMutableArray *blockModels = [NSMutableArray array];
        for (PPButton *button in toolBarButtonArray)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:button];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [blockModels addObject:itemModel];
        }
            
        if ([blockModels count]>0)
        {
            [self.ppToolBar setItemModels:blockModels forBlockType:PPBarViewBlockType_Left];
        }
            
        //////////////////////////////////////////////////
        
        [self.view addSubview:self.ppToolBar];
    } while (0);
    
    //////////////////////////////////////////////////
    
    [self resetToolbarConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeToolbarConstraints];
    
    [self.ppToolBar removeFromSuperview];
    self.ppToolBar = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layoutconstraints

//==============================================================================
//
//==============================================================================
- (void)resetToolbarConstraints
{
    if (self.ppToolBar==nil)
    {
        return;
    }
    
    [self removeToolbarConstraints];
    //////////////////////////////////////////////////
    NSInteger toolbarHeight = PPBarViewDefaultHeightForNavigationBarNormal;
    
    if(@available(iOS 11, *))
    {
        toolbarHeight += self.view.safeAreaInsets.bottom;
        self.ppToolBar.addtionBlockEdgeInsets = UIEdgeInsetsZero;
        self.ppToolBar.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
    }
    
    
    self.reserveBottomToolbarSpace = toolbarHeight;

    NSDictionary *views = @{@"ppToolbar":self.ppToolBar};
    NSDictionary *metrics = @{@"ToolbarHeight":@(toolbarHeight)};
    
    //////////////////////////////////////////////////
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppToolbar]|"
                                                                                  options:NSLayoutFormatDirectionLeftToRight
                                                                                  metrics:nil
                                                                                     views:views]];
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[ppToolbar(ToolbarHeight)]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.toolbarConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.toolbarConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeToolbarConstraints
{
    if (self.toolbarConstraints)
    {
        [self.view removeConstraints:self.toolbarConstraints];
        self.toolbarConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - focus methods

//==============================================================================
//
//==============================================================================
- (void)scrollFirstCheckedCellToVisible
{
    NSInteger section = 0;
    NSInteger row = 0;
    for (WCCardSectionModel *cardSectionModel in self.allCardSectionArray)
    {
        row = 0;
        for (WCCardModel *cardModel in cardSectionModel.cardArray)
        {
            if (cardModel.isSelected == YES)
            {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:row inSection:section]
                                      atScrollPosition:UITableViewScrollPositionMiddle
                                              animated:YES];
                return ;
            }
            row ++;
        }
        
        section ++;
    }
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate

//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag) {
        case WCMultiSelectViewControllerButtonTag_SelectAll:
        {
            [self onSelectAll];
            
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(wcMultiSelectViewController:selectedContactChangeWithCount:)]==YES)
            {
                [self.delegate wcMultiSelectViewController:self selectedContactChangeWithCount:[self.multiSelectCardIDSet count]];
            }

            break;
        }
        case WCMultiSelectViewControllerButtonTag_Close:
        {
            [self goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableView Delegate Methods

//===============================================================================
//
//===============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    [self onDidSelectCellWithIndexPath:indexPath];
    
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(wcMultiSelectViewController:selectedContactChangeWithCount:)]==YES)
    {
        [self.delegate wcMultiSelectViewController:self selectedContactChangeWithCount:[self.multiSelectCardIDSet count]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTableViewControllerProtocol

//==============================================================================
//
//==============================================================================
- (UIImage *)cachedThumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(wcMultiSelectViewController:cachedThumbnailImageWithCardID:)])
    {
        return [self.delegate wcMultiSelectViewController:self cachedThumbnailImageWithCardID:cardID];
    }
    
    return nil;
}

//==============================================================================
//
//==============================================================================
- (UIImage *)thumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(wcMultiSelectViewController:thumbnailImageWithCardID:)])
    {
        return [self.delegate wcMultiSelectViewController:self thumbnailImageWithCardID:cardID];
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
- (void)didClickCheckButtonWithCell:(WCCardHolderCell *)cell
{
    NSIndexPath *cellIndexPath = [self.tableView indexPathForCell:cell];
    [self onDidSelectCellWithIndexPath:cellIndexPath];
    
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(wcMultiSelectViewController:selectedContactChangeWithCount:)]==YES)
    {
        [self.delegate wcMultiSelectViewController:self selectedContactChangeWithCount:[self.multiSelectCardIDSet count]];
    }
}

@end
