//
//  WCMapPinAnnotationView.h
//
//
//  Created by Howard on 2015/12/30.
//
//

#import <UIKit/UIKit.h>
#import <MapKit/MKPinAnnotationView.h>

// Define
#import "WCMapPinAnnotationViewDatasource.h"
#import "WCMapPinAnnotationViewDelegate.h"

// Category
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Parameter Define

typedef NS_ENUM(NSUInteger,WCMapPinAnnotationViewButtonTag)
{
    WCMapPinAnnotationViewButtonTag_Navigation,
};

@interface WCMapPinAnnotationView : MKAnnotationView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property 

@property (nonatomic,assign) id<WCMapPinAnnotationViewDelegate> delegate;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Life Cycle Method

- (id)initWithAnnotation:(id <MKAnnotation>)annotation reuseIdentifier:(NSString *)reuseIdentifier;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Fetch Image Method

- (void)fetchDataWithProtocol:(id<WCMapPinAnnotationViewDatasource>)protocol;

- (BOOL)tapViewWithPoint:(CGPoint)point;
- (void)setActive:(BOOL)active;
- (void)reuseForAnnotationView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)stopFetchData;

@end
