//
//  WCMapAnnotationPopoverShapeView.m
//
//  Created by Howard on 2016/1/7.
//
//

#import "WCMapAnnotationPopoverShapeView.h"

// Define
#import "WCMapViewController+ResourceDefine.h"

// Category
#import "PPButton+Factory.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCMapAnnotationPopoverShapeView

@interface WCMapAnnotationPopoverShapeView()

@property (nonatomic,retain) UIImageView *headImageView;
@property (nonatomic,retain) CAShapeLayer *borderLayer;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCMapAnnotationPopoverShapeView

@implementation WCMapAnnotationPopoverShapeView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocatin Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.backgroundColor = [UIColor whiteColor];
        
        //////////////////////////////////////////////////

        _navigationButton = [[PPButton ppButtonWithIconImageName:ImageNameForWCMapViewControllerTableViewCellDisclosureIndicator
                                                             tag:0
                                                        delegate:nil
                                           normalBackgroundColor:[UIColor clearColor]
                                      highlightedBackgroundColor:nil
                                                 imageEdgeInsets:UIEdgeInsetsZero] retain];
        
        if(_navigationButton!=nil)
        {
            [_navigationButton setTitleColor:[UIColor grayColor]];
            [_navigationButton addControlEvents:UIControlEventTouchUpInside];
            
            [self addSubview:_navigationButton];
        }
        
        //////////////////////////////////////////////////

        _nameLabel = [[UILabel alloc] init];
        
        if(_nameLabel!=nil)
        {
            [self addSubview:_nameLabel];
        }
        //////////////////////////////////////////////////

        _headImageView = [[UIImageView alloc] init];
        
        if(_headImageView!=nil)
        {
            
            [self addSubview:_headImageView];
        }
        
        //////////////////////////////////////////////////
        
        _borderLayer = [[CAShapeLayer layer] retain];
        
        if(_borderLayer!=nil)
        {
            _borderLayer.strokeColor = WCMapViewControllerAnnotationViewBorderColor.CGColor;
            _borderLayer.fillColor = nil;
            _borderLayer.lineWidth = WCMapViewControllerAnnotationViewBorderWidth;
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_navigationButton removeFromSuperview];
    [_navigationButton release];
    _navigationButton = nil;
    
    [_nameLabel removeFromSuperview];
    [_nameLabel release];
    _nameLabel = nil;
    
    [_headImageView removeFromSuperview];
    [_headImageView release];
    _headImageView = nil;
    
    [_headImage release];
    _headImage = nil;
    
    [_borderLayer removeFromSuperlayer];
    _borderLayer = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of Subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    //扣掉三角形高度
    CGFloat height = self.bounds.size.height - WCMapAnnotationPopoverShapeView_TriangleHeight;
    
    //////////////////////////////////////////////////
    
    self.headImageView.frame = CGRectMake(WCMapAnnotationPopoverShapeViewContentInset.left,
                                          (height-WCMapAnnotationPopoverShapeView_HeadImageViewSize.height)/2,
                                          WCMapAnnotationPopoverShapeView_HeadImageViewSize.width,
                                          WCMapAnnotationPopoverShapeView_HeadImageViewSize.height);
    
    //////////////////////////////////////////////////
    
    self.nameLabel.frame = CGRectMake(self.headImageView.frame.origin.x+self.headImageView.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left,
                                      0,
                                      self.bounds.size.width-WCMapAnnotationPopoverShapeView_HeadImageViewSize.width-WCMapAnnotationPopoverShapeView_NavigaionButtonSize.width-2*WCMapAnnotationPopoverShapeViewContentInset.left-2*WCMapAnnotationPopoverShapeViewContentInset.right,
                                      height);
    
    //////////////////////////////////////////////////
    
    self.navigationButton.frame = CGRectMake(self.nameLabel.frame.origin.x+self.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.right,
                                             (height-WCMapAnnotationPopoverShapeView_NavigaionButtonSize.height)/2,
                                             WCMapAnnotationPopoverShapeView_NavigaionButtonSize.width,
                                             WCMapAnnotationPopoverShapeView_NavigaionButtonSize.height);
    
    //////////////////////////////////////////////////

    if(self.headImageView.image==nil)
    {
        [self updateHeadImage:self.headImage];
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setHeadImage:(UIImage *)headImage
{
    [headImage retain];
    
    [_headImage release];

    _headImage = headImage;
    
    //////////////////////////////////////////////////
    
    if(self.headImageView.frame.size.width>0 &&
       self.headImageView.frame.size.height>0)
    {
        [self updateHeadImage:self.headImage];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)updateHeadImage:(UIImage *)headImage
{
    do
    {
        @autoreleasepool
        {
            if(headImage==nil)
            {
                break;
            }

            //////////////////////////////////////////////////
            
            UIBezierPath *bezierPath = [UIBezierPath bezierPath];
            
            if(bezierPath==nil)
            {
                break;
            }
            
            [bezierPath addArcWithCenter:CGPointMake(self.headImageView.bounds.size.width/2, self.headImageView.bounds.size.height/2)
                                  radius:MIN(self.headImageView.bounds.size.width/2,self.headImageView.bounds.size.height/2)
                              startAngle:0
                                endAngle:2*M_PI
                               clockwise:YES];
            
            //////////////////////////////////////////////////
            
            if(self.headImageView.frame.size.width==0 ||
               self.headImageView.frame.size.height==0)
            {
                self.headImageView.frame = CGRectMake(0,
                                                      0,
                                                      WCMapAnnotationPopoverShapeView_HeadImageViewSize.width,
                                                      WCMapAnnotationPopoverShapeView_HeadImageViewSize.height);
            }
            //////////////////////////////////////////////////

            CAShapeLayer *shapeLayer = [CAShapeLayer layer];
            
            if(shapeLayer==nil)
            {
                break;
            }
            
            [shapeLayer setFrame:self.headImageView.bounds];
            [shapeLayer setPath:bezierPath.CGPath];
     
            self.headImageView.layer.mask = shapeLayer;
 
            //////////////////////////////////////////////////
            
            //邊界
            self.borderLayer.path = bezierPath.CGPath;
            self.borderLayer.frame = self.headImageView.bounds;
            
            if(self.borderLayer.superlayer==nil)
            {
                [self.headImageView.layer addSublayer:self.borderLayer];
            }
            
            //////////////////////////////////////////////////

            [self.headImageView setImage:headImage];
        }
        
    }while (0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)recycle
{
    self.nameLabel.text = @"";
    self.headImageView.image = nil;
}

@end
