//
//  WCMapContactRowModel.m
//  
//
//  Created by Howard on 2016/1/5.
//
//

#import "WCMapContactRowModel.h"

// Define
#import "WCMapViewController+ResourceDefine.h"

@implementation WCMapContactRowModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocatin Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_kiloMeterDistance release];
    _kiloMeterDistance = nil;
    
    [_companyText release];
    _companyText = nil;
    
    [_jobTitleText release];
    _jobTitleText = nil;
    
    [_locationString release];
    _locationString = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (WCMapContactRowModel *)mapContactRowModelFromCardModel:(WCCardModel *)cardModel
                                           locationString:(NSString *)locationString
                                                 distance:(CGFloat)distance
{
    WCMapContactRowModel *rowModel = [[WCMapContactRowModel alloc] init];
    
    if(rowModel!=nil)
    {
        // MARK: 連絡人列表顯示
        rowModel.text = cardModel.displayName;
        
        if([rowModel.text length]<=0)
        {
            rowModel.text = WCMV_MLS_NoName;
        }
        
        //////////////////////////////////////////////////
        
        rowModel.jobTitleText = cardModel.displayJobTitle;
        
        rowModel.companyText = cardModel.displayCompany;
        
        //////////////////////////////////////////////////
        
        rowModel.kiloMeterDistance = @(distance/1000);
        rowModel.detailText = [NSString stringWithFormat:@"%.2f KM",[rowModel.kiloMeterDistance floatValue]];
        
        //////////////////////////////////////////////////
        
        rowModel.locationString = locationString;
        
        //////////////////////////////////////////////////

        rowModel.object = cardModel.ID;
    }
    
    return [rowModel autorelease];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSComparisonResult)displayDistanceSortWithMapContactRowModel:(WCMapContactRowModel *)rowModel
{
    if(rowModel.kiloMeterDistance==nil)
    {
        return NSOrderedAscending;
    }
    else if(self.kiloMeterDistance==nil)
    {
        return NSOrderedDescending;
    }
    else
    {
        return [self.kiloMeterDistance compare:rowModel.kiloMeterDistance];
    }
}


//================================================================================
//
//================================================================================
- (NSString *)distanceTextFormatForMapViewControllerDistanceStyle:(WCMapViewControllerDistanceStyle)mapViewControllerDistanceStyle
{
    if(mapViewControllerDistanceStyle==WCMapViewControllerDistanceStyle_KiloMeter)
    {
        return [NSString stringWithFormat:@"%.2f KM",[self.kiloMeterDistance floatValue]];
    }
    else
    {
        return [NSString stringWithFormat:@"%.2f mi",[self.kiloMeterDistance floatValue]*WCMapViewController_MIPerKiloMeter];
    }
}
@end
