//
//  UIBezierPath+PopoverStyle.m
//  
//
//  Created by Howard on 2016/1/7.
//
//

#import "UIBezierPath+PopoverStyle.h"

@implementation UIBezierPath (PopoverStyle)

//================================================================================
//
//================================================================================
+ (UIBezierPath *)upPopoverStyleBezierPathFromMainRect:(CGRect)mainRect
                                         triangleWidth:(CGFloat)triangleWidth
                                        triangleHeight:(CGFloat)triangleHeight
                                                radius:(float)radius
{
    UIBezierPath *linkRectPath = [UIBezierPath bezierPath];
    
    linkRectPath.lineCapStyle = kCGLineCapRound;
    linkRectPath.lineJoinStyle = kCGLineCapRound;
    
    CGPoint oringin = mainRect.origin;
    CGSize size = mainRect.size;
    
    // 起始點
    [linkRectPath moveToPoint:CGPointMake(oringin.x+radius, oringin.y)];
    
    //往右
    [linkRectPath addLineToPoint:CGPointMake(oringin.x+size.width-radius, oringin.y)];
    
    //畫弧
    [linkRectPath addQuadCurveToPoint:CGPointMake(oringin.x+size.width, oringin.y+radius)
                         controlPoint:CGPointMake(oringin.x+size.width, oringin.y)];
    
    //往下
    [linkRectPath addLineToPoint:CGPointMake(oringin.x+size.width, oringin.y+size.height-radius)];
    
    //畫弧
    [linkRectPath addQuadCurveToPoint:CGPointMake(oringin.x+size.width-radius, oringin.y+size.height)
                         controlPoint:CGPointMake(oringin.x+size.width,oringin.y+size.height)];
    
    
    [linkRectPath addLineToPoint:CGPointMake((oringin.x+size.width+triangleWidth)/2, oringin.y+size.height)];
    
    [linkRectPath addLineToPoint:CGPointMake((oringin.x+size.width)/2, oringin.y+size.height+triangleHeight)];
    
    [linkRectPath addLineToPoint:CGPointMake((oringin.x+size.width-triangleWidth)/2, oringin.y+size.height)];
    
    //////////////////////////////////////////////////
    
    [linkRectPath addLineToPoint:CGPointMake(oringin.x+radius, oringin.y+size.height)];
    [linkRectPath addQuadCurveToPoint:CGPointMake(oringin.x, oringin.y+size.height-radius)
                         controlPoint:CGPointMake(oringin.x, oringin.y+size.height)];
    
    //////////////////////////////////////////////////
    
    [linkRectPath addLineToPoint:CGPointMake(oringin.x, oringin.y+radius)];
    [linkRectPath addQuadCurveToPoint:CGPointMake(oringin.x+radius, oringin.y)
                         controlPoint:CGPointMake(oringin.x, oringin.y)];

    [linkRectPath closePath];
    
    return linkRectPath;
}
@end
