//
//  PPSectionController+MapSection.m
//  
//
//  Created by Howard on 2016/1/30.
//
//

#import "PPSectionController+MapSection.h"

// Model
#import "WCMapContactRowModel.h"

@implementation PPSectionController (MapSection)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSIndexPath *)indexPathForCardID:(NSString *)cardID forSearching:(BOOL)searching
{
    NSIndexPath *indexPath = nil;
    
    @autoreleasepool
    {
        do
        {
            if(cardID==nil ||
               [cardID length]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSArray *sectionModels = [self sectionModelsForSearching:searching];
            
            for(PPSectionModel *sectionModel in sectionModels)
            {
                for(WCMapContactRowModel *mapContactRowModel in [sectionModel rowModels])
                {
                    if([cardID compare:[mapContactRowModel object] options:NSCaseInsensitiveSearch]==NSOrderedSame)
                    {
                        indexPath = [NSIndexPath indexPathForRow:[[sectionModel rowModels] indexOfObject:mapContactRowModel]
                                                       inSection:[sectionModels indexOfObject:sectionModel]];
                        
                        [indexPath retain];
                        
                        break;
                    }
                }
                
                //////////////////////////////////////////////////

                if(indexPath!=nil)
                {
                    break;
                }
            }
            
        }
        while (0);
    }
    
    return [indexPath autorelease];
}

@end
