//
//  WCMapViewController+ResourceDefine.h
//
//
//  Created by Howard on 2015/12/29.
//
//

#ifndef PPLocationController_ResourceDefine_h
#define PPLocationController_ResourceDefine_h

#import "NSString+Additions.h"
#import "UIColor+HexString.h"
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  Layout design

static CGFloat const WCMapViewController_MapViewPortraitRatio = 0.4;
static CGFloat const WCMapViewController_TableViewMaxWidth = 320;
static CGFloat const WCMapViewController_TableViewRowHeight = 72;
static CGSize  const WCMapViewControllerTabelViewCellButtonSize = {40,40};
static CGPoint const WCMapViewController_DefaultAnnotationViewOrigin = {8,-65};

// WCMapAnnotationPopoverShapeView
static CGSize  const WCMapAnnotationPopoverShapeView_HeadImageViewSize = {32,32};
static CGSize  const WCMapAnnotationPopoverShapeView_NavigaionButtonSize = {24,24};
static UIEdgeInsets const WCMapAnnotationPopoverShapeViewContentInset = {0,8,0,8};

static CGFloat const WCMapAnnotationPopoverShapeViewSizeHeight = 63;
static CGFloat const WCMapAnnotationPopoverShapeView_TriangleHeight = 15;
static CGFloat const WCMapAnnotationPopoverShapeView_TriangleEdgeLength = 25;
static CGFloat const WCMapAnnotationPopoverShapeView_Radius = 15;

static CGFloat const WCMapViewControllerAnnotationViewBorderWidth = 1.0f;
static CGFloat const WCMapViewControllerAnnotationViewAlpha = 0.8f;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MultiLanguage String

static NSString * const WCMV = @"WCMapViewController";

#define WCMV_MLS_NeighborhoodContact [@"MLS_NeighborhoodContact" localizedFromTable:WCMV]
#define WCMV_MLS_SelectContact [@"MLS_SelectContact" localizedFromTable:WCMV]
#define WCMV_MLS_SelectMap [@"MLS_SelectMap" localizedFromTable:WCMV]
#define WCMV_MLS_AppleMap [@"MLS_AppleMap" localizedFromTable:WCMV]
#define WCMV_MLS_BaiduMap [@"MLS_BaiduMap" localizedFromTable:WCMV]
#define WCMV_MLS_GoogleMap [@"MLS_GoogleMap" localizedFromTable:WCMV]
#define WCMV_MLS_Cancel [@"MLS_Cancel" localized]
#define WCMV_MLS_NoName [@"MLS_NoName" localized]
#define WCMV_MLS_OK [@"MLS_OK" localized]
#define WCMV_MLS_LocationDenied [@"MLS_LocationDenied" localizedFromTable:WCMV]
#define WCMV_MLS_LocationNetworkError [@"MLS_LocationNetworkError" localizedFromTable:WCMV]
#define WCMV_MLS_LocaitonUnKnowError [@"MLS_LocaitonUnKnowError" localizedFromTable:WCMV]
#define WCMV_MLS_NoInformationNearbyContacts [@"MLS_NoInformationNearbyContacts" localizedFromTable:WCMV]
#define WCMV_MLS_QueryLocationBusy [@"MLS_QueryLocationBusy" localizedFromTable:WCMV]
#define WCMV_MLS_ConnectInternet [@"MLS_ConnectInternet" localized]

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Button Image Name

static NSString * const ImageNameForWCMapViewControllerButtonHome = @"WCMapViewControllerButtonHome";
static NSString * const ImageNameForWCMapViewControllerButtonLocation = @"WCMapViewControllerButtonLocation";
static NSString * const ImageNameForWCMapViewControllerTableViewCellDisclosureIndicator = @"WCMapViewControllerTableViewCellDisclosureIndicator";
static NSString * const ImageNameForWCMapViewControllerButtonInfo = @"WCMapViewControllerButtonInfo";
static NSString * const ImageNameForWCMapViewControllerButtonOther = @"WCMapViewControllerButtonOther";
static NSString * const ImageNameForWCMapViewControllerButtonSelf = @"WCMapViewControllerButtonSelf";
static NSString * const ImageNameForWCMapViewControllerDefaultHead = @"WCMapViewControllerDefaultHead";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Color

#define WCMapViewControllerAnnotationViewBorderColor [UIColor colorWithHexString:@"#fa9e25"]

#endif /* PPLocationController_ResourceDefine_h */
