//
//  WCMakeVirtualCardController.m
//  Pods
//
//  Created by sanhue on 2016/10/3.
//
//

#import "WCMakeVirtualCardController.h"
#import "WCFieldModel+DisplayName.h"

@interface WCMakeVirtualCardController () <PPMakeVirtualCardControllerDataSource>

@property (atomic, retain) NSMutableDictionary *cardDataForDraw;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCMakeVirtualCardController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.dataSource = self;
        self.cardDataForDraw = [[[NSMutableDictionary alloc] init] autorelease];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.dataSource = nil;
    self.cardDataForDraw = nil;
    self.cardModel = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//==============================================================================
//
//==============================================================================
- (void)setDataSource:(id<PPMakeVirtualCardControllerDataSource>)dataSource
{
    if(dataSource!=nil)
    {
        [super setDataSource:self];
    }
    else
    {
        [super setDataSource:nil];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setCardModel:(WCCardModel *)cardModel
{
    [cardModel retain];
    [_cardModel release];
    _cardModel = cardModel;
    //////////////////////////////////////////////////
    [self loadFirstDataWithFieldType:WC_FT_Name cardModel:self.cardModel];
    [self loadFirstDataWithFieldType:WC_FT_Company cardModel:self.cardModel];
    [self loadFirstDataWithFieldType:WC_FT_Phone cardModel:self.cardModel];
    [self loadFirstDataWithFieldType:WC_FT_Address cardModel:self.cardModel];
    [self loadFirstDataWithFieldType:WC_FT_URL cardModel:self.cardModel];
    [self loadFirstDataWithFieldType:WC_FT_Email cardModel:self.cardModel];

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (private) get data methods from WCBizCardMaker


//==============================================================================
// * FUNCTION:loadFirstDataWithFieldType
// * DESCRIPTION:讀取資料集裡的第一筆資料
// * PARAMETERS:<in>type=>資料形態,cardModel=>文字資料集
// * RETURNED:none
// * CREATED:
// * BY:sawyer
// * COMMENTS: 請依據需操作的資料設訂對應模式，避免建立不必要的物件。
//==============================================================================
- (void)loadFirstDataWithFieldType:(WC_FieldType)type cardModel:(WCCardModel *)cardModel
{
    NSArray *arrayList = [cardModel fieldArrayWithType:type];
    WCFieldModel *field;
    NSString *valueString = nil;
    
    if ([arrayList count])
    {
        switch (type)
        {
            case WC_FT_Name:
            {
                field = [arrayList objectAtIndex:0];
                
                if((valueString = [field stringDisplayName]))
                {
                    [self.cardDataForDraw setObject:valueString forKey:@(WC_FT_Name)];
                }
                
                break;
            }
                
            case WC_FT_Company:
            {
                field = [arrayList objectAtIndex:0];
                
                if((valueString = [field valueWithSubType2:WC_FST2_Company_Name]))
                    [self.cardDataForDraw setObject:valueString forKey:@(WC_FST2_Company_Name)];
                
                if((valueString = [field valueWithSubType2:WC_FST2_Company_Department]))
                    [self.cardDataForDraw setObject:valueString forKey:@(WC_FST2_Company_Department)];
                
                if((valueString = [field valueWithSubType2:WC_FST2_Company_JobTitle]))
                    [self.cardDataForDraw setObject:valueString forKey:@(WC_FST2_Company_JobTitle)];
                
                break;
            }
                
            case WC_FT_Address:
            {
                // !! 只紀錄不同subtype的第1筆資料
                for (field in arrayList)
                {
                    if(![self.cardDataForDraw objectForKey:@(field.subType1)])
                    {
                        // 取得地址字串
                        NSInteger bcrLang = [cardModel recognitionlanguageWithFieldSource:field.source];                
                        valueString = [field stringDisplayAddressWithBCRLanguage:bcrLang];
                        
                        if(valueString)
                            [self.cardDataForDraw setObject:valueString forKey:@(field.subType1)];
                    }
                }
                
                break;
            }
                
            case WC_FT_Email:
            case WC_FT_URL:
            case WC_FT_Phone:
            {
                // !! 只紀錄不同subtype的第1筆資料
                for (field in arrayList)
                {
                    if(![self.cardDataForDraw objectForKey:@(field.subType1)])
                    {
                        if((valueString = [field value]))
                            [self.cardDataForDraw setObject:valueString forKey:@(field.subType1)];
                    }
                }
                
                break;
            }
                
            default:
                break;
        }// end switch (type)
    }// end if ([arrayList count])
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPMakeVirtualCardControllerDataSource


//==============================================================================
//
//==============================================================================
- (NSString *)ppMakeVirtualCardController:(PPMakeVirtualCardController *)ppMakeVirtualCardController
textForPPMakeVirtualCardControllerMainType:(PPMakeVirtualCardControllerMainType)ppMakeVirtualCardControllerMainType
{
    NSArray *fieldModels = [self.cardModel fieldArrayWithType:WC_FT_Name];
    if([fieldModels count]==0)
    {
        return nil;
    }
    
    return [self.cardDataForDraw objectForKey:@(WC_FT_Name)];
}


//==============================================================================
//
//==============================================================================
- (NSString *)ppMakeVirtualCardController:(PPMakeVirtualCardController *)ppMakeVirtualCardController
textForPPMakeVirtualCardControllerSubType:(PPMakeVirtualCardControllerSubType)ppMakeVirtualCardControllerSubType
{
    NSString *result = nil;
    
    switch (ppMakeVirtualCardControllerSubType)
    {
        case PPMakeVirtualCardControllerSubType_Address_Work:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Address_Work)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Address_Home:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Address_Home)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Address_Other:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Address_Other)];
            break;
        }
            
        case PPMakeVirtualCardControllerSubType_Company_Department:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST2_Company_Department)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Company_JobTitle:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST2_Company_JobTitle)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Company_Name:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST2_Company_Name)];
            break;
        }
            
        case PPMakeVirtualCardControllerSubType_Email_Work:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Email_Work)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Email_Home:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Email_Home)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Email_Other:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Email_Other)];
            break;
        }
            
        case PPMakeVirtualCardControllerSubType_Phone_Mobile:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_Mobile)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_iPhone:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_iPhone)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_Work:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_Work)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_Main:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_Main)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_Home:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_Home)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_Other:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_Other)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_WorkFax:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_WorkFax)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_Phone_HomeFax:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_Phone_HomeFax)];
            break;
        }
            
        case PPMakeVirtualCardControllerSubType_URL_HomePage:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_URL_HomePage)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_URL_Work:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_URL_Work)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_URL_Home:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_URL_Home)];
            break;
        }
        case PPMakeVirtualCardControllerSubType_URL_Other:
        {
            result = [self.cardDataForDraw objectForKey:@(WC_FST1_URL_Other)];
            break;
        }
        default:
            break;
    }
    
    return result;
}


@end
