//
//  WCMultiLayerGroupEditViewController.m
//  ADAL
//
//  Created by sanhue on 2018/3/8.
//

#import "WCMultiLayerGroupEditViewController.h"

//define
#import "WCAppearanceDefine.h"
#import "WCGroupAccessFlowController+ResourceDefine.h"
#import "WCGroupDefine.h"

// category
#import "PPButton+Factory.h"
#import "UIViewController+Additions.h"

// view
#import "PPNavigationBarView.h"

// controller
#import "WCToastController.h"
#import "PPNetworkReachabilityController.h"
#import "PPAlertController.h"


typedef NS_ENUM(NSInteger, WCMLGEVC_ButtonTag)
{
    WCMLGEVC_ButtonTag_Back=0,
    WCMLGEVC_ButtonTag_Add,
    WCMLGEVC_ButtonTag_Rename,
    WCMLGEVC_ButtonTag_Move,
    WCMLGEVC_ButtonTag_Delete
};
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCMultiLayerGroupEditViewController () <PPButtonDelegate>
@property (nonatomic, retain) PPNavigationBarView *navigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonAdd;

@property (nonatomic, retain) PPBarView *toolBarView;
@property (nonatomic, retain) PPButton *ppButtonRename;
@property (nonatomic, retain) PPButton *ppButtonMove;
@property (nonatomic, retain) PPButton *ppButtonDelete;

@property (nonatomic, retain) NSArray *layoutConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCMultiLayerGroupEditViewController






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.style = WCGroupViewStyle_Name;
        self.activeCellByDefault = YES;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(_navigationBarView==nil)
    {
        _navigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.navigationBarView!=nil)
    {
        self.navigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        self.navigationBarView.titleLabel.text = self.titleString;
        
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:WCMLGEVC_ButtonTag_Back
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        if(self.ppButtonBack!=nil)
        {
            //////////////////////////////////////////////////
            
            [self.navigationBarView setViews:@[self.ppButtonBack] forBlockType:PPBarViewBlockType_Left];
        }
        
        NSMutableArray *rightButtons = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        self.ppButtonAdd = [PPButton ppButtonWithIconImageName:WCGAFC_IconAdd
                                                           tag:WCMLGEVC_ButtonTag_Add
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
//        self.ppButtonAdd.ppGuideIndex = WCGroupViewControllerGuideIndex_Add;
        [rightButtons addObject:self.ppButtonAdd];

        if([rightButtons count]>0)
        {
            [self.navigationBarView setViews:rightButtons forBlockType:PPBarViewBlockType_Right];
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.navigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    if(_toolBarView==nil)
    {
        _toolBarView = [[PPBarView alloc] initWithFrame:CGRectZero];
    }
    
    [self.toolBarView setTranslatesAutoresizingMaskIntoConstraints:NO];
    self.toolBarView.style = PPBarViewStyle_Average;
    
    
    [self.view addSubview:self.toolBarView];
    
    //////////////////////////////////////////////////
    NSMutableArray *bottons = [NSMutableArray array];
    
    if(self.ppButtonRename==nil)
    {
        self.ppButtonRename = [PPButton ppButtonWithIconImageName:nil
                                                              tag:WCMLGEVC_ButtonTag_Rename
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                  imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if(self.ppButtonRename!=nil)
    {
        [self.ppButtonRename setTitle:WCGAFC_MLS_RenameButton maxWidth:0.0];
        [bottons addObject:self.ppButtonRename];
    }

    //////////////////////////////////////////////////
    if( self.ppButtonMove==nil)
    {
        self.ppButtonMove = [PPButton ppButtonWithIconImageName:nil
                                                            tag:WCMLGEVC_ButtonTag_Move
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    if(self.ppButtonMove!=nil)
    {
        [self.ppButtonMove setTitle:WCGAFC_MLS_MoveButton maxWidth:0.0];
        [bottons addObject:self.ppButtonMove];
    }
    
    //////////////////////////////////////////////////
    if(self.ppButtonDelete==nil)
    {
        self.ppButtonDelete = [PPButton ppButtonWithIconImageName:nil
                                                              tag:WCMLGEVC_ButtonTag_Delete
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                  imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    if(self.ppButtonDelete!=nil)
    {
        [self.ppButtonDelete setTitle:WCGAFC_MLS_DeleteButton maxWidth:0.0];
        [bottons addObject:self.ppButtonDelete];
    }

    //////////////////////////////////////////////////
    if([bottons count])
    {
        [self.toolBarView setViews:bottons forBlockType:PPBarViewBlockType_Left];
    }

    [self resetLayoutConstraints];
}

//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    self.ppButtonAdd.delegate = nil;
    self.ppButtonAdd = nil;
    
    self.navigationBarView = nil;
    
    self.ppButtonRename =nil;
    self.ppButtonMove = nil;
    self.ppButtonDelete = nil;
    
    [self.toolBarView removeFromSuperview];
    self.toolBarView = nil;
}


//==============================================================================
//
//==============================================================================
- (BOOL)hasNetWork
{
    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
        
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:Common_FailedToConnectInternet
                                                position:PPToastPositionCenter];
        return NO;
    }
    return YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.toolBarView==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSInteger toolbarHeight = PPBarViewDefaultHeightForToolBar;
    
    if(@available(iOS 11, *))
    {
        toolbarHeight += self.view.safeAreaInsets.bottom;
        
        self.reserveBottomHeight = toolbarHeight;
        self.toolBarView.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
    }
    
    
    NSDictionary *views = @{@"toolBarView":self.toolBarView};
    NSDictionary *metrics = @{@"ToolBarHeight":@(toolbarHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[toolBarView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[toolBarView(ToolBarHeight)]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.toolBarView layoutIfNeeded];
//        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Button action


//==============================================================================
//
//==============================================================================
- (void)onClickMove
{
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    NSArray *selectedItems = [self selectedItems];
    if(WCMLGEVC_ButtonTag_Back!=ppButton.tag)
    {
        if ([selectedItems count]==0)
        {
            [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_NonCategoryBeSelected position:PPToastPositionCenter];
            return ;
        }
    }
    switch (ppButton.tag)
    {
        case WCMLGEVC_ButtonTag_Add:
        {
            if ([self hasNetWork]==NO)
            {
                return;
            }

            // 因為這邊只會單選
            WCGroupModel *groupModel = [selectedItems firstObject];
            if (groupModel.ID==WC_GID_Unfiled)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_CantAddCategoryOnUnfiled position:PPToastPositionCenter];
                return;
            }
            
            // From XXX不能新增子類別
            if ([groupModel.helper length]>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_CantAddCategoryFromHeler position:PPToastPositionCenter];
                return;
            }
            [self showGroupEditorWithName:nil];
            break;
        }
        case WCMLGEVC_ButtonTag_Rename:
        {
            if ([self hasNetWork]==NO)
            {
                return;
            }

            // 因為這邊只會單選
            WCGroupModel *groupModel = [selectedItems firstObject];
            // 系統類別不能更名
            if (groupModel.editable==NO ||
                [groupModel.helper length]>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_SystemCategoryCantBeRename position:PPToastPositionCenter];
                return;
            }
            
            // From XXX不能更名
            if ([groupModel.helper length]>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_CantBeRenameFromHeler position:PPToastPositionCenter];
                return;
            }
            [self showGroupEditorWithName:groupModel.name];
            break;
        }
        case WCMLGEVC_ButtonTag_Move:
        {
            if ([self hasNetWork]==NO)
            {
                return;
            }

            WCGroupModel *groupModel = [selectedItems firstObject];
            if (groupModel.editable==NO)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_SystemCategoryCantBeMove position:PPToastPositionCenter];
                return;
            }
            
            // From XXX不能移動
            if ([groupModel.helper length]>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_CantBeMoveFromHeler position:PPToastPositionCenter];
                return;
            }
            [self moveGroupModel:groupModel];
            break;
        }
        case WCMLGEVC_ButtonTag_Delete:
        {
            if ([self hasNetWork]==NO)
            {
                return;
            }
            
            WCGroupModel *groupModel = [selectedItems firstObject];
            
            // 系統聯絡人不能刪除
            if (groupModel.editable==NO)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_SystemCategoryCantBeDeleted position:PPToastPositionCenter];
                return;
            }
            
            // !! 內容不是空的也不能刪
            if([groupModel.subGroups count]>0 ||
               groupModel.cardCount>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCGAFC_MLS_RemoveCategroyNotEmpty position:PPToastPositionCenter];
                return ;
            }

            PPAlertController *alertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                         message:WCGAFC_MLS_ConfirmDelete
                                                                                  preferredStyle:UIAlertControllerStyleAlert];
            [alertViewController addAction:[UIAlertAction actionWithTitle:Common_MLS_Ok style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
                [self deleteGroupModel:groupModel];                
            }]];
            
            [alertViewController addAction:[UIAlertAction actionWithTitle:Common_MLS_Cancel style:UIAlertActionStyleCancel handler:nil]];

            [self presentViewController:alertViewController animated:YES completion:nil];

            break;
        }
        case WCMLGEVC_ButtonTag_Back:
        default:
        {
            [self goBackAnimated:YES];
            break;
        }
    }
}


@end
