//
//  WCGroupTreeViewController.m
//  Example
//
//  Created by sanhue on 2018/2/27.
//  Copyright © 2018年 penpower. All rights reserved.
//

#import "WCGroupTreeViewController.h"
// define
#import "WCGroupDefine.h"

//categroy
#import "WCGroupAccessFlowController+ResourceDefine.h"
#import "NSObject+PPBusyView.h"
#import "NSError+Custom.h"

// controller
#import "WCAddOrEditGroupViewController.h"
#import "WCMultiLayerGroupPickerViewController.h"
#import "WCToastController.h"
#import "PPAlertController.h"

@interface WCGroupTreeViewController () <WCGroupViewDelegate, WCGroupViewDataSource>

// data
@property (nonatomic, retain) NSArray *defaultlayoutConstraints;
@property (nonatomic, retain, readwrite) NSArray *datas;
@property (nonatomic, retain) NSArray *preSelectedGroups;

@property (nonatomic, retain) NSString * selectedGroupGuid;

@property (nonatomic, retain) WCGroupModel *lastSelectedModel;
@end

@implementation WCGroupTreeViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        if (self.groupView==nil)
        {
            self.groupView = [[[WCGroupView alloc] initWithFrame:CGRectZero] autorelease];
        }
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.defaultlayoutConstraints = nil;
    self.datas = nil;
    self.preSelectedGroups = nil;
    self.lastSelectedModel = nil;
    self.selectedGroupGuid = nil;
    
    self.titleString = nil;
    
    [self _removeMainUI];
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
//    [self.view setBackgroundColor:[UIColor whiteColor]];
    //////////////////////////////////////////////////
    [self _prepareMainUI];
    [self prepareDataWithCompletion:nil];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    WCGroupModel *groupModel = [self.groupView.treeView itemForSelectedRow];

    self.selectedGroupGuid = groupModel.guid;
    
    [self _removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)_prepareMainUI
{
    if (self.groupView==nil)
    {
        self.groupView = [[[WCGroupView alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    [self.groupView setTranslatesAutoresizingMaskIntoConstraints:NO];
    self.groupView.delegate = self;
    self.groupView.dataSource = self;
    self.groupView.style = self.style;
    self.groupView.exclusiveWithOther = self.exclusiveWithOther;
    self.groupView.activeWhenExpandCell = self.activeWhenExpandCell;
    self.groupView.enablePinButton = self.enablePin;
    [self.groupView setBackgroundColor:[UIColor whiteColor]];
    [self.view addSubview:self.groupView];
    //////////////////////////////////////////////////

    [self _resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)_removeMainUI
{
    [self _removeLayoutConstraints];
    [self.groupView removeFromSuperview];
    self.groupView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)_resetLayoutConstraints
{
    if(!self.groupView)
    {
        return ;
    }
    
    [self _removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"groupView":self.groupView,
                            @"topLayoutGuide":self.topLayoutGuide
                            };
    NSDictionary *metrics = @{@"reserveBottomHeight":@(self.reserveBottomHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[groupView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[topLayoutGuide][groupView]-(reserveBottomHeight)-|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.defaultlayoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.defaultlayoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)_removeLayoutConstraints
{
    if (self.defaultlayoutConstraints)
    {
        [self.view removeConstraints:self.defaultlayoutConstraints];
        self.defaultlayoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupView Control


//==============================================================================
// 展開到某個node為止
//==============================================================================
- (void)expandToNode:(WCGroupModel*)node
{
    WCGroupModel *targetModel = node;
    NSMutableArray *parentModels = [NSMutableArray array];

    while (targetModel.superGroupGuid)
    {
        if (targetModel)
        {
            [parentModels addObject:targetModel];
        }
        targetModel = [self findGroupModelWithGuid:targetModel.superGroupGuid withGroups:self.datas];
    }
    
    [parentModels enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        
        [self.groupView expendItem:obj withAnimated:NO];
    }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - selection


//==============================================================================
//
//==============================================================================
- (NSArray*)selectedItems
{
    return [self.groupView.treeView itemsForSelectedRows];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private


//==============================================================================
//
//==============================================================================
- (NSString *)messageWithError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(groupTreeViewController:requestErrorMessageForError:)])
    {
        return [self.delegate groupTreeViewController:self requestErrorMessageForError:error];
    }
    
    return nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Prepare date


//==============================================================================
//
//==============================================================================
- (void)prepareDataWithCompletion:(void(^)(void))completion
{

    if([self.delegate respondsToSelector:@selector(groupsWithWCGroupTreeViewController:error:)]==NO)
    {
        return ;
    }
    
    __block typeof(self) blockSelf = self;
    
    [self setBusy:@(YES)];
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSArray *datas = nil;
        NSError *error = nil;
        
        // 如果有資料，就不重取, 不然lastSelectedModel就沒用了
        if (self.datas==nil)
        {
            datas = [blockSelf.delegate groupsWithWCGroupTreeViewController:self error:&error];
        }
        else
        {
            datas = self.datas;
        }
        
        if ([self.delegate respondsToSelector:@selector(selectedGroupsWithWCGroupTreeViewController:error:)])
        {
            self.preSelectedGroups = [self.delegate selectedGroupsWithWCGroupTreeViewController:self error:&error];
        }
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if (error)
            {
                NSError *customError = PPErrorMake(WCGroupTreeViewControllerErroCode_GetCategoryListFailed, WCGAFC_MLS_GetCategoryListFailed, error);
                NSString *errorMessage = [self messageWithError:customError];
                if ([errorMessage length])
                {
                    [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                              title:@""
                                                            message:errorMessage
                                             showFromViewController:self animated:YES
                                                        alertAction:[UIAlertAction actionWithTitle:Common_MLS_Ok
                                                                                             style:UIAlertActionStyleDefault
                                                                                           handler:^(UIAlertAction * _Nonnull action) {
                                                                                               
                                                                                               [self goBackAnimated:YES];
                                                                                           }], nil];
                }
            }
            else
            {
                blockSelf.datas = datas;
                [blockSelf.groupView reloadData];
            }
            
            
            if(completion)
            {
                completion();
            }
            [self setBusy:@(NO)];
        });
    });

}


//==============================================================================
//
//==============================================================================
- (void)clearAndLoadDataWithCompletion:(void(^)(void))completion
{
    self.datas = nil;
    [self prepareDataWithCompletion:completion];
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)findGroupModelWithGuid:(NSString *)guid withGroups:(NSArray*)groups
{
    for (WCGroupModel *groupModel in groups)
    {
        if ([groupModel.guid isEqualToString:guid])
        {
            return groupModel;
        }
        else
        {
            WCGroupModel *resultGroupModel = [self findGroupModelWithGuid:guid withGroups:groupModel.subGroups];
            
            if (resultGroupModel)
            {
                return resultGroupModel;
            }
        }
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)findOtherGroupModelWithGroups:(NSArray*)groups
{
    for (WCGroupModel *groupModel in groups)
    {
        if (groupModel.ID==WC_GID_Unfiled)
        {
            return groupModel;
        }
        else
        {
            WCGroupModel *resultGroupModel = [self findOtherGroupModelWithGroups:groupModel.subGroups];
            
            if (resultGroupModel)
            {
                return resultGroupModel;
            }
        }
    }
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//==============================================================================
//
//==============================================================================
- (void)setReserveBottomHeight:(NSInteger)reserveBottomHeight
{
    _reserveBottomHeight = reserveBottomHeight;
    
    [self _resetLayoutConstraints];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) modify group name


//==============================================================================
// @param name 有值表示是修改，沒有值表示是新增
//==============================================================================
- (void)showGroupEditorWithName:(NSString *)name
{
    __block typeof(self) blockSelf = self;
    
    [WCAddOrEditGroupViewController showAddGroupFromViewController:self
                                                     withMaxLength:self.maxGroupLength
                                                      currentGroup:name
                                                groupNameValidator:^BOOL(NSString *groupName)
     {
         
         if ([blockSelf.delegate respondsToSelector:@selector(groupTreeViewController:isExistGroupNamed:)])
         {
             return ![blockSelf.delegate groupTreeViewController:self isExistGroupNamed:groupName];
         }
         else
         {
             return YES;
         }
     }
                                             completeHandler:^void (NSString *groupName)
     {
         
         __block typeof(self) blockSelf = self;
         [self setBusy:@(YES)];
         
         dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
             
             if([name length]==0)
             {
                 BOOL isGroupExist = NO;
                 
                 // 再確認一次沒有重名
                 if ([blockSelf.delegate respondsToSelector:@selector(groupTreeViewController:isExistGroupNamed:)])
                 {
                     isGroupExist = [blockSelf.delegate groupTreeViewController:blockSelf isExistGroupNamed:groupName];
                 }
                 
                 // 不存在才能新增
                 if (!isGroupExist && [blockSelf.delegate respondsToSelector:@selector(groupTreeViewController:groupModelByNewGroupName:superGroupGuid:error:)])
                 {
                     NSError *error = nil;
                     WCGroupModel *currentGroupModel = [self findGroupModelWithGuid:self.selectedGroupGuid withGroups:self.datas];
                     WCGroupModel * newGroupModel = [blockSelf.delegate groupTreeViewController:blockSelf groupModelByNewGroupName:groupName superGroupGuid:currentGroupModel.guid error:&error];

                     //////////////////////////////////////////////////
                     // 加到介面
                     dispatch_async(dispatch_get_main_queue(), ^{
                         
                         if(error!=nil)
                         {
                             NSError *customError = PPErrorMake(WCGroupTreeViewControllerErroCode_FailedToCreateCategory, WCGAFC_MLS_CreateCategoryFailed, error);

                             NSString *errorMessage = [self messageWithError:customError];
                             if([errorMessage length]>0)
                             {
                                 [WCToastController showMessageToastFromSuperView:blockSelf.groupView
                                                                      withMessage:errorMessage
                                                                         position:PPToastPositionCenter];
                             }
                         }
                         else
                         {
                             [blockSelf clearAndLoadDataWithCompletion:^{
                                 
                                 [blockSelf.groupView expendItem:currentGroupModel withAnimated:NO];
                             }];
                         }
                         [self setBusy:@(NO)];
                     });
                 }
             }
             else
             {
                 //  編輯模式要更新到原本的model上
                 if ([blockSelf.delegate respondsToSelector:@selector(groupTreeViewController:updateGroupModel:)])
                 {
                     WCGroupModel *groupModel = [self findGroupModelWithGuid:self.selectedGroupGuid withGroups:self.datas];
                     
#if defined (PRODUCTLINE_WCM)
                     // !!編輯的話要確認群組還在才能編輯
                     BOOL isGroupExist = NO;
                     
                     if ([self.delegate respondsToSelector:@selector(groupTreeViewController:isExistGroupNamed:)])
                     {
                         isGroupExist = [self.delegate groupTreeViewController:self isExistGroupNamed:groupModel.name];
                     }
                     
                     // 群組存在才能編輯
                     if (isGroupExist==NO)
                     {
                         return;
                     }
#endif

                     NSString *oldName = groupModel.name;
                     
                     if (groupModel!=nil)
                     {
                         [groupModel setName:groupName];
                     }
                     
                     NSError *error = [blockSelf.delegate groupTreeViewController:blockSelf updateGroupModel:groupModel];
                     
                     if (error!=nil)
                     {
                         if (groupModel!=nil)
                         {
                             [groupModel setName:oldName];
                         }
                     }
                     //////////////////////////////////////////////////
                     // 加到介面
                     dispatch_async(dispatch_get_main_queue(), ^{
                         
                         if(error)
                         {
                             NSError *customError = PPErrorMake(WCGroupTreeViewControllerErroCode_FailedToRenameCategory, WCGAFC_MLS_RenameCategoryFailed, error);
                             NSString *errorMessage = [self messageWithError:customError];

                             if([errorMessage length]>0)
                             {
                                 [WCToastController showMessageToastFromSuperView:blockSelf.groupView
                                                                      withMessage:errorMessage
                                                                         position:PPToastPositionCenter];
                             }
                         }
                         [blockSelf clearAndLoadDataWithCompletion:^{
                             
                         }];
                         [self setBusy:@(NO)];
                     });
                 }
             }
         });
         
     }];
}


//==============================================================================
//
//==============================================================================
- (void)moveGroupModel:(WCGroupModel *)groupModel
{
    __block NSError *error = nil;
    [WCMultiLayerGroupPickerViewController showMultiLayerGroupPickerViewConrollerFromViewController:self
                                                                                        titleString:WCGAFC_MLS_MoveGroup
                                                                                     multiSelection:NO
                                                                                      showPinButton:NO
                                                                                          enablePin:NO
                                                                              checkWhileNoSelection:NO
                                                                                 exclusiveWithOther:NO
                                                                                       forcePresent:NO
                                                                          requestSourceGroupHandler:^NSArray *(NSError **error) {

                                                                              if ([self.delegate respondsToSelector:@selector(validParentsForMoveGroupModel:withGroupTreeViewController:error:)])
                                                                              {
                                                                                  return [self.delegate validParentsForMoveGroupModel:(WCGroupModel *)groupModel withGroupTreeViewController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestSelectedGroupHandler:^NSArray *(NSError **error){
                                                                              
                                                                              return nil;
                                                                          } requestErrorMessageHandler:^NSString *(NSError *error) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupTreeViewController:requestErrorMessageForError:)])
                                                                              {
                                                                                  return [self.delegate groupTreeViewController:self requestErrorMessageForError:error];
                                                                              }
                                                                              return nil;
                                                                          } selectionHandler:^(NSArray *selectedGroups) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupTreeViewController:moveGroupModel:toParentGuid:)])
                                                                              {
                                                                                  WCGroupModel *toGroupModel = [selectedGroups firstObject];
                                                                                  error = [self.delegate groupTreeViewController:self moveGroupModel:groupModel toParentGuid:toGroupModel.guid];
                                                                                  [error retain];
                                                                              }
                                                                          } finishHandler:^(WCMultiLayerGroupPickerViewController *viewController) {

                                                                              if(error)
                                                                              {
                                                                                  NSError *customError = PPErrorMake(WCGroupTreeViewControllerErroCode_FailedToMoveCategory, WCGAFC_MLS_MoveCategoryFailed, error);
                                                                                  NSString *errorMessage = [self messageWithError:customError];
                                                                                  if([errorMessage length]>0)
                                                                                  {
                                                                                      [WCToastController showMessageToastFromSuperView:viewController.view
                                                                                                                           withMessage:errorMessage
                                                                                                                              position:PPToastPositionCenter];
                                                                                  }
                                                                              }
                                                                              else
                                                                              {
                                                                                  [viewController goBackAnimated:YES];
                                                                                  
                                                                                  self.datas = nil;
                                                                                  [self prepareDataWithCompletion:nil];
                                                                              }
                                                                              
                                                                              [error release];
                                                                          }];
}


//==============================================================================
//
//==============================================================================
- (void)deleteGroupModel:(WCGroupModel *)groupModel
{
    __block typeof(self) blockSelf = self;

    // 防呆用，應該不會出現
    if (groupModel==nil)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [WCToastController showMessageToastFromSuperView:blockSelf.groupView withMessage:WCGAFC_MLS_DeleteCategoryFailed position:PPToastPositionCenter];
        });
        return ;
    }
    
    //////////////////////////////////////////////////
    [self setBusy:@(YES)];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        if ([blockSelf.delegate respondsToSelector:@selector(groupTreeViewController:deleteGroupModel:)])
        {
            
            NSError *error = [blockSelf.delegate groupTreeViewController:blockSelf deleteGroupModel:groupModel];

            //////////////////////////////////////////////////
            // 更新介面
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(error)
                {
                    NSError *customError = PPErrorMake(WCGroupTreeViewControllerErroCode_FailedToDeleteCategory, WCGAFC_MLS_DeleteCategoryFailed, error);
                    NSString *errorMessage = [self messageWithError:customError];
                    

                    if([errorMessage length]>0)
                    {
                        [WCToastController showMessageToastFromSuperView:blockSelf.groupView
                                                             withMessage:errorMessage
                                                                position:PPToastPositionCenter];
                        
                    }                    
                }
                else
                {
                    [blockSelf clearAndLoadDataWithCompletion:^{
                        
                    }];
                }

                [self setBusy:@(NO)];
            });
        }
    });
}









////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)groupView:(WCGroupView *)groupView numberOfChildrenOfItem:(nullable id)item
{
    if(item==nil)
    {
        return [self.datas count];
    }
    else
    {
        return [[(WCGroupModel*)item subGroups] count];
    }
}


//==============================================================================
//
//==============================================================================
- (id)groupView:(WCGroupView *)groupView child:(NSInteger)index ofItem:(nullable id)item;
{
    if(item==nil)
    {
        return [self.datas objectAtIndex:index];
    }
    else
    {
        return [[(WCGroupModel*)item subGroups] objectAtIndex:index];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupViewDelegate


//==============================================================================
//
//==============================================================================
- (void)didReloadDataWithGroupView:(WCGroupView *)groupView
{
    [groupView expendRootWithAnimated:NO];
    
    //////////////////////////////////////////////////
    // 預設active一個cell
    WCGroupModel *groupModel = nil;
    
    if (self.selectedGroupGuid)
    {
        groupModel = [self findGroupModelWithGuid:self.selectedGroupGuid withGroups:self.datas];
    }
    else
    {
        if(self.activeCellByDefault)
        {
            groupModel = [self.datas firstObject];
        }
    }

    if(groupModel)
    {
        // 先展開到要active的cell的上一層
        [self expandToNode:groupModel];
        
        [self.groupView activeCellForItem:groupModel];
    }
    //////////////////////////////////////////////////
    
    // 如果有preSelectedGroups, 要展開並選取
    if (self.groupView.style==WCGroupViewStyle_NameWithCheckBox)
    {
        if (self.checkWhileNoSelection==YES && [self.preSelectedGroups count]==0)
        {
            // 如果沒有傳，預設為other
            WCGroupModel *otherGroupModel = [self findOtherGroupModelWithGroups:self.datas];
            
            [self.groupView checkCellWithItem:otherGroupModel];
        }
        else
        {
            for (WCGroupModel *selectedGroupModel in self.preSelectedGroups)
            {
                WCGroupModel *groupModelAtDatas = [self findGroupModelWithGuid:selectedGroupModel.guid withGroups:self.datas];
                
                [self expandToNode:groupModelAtDatas];
                
                [self.groupView checkCellWithItem:groupModelAtDatas];
            }
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)groupView:(WCGroupView *)groupView didClickCell:(WCGroupTableViewCell *)cell
{
}


//==============================================================================
//
//==============================================================================
- (void)groupView:(WCGroupView *)groupView didCell:(WCGroupTableViewCell *)cell pined:(BOOL)pined
{
    NSLog(@"%s:%@, %d", __PRETTY_FUNCTION__,cell, pined);
}


@end
