//
//  WCFormatCheckController.m
//  Pods
//
//  Created by Howard on 2017/1/3.
//
//

#import "WCFormatCheckController.h"
#import "NSDate+Format.h"

@implementation WCFormatCheckController



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (BOOL)legalEmail:(NSString *)email
{
    BOOL legalEmail = NO;
    
    NSPredicate *predicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", @"[a-zA-Z0-9._%+-]+@[A-Za-z0-9._-]+"];
    if(predicate!=nil)
    {
        legalEmail = [predicate evaluateWithObject:email];
    }
    
    return legalEmail;
}


//================================================================================
//
//================================================================================
+ (BOOL)legalInteger:(NSString *)integerString
{
    BOOL legalInteger = YES;

    
    do
    {
        //檢查是否 0
        if([integerString isEqualToString:@"0"]==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSPredicate *predicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", @"^-?[1-9]{1}+[0-9]{0,14}"];
        
        if(predicate!=nil)
        {
            legalInteger = [predicate evaluateWithObject:integerString];
        }
    }
    while (0);
    
    
    return legalInteger;
}


//================================================================================
//
//================================================================================
+ (BOOL)legalFloatValue:(NSString *)floatString
{
    BOOL legalFlowValue = YES;
    
    do
    {
        //檢查是否 0
        if([floatString isEqualToString:@"0"]==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSPredicate *predicate = nil;
        
        if([floatString componentsSeparatedByString:@"."].count<2)
        {
            predicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", @"^-?[1-9]{1}+[0-9]{0,11}"];
        }
        else
        {
            predicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", @"^-?[0-9]{1,12}+\\.?+[0-9]{1,3}"];
        }
       
        if(predicate!=nil)
        {
            legalFlowValue = [predicate evaluateWithObject:floatString];
        }
    }
    while (0);
    
    return legalFlowValue;
}


//================================================================================
//
//================================================================================
+ (BOOL)legalDateString:(NSString *)dateString format:(NSString *)format
{
    NSDate *date = nil;
    
    do
    {
        if([dateString length]<=0 ||
           [format length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        date = [NSDate dateFromString:dateString format:format];
    }
    while (0);
   
    return (date!=nil)? YES : NO;
}
@end
