//
//  FTSVCheckBoxTableViewCell.m
//  Pods
//
//  Created by Andrew on 2015/8/4.
//
//

#import "FTSVCheckBoxTableViewCell.h"

// View
#import "PPCheckBoxView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - FTSVCheckBoxTableViewCell Extension

@interface FTSVCheckBoxTableViewCell ()

@property (nonatomic, retain) PPCheckBoxView *checkBoxView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - FTSVCheckBoxTableViewCell Implementation

@implementation FTSVCheckBoxTableViewCell





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if ((self=[super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        do
        {
            _checkBoxView = [[PPCheckBoxView alloc] initWithFrame:CGRectZero];
            if (self.checkBoxView==nil)
            {
                self = nil;
                break;
            }
            
            self.checkBoxView.status = PPCheckBoxViewStatus_Unselect;
            self.checkBoxView.checkBoxImageSelected = [UIImage imageWithName:@"ic_check-box_select_h"];
            self.checkBoxView.checkBoxImageUnSelected = [UIImage imageWithName:@"ic_check-box_unselect_h"];
            
            [self.contentView addSubview:self.checkBoxView];
        } while (0);
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_checkBoxView removeFromSuperview];
    [_checkBoxView release];
    _checkBoxView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.checkBoxView.frame = CGRectMake(10, 2, 28, 28);
    
    self.textLabel.frame = CGRectMake(self.checkBoxView.frame.origin.x+self.checkBoxView.frame.size.width+15,
                                      self.textLabel.frame.origin.y,
                                      self.textLabel.frame.size.width,
                                      self.textLabel.frame.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)setCheckBoxViewStatus:(BOOL)isSelected
{
    if (isSelected==YES)
    {
        self.checkBoxView.status = PPCheckBoxViewStatus_Select;
    }
    else
    {
        self.checkBoxView.status = PPCheckBoxViewStatus_Unselect;
    }
}

@end
