//
//  WCFieldModel+DisplayName.m
//  WorldCardHD
//
//  Created by Bill Cheng on 2014/1/8.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCFieldModel+DisplayName.h"

#import "NSString+Additions.h"
#import "WCDisplayNameController.h"
#import "PPSettingsController.h"
#import "WCSettingsKey.h"


@implementation WCFieldModel (DisplayName)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - private methods


//===============================================================================
// 判斷是否為漢字姓名
// RETURNED: return YES if is eastern name
//===============================================================================
- (BOOL)isEasternNameWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
        return ([firstName isCJK] || [lastName isCJK]);
}


//===============================================================================
// DESCRIPTION: get display name 2
// PARAMETERS:	<in> first name
//              <in> last name
// RETURNED: display name
//===============================================================================
- (NSString *)displayNameWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
    // 取得display name order
    WCDisplayNameOrder eastOrder = [PPSettingsController integerValueWithKey:WCSC_IV_kEasternNameOrder];
    WCDisplayNameOrder westOrder = [PPSettingsController integerValueWithKey:WCSC_IV_kWesternNameOrder];
    
    return [WCDisplayNameController displayNameWithFirstName:firstName
                                                    lastName:lastName
                                                   eastOrder:eastOrder
                                                   westOrder:westOrder];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - public methods


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayName
{
    NSString *first = [self valueWithSubType2:WC_FST2_Name_First];
    NSString *last = [self valueWithSubType2:WC_FST2_Name_Last];

    return [self displayNameWithFirstName:first lastName:last];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayNamePhonetic
{
    NSString *firstNamePhonetic = [self valueWithSubType2:WC_FST2_Name_FirstPhonetic];
    NSString *lastNamePhonetic = [self valueWithSubType2:WC_FST2_Name_LastPhonetic];

    return [self displayNameWithFirstName:firstNamePhonetic lastName:lastNamePhonetic];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayNameWithEastOrder:(WCDisplayNameOrder)eastOrder
                                   westOrder:(WCDisplayNameOrder)westOrder
{
    NSString *first = [self valueWithSubType2:WC_FST2_Name_First];
    NSString *last = [self valueWithSubType2:WC_FST2_Name_Last];
    
    return [WCDisplayNameController displayNameWithFirstName:first
                                                    lastName:last
                                                   eastOrder:eastOrder
                                                   westOrder:westOrder];
}


//===============================================================================
//
//===============================================================================
- (NSString *)stringDisplayNamePhoneticWithEastOrder:(WCDisplayNameOrder)eastOrder
                                           westOrder:(WCDisplayNameOrder)westOrder
{
    NSString *firstNamePhonetic = [self valueWithSubType2:WC_FST2_Name_FirstPhonetic];
    NSString *lastNamePhonetic = [self valueWithSubType2:WC_FST2_Name_LastPhonetic];
    
    return [WCDisplayNameController displayNameWithFirstName:firstNamePhonetic
                                                    lastName:lastNamePhonetic
                                                   eastOrder:eastOrder
                                                   westOrder:westOrder];
}


@end
