//
//  WCDisplayNameController.m
//

#import "WCDisplayNameController.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCDisplayNameController


//===============================================================================
// 判斷是否為漢字姓名
//===============================================================================
+ (BOOL)isEasternNameWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
    return ([firstName isCJK] || [lastName isCJK]);
}


//===============================================================================
//
//===============================================================================
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                            middleName:(NSString *)middleName
                                prefix:(NSString*)prefix
                                suffix:(NSString*)suffix
                         isEasternName:(BOOL)isEasternName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder
{
    NSString *displayName = @"";
    
    //////////////////////////////////////////////////
    // get name order
    WCDisplayNameOrder currentNameOrder = (isEasternName?eastOrder:westOrder);
    if(currentNameOrder == WCDisplayNameOrder_None)
    {
        currentNameOrder = WCDisplayNameOrder_FirstLast;
    }
    
    //////////////////////////////////////////////////
    // trim sapce character
    NSCharacterSet	*whitespace = [NSCharacterSet whitespaceCharacterSet];
    firstName = [firstName stringByTrimmingCharactersInSet:whitespace];
    lastName = [lastName stringByTrimmingCharactersInSet:whitespace];
    middleName = [middleName stringByTrimmingCharactersInSet:whitespace];
    prefix = [prefix stringByTrimmingCharactersInSet:whitespace];
    suffix = [suffix stringByTrimmingCharactersInSet:whitespace];
    
    //////////////////////////////////////////////////
    // 判斷姓名的先後
    NSString *displayFirstName = firstName;
    NSString *displayLastName = lastName;
    if(currentNameOrder == WCDisplayNameOrder_LastFirst)
    {
        displayFirstName = lastName;
        displayLastName = firstName;
    }
    
    //////////////////////////////////////////////////
    // prefix
    if ([prefix length]>0)
    {
        displayName = [displayName stringByAppendingString:prefix];
    }
    
    //////////////////////////////////////////////////
    // firstName
    if ([displayFirstName length]>0)
    {
        // 西方要有空格隔開
        if(isEasternName==NO && [displayName length]>0)
        {
            displayName = [displayName stringByAppendingString:@" "];
        }
        displayName = [displayName stringByAppendingString:displayFirstName];
    }
    
    //////////////////////////////////////////////////
    // middleName
    if ([middleName length]>0)
    {
        // 西方要有空格隔開
        if(isEasternName==NO && [displayName length]>0)
        {
            displayName = [displayName stringByAppendingString:@" "];
        }
        displayName = [displayName stringByAppendingString:middleName];
    }
    
    //////////////////////////////////////////////////
    // lastname
    if ([displayLastName length]>0)
    {
        // 西方要有空格隔開
        if(isEasternName==NO && [displayName length]>0)
        {
            displayName = [displayName stringByAppendingString:@" "];
        }
        displayName = [displayName stringByAppendingString:displayLastName];
    }
    
    //////////////////////////////////////////////////
    // suffix
    if ([suffix length]>0)
    {
        // 西方要有空格隔開
        if(isEasternName==NO && [displayName length]>0)
        {
            displayName = [displayName stringByAppendingString:@" "];
        }
        displayName = [displayName stringByAppendingString:suffix];
    }
    
    return displayName;//[displayName stringByTrimmingCharactersInSet:whitespace];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                            middleName:(NSString *)middleName
                                prefix:(NSString*)prefix
                                suffix:(NSString*)suffix
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder
{
    BOOL isEasternName = [self isEasternNameWithFirstName:firstName lastName:lastName];
    return [self displayNameWithFirstName:firstName
                                 lastName:lastName
                               middleName:middleName
                                   prefix:prefix
                                   suffix:suffix
                            isEasternName:isEasternName
                                eastOrder:eastOrder
                                westOrder:westOrder];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                         isEasternName:(BOOL)isEasternName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder
{
    return [self displayNameWithFirstName:firstName
                                 lastName:lastName
                               middleName:nil
                                   prefix:nil
                                   suffix:nil
                            isEasternName:isEasternName
                                eastOrder:eastOrder
                                westOrder:westOrder];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder
{
    BOOL isEasternName = [self isEasternNameWithFirstName:firstName lastName:lastName];
    
    return [self displayNameWithFirstName:firstName
                                 lastName:lastName
                            isEasternName:isEasternName
                                eastOrder:eastOrder
                                westOrder:westOrder];
}

@end
