//
//  WCCompareTool.m
//  Pods
//
//  Created by sanhue on 2015/5/28.
//
//

#import "WCCompareTool.h"
#import "NSString+Additions.h"
#import "NSDate+Format.h"

//===============================================================================
// private
//===============================================================================
NSInteger CompareCardModelByName(WCCardModel *model1, WCCardModel *model2, void *param)
{
    NSComparisonResult result;
    
    // no name在最前，用顯示名稱排序
    if([model1.displayName length] > 0 && [model2.displayName length] > 0)
    {
        result = [model1.displayName compare:model2.displayName options:NSCaseInsensitiveSearch];
    }
    else if([model1.displayName length] == 0 && [model2.displayName length] > 0)
    {
        result = NSOrderedAscending;
    }
    else if([model1.displayName length] > 0 && [model2.displayName length] == 0)
    {
        result = NSOrderedDescending;
    }
    else
    {
        result = NSOrderedSame;
    }
    
    return result;
}


//===============================================================================
// private
//===============================================================================
NSInteger CompareCardModelByCompany(WCCardModel *model1, WCCardModel *model2, void *param)
{
    NSComparisonResult result;
    
    if([model1.displayCompany length] > 0 && [model2.displayCompany length] > 0)
    {
        result = [model1.displayCompany compare:model2.displayCompany options:NSCaseInsensitiveSearch];
    }
    else if([model1.displayCompany length] == 0 && [model2.displayCompany length] > 0)
    {
        result = NSOrderedAscending;
    }
    else if([model1.displayCompany length] > 0 && [model2.displayCompany length] == 0)
    {
        result = NSOrderedDescending;
    }
    else
    {
        result = NSOrderedSame;
    }
    
    return result;
}


//===============================================================================
// private
//===============================================================================
NSInteger CompareCardModelByCreateTime(WCCardModel *model1, WCCardModel *model2, void *param)
{
    return [model2.createdTime compare:model1.createdTime];
}


//===============================================================================
// private
//===============================================================================
NSInteger CompareCardModelByModifiedTime(WCCardModel *model1, WCCardModel *model2, void *param)
{
    return [model2.modifiedTime compare:model1.modifiedTime];
}


//===============================================================================
// private
//===============================================================================
NSInteger CompareCardSectionModel(WCCardSectionModel *model1, WCCardSectionModel *model2, void *param)
{
    NSString		*compare1 = model1.title;
    NSString		*compare2 = model2.title;
    NSInteger		compare1Int = [compare1 intValue];
    NSInteger		compare2Int = [compare2 intValue];
    NSComparisonResult result;
    
    // 如果是筆劃，依數字大小排
    if(compare1Int && compare2Int)
    {
        // stroke only
        if(compare1Int > compare2Int)
            result = NSOrderedDescending;
        else if(compare1Int < compare2Int)
            result = NSOrderedAscending;
        else result = NSOrderedSame;
    }
    else
    {
        if([compare1 isEqualToString:@"#"])
        {
            result = NSOrderedDescending;
        }
        else if([compare2 isEqualToString:@"#"])
        {
            result = NSOrderedAscending;
        }
        else
        {
            // 不是筆劃也不是 #
            // !! ÅÄÖ只有瑞典文會出現，所以直接如到character set
            NSCharacterSet *alphabetSet = [NSCharacterSet characterSetWithCharactersInString:@"ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ"];
            
            BOOL compare1IsAlphabet = [alphabetSet characterIsMember:[compare1 characterAtIndex:0]];
            BOOL compare2IsAlphabet = [alphabetSet characterIsMember:[compare2 characterAtIndex:0]];

            // 是alphabet的排後面，因為目前的索引都是英文在後
            if(compare1IsAlphabet && !compare2IsAlphabet)
            {
                result = NSOrderedDescending;
            }
            else if (!compare1IsAlphabet && compare2IsAlphabet)
            {
                result = NSOrderedAscending;
            }
            else
            {
                // 兩個都是alphabet, 或兩個都不是alphabet
                
                //!! Å，Ä不是依unicode順序排，所以要特殊處理
                if ([compare1 isEqualToString:@"Ä"] &&
                    [compare2 isEqualToString:@"Å"])
                {
                    result = NSOrderedDescending;
                }
                else if ([compare1 isEqualToString:@"Å"] &&
                         [compare2 isEqualToString:@"Ä"])
                {
                    result = NSOrderedAscending;
                }
                else
                {
                    result = [compare1 unicodeCompare:compare2];
                }
            }
        }
    }
    
    return result;
}


//===============================================================================
// private
//===============================================================================
NSInteger CompareCardSectionModelForTime(WCCardSectionModel *model1, WCCardSectionModel *model2, void *param)
{
    NSString		*compare1 = model1.title;
    NSString		*compare2 = model2.title;

    // 如果是this month要特殊處理
    if ([compare1 isEqualToString:[@"MLS_ThisMonth" localized]])
    {
        // 取得this month的真實月份
        compare1 = [[NSDate date] stringWithFormat:@"yyyy.MM"];
    }
    
    if ([compare2 isEqualToString:[@"MLS_ThisMonth" localized]])
    {
        // 取得this month的真實月份
        compare2 = [[NSDate date] stringWithFormat:@"yyyy.MM"];
    }
    NSComparisonResult result = [compare2 compare:compare1];
    return result;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCCompareTool


//==============================================================================
//
//==============================================================================
+ (void)cardArray:(NSMutableArray *)cardArray sortByField:(WC_SortedByField)sortByField
{
    if(sortByField == WC_SBF_Name)
        [cardArray sortUsingFunction:CompareCardModelByName context:nil];
    else if(sortByField == WC_SBF_Company)
        [cardArray sortUsingFunction:CompareCardModelByCompany context:nil];
    else if(sortByField == WC_SBF_CreateTime)
        [cardArray sortUsingFunction:CompareCardModelByCreateTime context:nil];
    else if(sortByField == WC_SBF_ModifiedTime)
        [cardArray sortUsingFunction:CompareCardModelByModifiedTime context:nil];

}


//==============================================================================
//
//==============================================================================
+ (void)cardSectionArray:(NSMutableArray *)cardSectionArray sortByField:(WC_SortedByField)sortByField;
{
    // sort cards
    for(WCCardSectionModel	*cardSectionModel in cardSectionArray)
    {
        if(cardSectionModel.needResortCard)
        {
            [WCCompareTool cardArray:cardSectionModel.cardArray sortByField:sortByField];
            
            cardSectionModel.needResortCard = NO;
        }
    }
    
    // sort sections
    if (sortByField==WC_SBF_CreateTime||sortByField==WC_SBF_ModifiedTime)
    {
        [cardSectionArray sortUsingFunction:CompareCardSectionModelForTime context:nil];
    }
    else
    {
        [cardSectionArray sortUsingFunction:CompareCardSectionModel context:nil];
    }
}
@end
