//
//  WCSearchOptionModel.m
//  Extension
//
//  Created by sanhue on 2018/10/22.
//

#import "WCSearchOptionModel.h"

@implementation WCSearchOptionModel





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.searchOperator = WCSearchOperator_AND;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.text = nil;
    self.fromDate = nil;
    self.toDate = nil;
    self.groupGuids = nil;
    self.accountGuids = nil;
    self.customFieldID = nil;
    self.customFieldValue = nil;
    self.customFieldListItemIDs = nil;
    self.customFieldValueFrom = nil;
    self.customFieldValueTo = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromType:(WCSearchType)searchType
{
    switch (searchType)
    {
        case WCSearchType_Name:
        {
            return @"Name";
        }
        case WCSearchType_Address:
        {
            return @"Address";
        }
        case WCSearchType_Phone:
        {
            return @"Phone";
        }
        case WCSearchType_Email:
        {
            return @"Email";
        }
        case WCSearchType_URL:
        {
            return @"URL";
        }
        case WCSearchType_InstantMessage:
        {
            return @"InstantMessage";
        }
        case WCSearchType_Note:
        {
            return @"Note";
        }
        case WCSearchType_UnifiedBusinessNo:
        {
            return @"UnifiedBusinessNo";
        }
        case WCSearchType_SocialNetwork:
        {
            return @"SocialNetwork";
        }
        case WCSearchType_UserDefine:
        {
            return @"UserDefine";
        }
            
        case WCSearchType_Company:
        {
            return @"Company";
        }
        case WCSearchType_Department:
        {
            return @"Department";
        }
        case WCSearchType_JobTitle:
        {
            return @"JobTitle";
        }
            
        case WCSearchType_Birthday:
        {
            return @"Birthday";
        }
        case WCSearchType_Anniversary:
        {
            return @"Anniversary";
        }
            
        case WCSearchType_CreateTime:
        {
            return @"CreateTime";
        }
        case WCSearchType_ModifiedTime:
        {
            return @"ModifiedTime";
        }
            
        case WCSearchType_Group:
        {
            return @"Group";
        }
            
//        case WCSearchType_Owner:
//        {
//            return @"Owner";
//        }
//        case WCSearchType_Creator:
//        {
//            return @"Creator";
//        }
//        case WCSearchType_Editor:
//        {
//            return @"Editor";
//        }
        default:
            return @"Unknown";
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (NSString *)description
{
    NSMutableString *msg = [[NSMutableString alloc] initWithFormat:@"\r\n\r\n#################### %@ (%p) ####################\r\n", [self class], self];
    
    [msg appendFormat:@"\r\n Operator: %@", ((self.searchOperator==WCSearchOperator_AND)?@"AND":@"OR")];
    [msg appendFormat:@"\r\n Type: %@", [[self class] stringFromType:self.searchType]];
    [msg appendFormat:@"\r\n text: %@", self.text];
    
    if (self.searchType==WCSearchType_Birthday||
        self.searchType==WCSearchType_Anniversary||
        self.searchType==WCSearchType_CreateTime||
        self.searchType==WCSearchType_ModifiedTime||
        self.searchType==WCSearchType_UserDefine)
    {
        [msg appendFormat:@"\r\n fromDate: %@", self.fromDate];
        [msg appendFormat:@"\r\n toDate: %@", self.toDate];
    }
    
    if(self.searchType==WCSearchType_Group)
    {
        [msg appendFormat:@"\r\n groupGuids: %@", self.groupGuids];
    }
    

    if(self.searchType==WCSearchType_UserDefine)
    {
        [msg appendFormat:@"\r\n customFieldID: %@", self.customFieldID];
        [msg appendFormat:@"\r\n customFieldValue: %@", self.customFieldValue];
        [msg appendFormat:@"\r\n customFieldListItemIDs: %@", self.customFieldListItemIDs];
        [msg appendFormat:@"\r\n customFieldValueFrom: %@", self.customFieldValueFrom];
        [msg appendFormat:@"\r\n customFieldValueTo: %@", self.customFieldValueTo];
    }
    [msg appendString:@"\r\n"];
    
    //////////////////////////////////////////////////
    
    return [msg autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NSCopying


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone
{
    id searchOptionModel = [[[self class] alloc] init];
    
    ((WCSearchOptionModel *)searchOptionModel).searchOperator = self.searchOperator;
    ((WCSearchOptionModel *)searchOptionModel).searchType = self.searchType;
    ((WCSearchOptionModel *)searchOptionModel).text = [[self.text copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).fromDate = [[self.fromDate copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).toDate = [[self.toDate copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).groupGuids = [[self.groupGuids mutableCopyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).accountGuids = [[self.accountGuids mutableCopyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).customFieldID = [[self.customFieldID copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).customFieldValue = [[self.customFieldValue copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).customFieldListItemIDs = [[self.customFieldListItemIDs mutableCopyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).customFieldValueFrom = [[self.customFieldValueFrom copyWithZone:zone] autorelease];
    ((WCSearchOptionModel *)searchOptionModel).customFieldValueTo = [[self.customFieldValueTo copyWithZone:zone] autorelease];

    return searchOptionModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - constructor methods


//==============================================================================
//
//==============================================================================
+ (instancetype)searchOptionModelForAND
{
    id searchOptionModel = [[[[self class] alloc] init] autorelease];
    [(WCSearchOptionModel *)searchOptionModel setSearchOperator:WCSearchOperator_AND];
    return searchOptionModel;
}


//==============================================================================
//
//==============================================================================
+ (instancetype)searchOptionModelForOR
{
    id searchOptionModel = [[[[self class] alloc] init] autorelease];
    [(WCSearchOptionModel *)searchOptionModel setSearchOperator:WCSearchOperator_OR];
    return searchOptionModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Utility methods


//==============================================================================
//
//==============================================================================
+ (WCSearchType)searchTypeFromFieldType:(WC_FieldType)fieldType
{
    // 除了公司, 暱稱，其他都是一對一轉換
    if (fieldType==WC_FT_Company)
    {
        return WCSearchType_Company;
    }
    else if(fieldType==WC_FT_Nickname)
    {
        return WCSearchType_Name;
    }
    return (WCSearchType)fieldType;
}


//==============================================================================
//
//==============================================================================
+ (WCSearchType)searchTypeFromFieldSubType1:(WC_FieldSubType1)subType1
{
    if (subType1==WC_FST1_Date_Birthday||
        subType1==WC_FST1_Date_Anniversary)
    {
        return (WCSearchType)subType1;
    }
    
    NSInteger fieldType = subType1/100;
    return [[self class] searchTypeFromFieldType:fieldType];
}


//==============================================================================
//
//==============================================================================
+ (WCSearchType)searchTypeFromFieldSubType2:(WC_FieldSubType2)subType2
{
    if (subType2==WC_FST2_Company_Name||
        subType2==WC_FST2_Company_Department||
        subType2==WC_FST2_Company_JobTitle)
    {
        return (WCSearchType)subType2;
    }
    
    NSInteger fieldType = (subType2-50)/100;
    return [[self class] searchTypeFromFieldType:fieldType];
}
@end
