//
//  WCKernelRecogTypeModel.m
//  
//
//  Created by  Eddie on 12/6/18.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "WCKernelRecogTypeModel.h"
#import "WCFieldModel.h"
#import "WCFieldLabelString.h"
#import "namecard_define.h"

@implementation WCKernelRecogTypeModel
@synthesize typeCode = typeCode_;
@synthesize localizedString = localizedString_;



//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.localizedString = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}

//===============================================================================
// 
//===============================================================================
+ (id)modelWithTypeCode:(NSInteger)typeCode
{
    WCKernelRecogTypeModel *model = nil;
    NSString *localizedString = nil;
    
    switch (typeCode) 
    {
        case ID_BCR_NAME:
        case ID_BCR_ENG_NAME:
        {
            localizedString = [WCFieldLabelString labelStringWithType:WC_FT_Name];
            break;
        }
        case ID_BCR_COMPANY:
        case ID_BCR_ENG_COMPANY:
        {
            localizedString = [WCFieldLabelString labelStringWithType:WC_FT_Company];
            break;
        }
        case ID_BCR_DEPARTMENT:
        case ID_BCR_ENG_DEPARTMENT:
        {
            localizedString = [WCFieldLabelString labelStringWithType:WC_FST2_Company_Department];
            break;
        }
        case ID_BCR_POSITION:
        case ID_BCR_ENG_POSITION:
        {
            localizedString = [WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle];
            break;
        }
        case ID_BCR_PHONE: localizedString = [WCFieldLabelString labelStringWithType:WC_FT_Phone]; break;
        case ID_BCR_MOBILE: localizedString = [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile]; break;
        case ID_BCR_FAX: localizedString = [WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax]; break;
        case ID_BCR_EMAIL: localizedString = [WCFieldLabelString labelStringWithType:WC_FT_Email]; break;
        case ID_BCR_HOMEPAGE: localizedString = [WCFieldLabelString labelStringWithType:WC_FST1_URL_HomePage]; break;
        case ID_BCR_IDPHOTO: localizedString = @"MLS_IDPhoto"; break; //目前這個應該是不會call 到

        case ID_BCR_ADDRESS:
        case ID_BCR_ENG_ADDRESS:
            localizedString = [WCFieldLabelString labelStringWithType:WC_FT_Address];
            break;
            
        default:break;
    }
    
    
    //////////////////////////////////////////////////

    if (localizedString!=nil)
    {
        model = [[[WCKernelRecogTypeModel alloc] init] autorelease];
        model.typeCode = typeCode;
        
        model.localizedString = localizedString;
    }
   
    
    return model;
}

@end
