//
//  WCGroupModel.m
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Modified by Andrew on 2015/7/10.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "WCGroupModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCGroupModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//===============================================================================
//
//===============================================================================
- (instancetype)init
{
    if(self = [super init])
    {
        self.subGroups = [NSMutableArray array];        
    }
    
    return self;
}


//===============================================================================
// 
//===============================================================================
- (void)dealloc
{
    self.name = nil;
    self.modifiedTime = nil;
    
    // for WorldCardTeam
    self.guid = nil;
    self.superGroupGuid = nil;
    self.subGroups = nil;
    self.helper = nil;
    self.owner = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Other Method

//===============================================================================
// 
//===============================================================================
- (NSString *)description
{
    NSMutableString *msg = [[NSMutableString alloc] initWithString:@"\r\n========== WCGroupModel =========="];

    [msg appendFormat:@"\r\n sourceID:%td", self.sourceID];
    [msg appendFormat:@"\r\n ID:%td", self.ID];
    [msg appendFormat:@"\r\n name:%@", self.name];
    [msg appendFormat:@"\r\n cardCount:%td", self.cardCount];
    [msg appendFormat:@"\r\n order:%td", self.order];
    [msg appendFormat:@"\r\n modifiedTime:%@", self.modifiedTime];
    [msg appendFormat:@"\r\n editable:%@", self.editable ? @"YES" : @"NO"];

    // for WorldCardTeam
    [msg appendFormat:@"\r\n guid:%@", self.guid];
    [msg appendFormat:@"\r\n guidsuperGroupGuid:%@", self.superGroupGuid];
    [msg appendFormat:@"\r\n pinnedOrder:%td", self.pinnedOrder];
    [msg appendFormat:@"\r\n isChecked:%@", self.isChecked ? @"YES" : @"NO"];
    [msg appendFormat:@"\r\n isExpanded:%@", self.isExpanded ? @"YES" : @"NO"];
    [msg appendFormat:@"\r\n helper:%@", self.helper];
    [msg appendFormat:@"\r\n owner:%@", self.owner];
    [msg appendString:@"\r\n"];
    
    return [msg autorelease];
}


//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCGroupModel *copyModel = [[self class] allocWithZone:zone];
    
    if(copyModel!=nil)
    {
        copyModel.sourceID = _sourceID;
        copyModel.ID = _ID;
        copyModel.name = [[self.name copyWithZone:zone] autorelease];
        copyModel.cardCount = _cardCount;
        copyModel.order = _order;
        copyModel.editable = _editable;
        copyModel.modifiedTime = [[self.modifiedTime copyWithZone:zone] autorelease];
        
        // for WorldCardTeam
        copyModel.guid = [[self.guid copyWithZone:zone] autorelease];
        copyModel.superGroupGuid = [[self.superGroupGuid copyWithZone:zone] autorelease];
        copyModel.subGroups = [[self.subGroups copyWithZone:zone] autorelease];
        copyModel.pinnedOrder = self.pinnedOrder;
        copyModel.isChecked = self.isChecked;
        copyModel.isExpanded = self.isExpanded;
        copyModel.helper = [[self.helper copyWithZone:zone] autorelease];
        copyModel.owner = [[self.owner copyWithZone:zone] autorelease];
    }
    
    return copyModel;
}

@end
