//
//  WCGroupModel+GoogleContacts.m
//  Pods
//
//  Created by Eddie Hu on 2017/12/7.
//

#import "WCGroupModel+GoogleContacts.h"
#import "WCGroupDefine.h"
#import "NSString+Additions.h"

#define DefaultGroupCount 6

@implementation WCGroupModel (GoogleContacts)

//===============================================================================
//
//===============================================================================
+ (NSMutableDictionary *)copyGoogleContactsGroupNameMappingDict
{
    NSMutableDictionary *mappingDict = [[NSMutableDictionary alloc] init];
    
    NSInteger defaultID[DefaultGroupCount] = {
        WC_GID_All,
        WC_GID_Unfiled,
        WC_GID_Google_MyContacts,
        WC_GID_Google_Friends,
        WC_GID_Google_Family,
        WC_GID_Google_Coworkers};
    
    NSString *defaultNames[DefaultGroupCount] = {
        WC_GCGN_All,
        WC_GCGN_OtherContacts,
        WC_GCGN_MyContacts,
        WC_GCGN_Friends,
        WC_GCGN_Family,
        WC_GCGN_Coworkers};
    
    for(int i=0; i<DefaultGroupCount; i++)
    {
        NSArray *defaultNameArray = [defaultNames[i] componentsSeparatedByString:@","];
        
        for (NSString *name in defaultNameArray)
        {
            [mappingDict setObject:[NSString stringWithInteger:defaultID[i]] forKey:name ];
        }
    }
    
    return mappingDict;
}


@end
