//
//  WCFieldLabelString.m
//  Pods
//
//  Created by sanhue on 2015/10/16.
//
//

#import "WCFieldLabelString.h"
#import "WCFieldDefine.h"
#import "NSString+Additions.h"
#import "PPCountryCodeConvert.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCFieldLabelString


//==============================================================================
//
//==============================================================================
+ (NSString*)labelStringWithType:(NSInteger)fieldType
{
    switch (fieldType)
    {
        case WC_FT_Name:
        {
            return [@"MLS_Name" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Company:
        {
            return [@"MLS_Company" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Address:
        {
            return [@"MLS_Address" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Phone:
        {
            return [@"MLS_Phone" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Email:
        {
            return [@"MLS_Email" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_URL:
        {
            return [@"MLS_URL" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_InstantMessage:
        {
            return [@"MLS_InstantMessage" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Date:
        {
            return [@"MLS_Date" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Note:
        {
            return [@"MLS_Note" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_Nickname:
        {
            return [@"MLS_Nickname" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_UnifiedBusinessNo:
        {
            return [@"MLS_UnifiledBusinessNo" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_UserDefine:
        {
            return [@"MLS_UserDefine" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FT_SocialNetwork:
        {
            return [@"MLS_SocialNetwork" localizedFromTable:@"WCFieldLabelString"];
        }
            //////////////////////////////////////////////////
            // subType1
        case WC_FST1_Address_Work:
        {
            return [@"MLS_Address_Work" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Address_Home:
        {
            return [@"MLS_Address_Home" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Address_Other:
        {
            return [@"MLS_Address_Other" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Work:
        {
            return [@"MLS_Phone_Work" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Home:
        {
            return [@"MLS_Phone_Home" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Mobile:
        {
            return [@"MLS_Phone_Mobile" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Main:
        {
            return [@"MLS_Phone_Main" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_WorkFax:
        {
            return [@"MLS_Phone_WorkFax" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_HomeFax:
        {
            return [@"MLS_Phone_HomeFax" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Pager:
        {
            return [@"MLS_Phone_Pager" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_GoogleVoice:
        {
            return [@"MLS_Phone_GoogleVoice" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_iPhone:
        {
            return [@"MLS_Phone_iPhone" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_Other:
        {
            return [@"MLS_Phone_Other" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Phone_OtherFax:
        {
            return [@"MLS_Phone_OtherFax" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Email_Work:
        {
            return [@"MLS_Email_Work" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Email_Home:
        {
            return [@"MLS_Email_Home" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Email_Other:
        {
            return [@"MLS_Email_Other" localizedFromTable:@"WCFieldLabelString"];
        }
            
        case WC_FST1_URL_HomePage:
        {
            return [@"MLS_URL_HomePage" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_URL_Work:
        {
            return [@"MLS_URL_Work" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_URL_Home:
        {
            return [@"MLS_URL_Home" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_URL_Profile:
        {
            return [@"MLS_URL_Profile" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_URL_Blog:
        {
            return [@"MLS_URL_Blog" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_URL_Other:
        {
            return [@"MLS_URL_Other" localizedFromTable:@"WCFieldLabelString"];
        }
            
        case WC_FST1_IM_MSN:
        {
            return [@"MLS_IM_MSN" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_Skype:
        {
            return [@"MLS_IM_Skype" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_QQ:
        {
            return [@"MLS_IM_QQ" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_Yahoo:
        {
            return [@"MLS_IM_Yahoo" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_ICQ:
        {
            return [@"MLS_IM_ICQ" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_GoogleTalk:
        {
            return [@"MLS_IM_GoogleTalk" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_Jabber:
        {
            return [@"MLS_IM_Jabber" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_AIM:
        {
            return [@"MLS_IM_AIM" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_Other:
        {
            return [@"MLS_IM_Other" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_IM_GaduGadu:
        {
            return [@"MLS_IM_GaduGadu" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_Twitter:
        {
            return [@"MLS_SN_Twitter" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_Facebook:
        {
            return [@"MLS_SN_Facebook" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_Flicker:
        {
            return [@"MLS_SN_Flicker" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_LinkedIn:
        {
            return [@"MLS_SN_LinkedIn" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_MySpace:
        {
            return [@"MLS_SN_MySpace" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_SinaWebo:
        {
            return [@"MLS_SN_SinaWebo" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_SN_Other:
        {
            return [@"MLS_SN_Other" localizedFromTable:@"WCFieldLabelString"];
        }
           
        case WC_FST1_Date_Birthday:
        {
            return [@"MLS_Date_Birthday" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Date_Anniversary:
        {
            return [@"MLS_Date_Anniversary" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST1_Date_Other:
        {
            return [@"MLS_Date_Other" localizedFromTable:@"WCFieldLabelString"];
        }
            
            //////////////////////////////////////////////////
            // subtype2
        case WC_FST2_Name_First:
        {
            return [@"MLS_Name_First" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_FirstPhonetic:
        {
            return [@"MLS_Name_FirstPhonetic" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_Last:
        {
            return [@"MLS_Name_Last" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_LastPhonetic:
        {
            return [@"MLS_Name_LastPhonetic" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_Middle:
        {
            return [@"MLS_Name_Middle" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_Prefix:
        {
            return [@"MLS_Name_Prefix" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Name_Suffix:
        {
            return [@"MLS_Name_Suffix" localizedFromTable:@"WCFieldLabelString"];
        }
            
        case WC_FST2_Company_Name:
        {
            return [@"MLS_Company_Name" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Company_Phonetic:
        {
            return [@"MLS_Company_Phonetic" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Company_Department:
        {
            return [@"MLS_Company_Department" localizedFromTable:@"WCFieldLabelString"];
        }
        case WC_FST2_Company_JobTitle:
        {
            return [@"MLS_Company_JobTitle" localizedFromTable:@"WCFieldLabelString"];
        }
            
        case WC_FST2_Address_Street:
        case WC_FST2_Address_City:
        case WC_FST2_Address_State:
        case WC_FST2_Address_ZIP:
        case WC_FST2_Address_Country:
        case WC_FST2_Address_CountryCode:
        case WC_FST2_Address_Format:
        case WC_FST2_Address_Location:
        {
            return [self addressLabelStringWithType:fieldType
                                        countryCode:[PPCountryCodeConvert defaultCountryCode]];
        }
        default:
            break;
    }
    return nil;
}


//================================================================================
//
//================================================================================
+ (NSString *)addressLabelStringWithType:(NSInteger)fieldType countryCode:(NSString *)countryCode
{
    NSString *addressLabelText = nil;
    
    switch (fieldType)
    {
        case WC_FST2_Address_Street:
        {
            addressLabelText = [@"MLS_Address_Street" localizedFromTable:@"WCFieldLabelString"];
            break;
        }
        case WC_FST2_Address_City:
        {
            if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_TW_City" localizedFromTable:@"WCFieldLabelString"];
            }
            else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_JP_City" localizedFromTable:@"WCFieldLabelString"];
            }
            else
            {
                addressLabelText = [@"MLS_Address_City" localizedFromTable:@"WCFieldLabelString"];
            }
            
            break;
        }
        case WC_FST2_Address_State:
        {
            if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_TW_State" localizedFromTable:@"WCFieldLabelString"];
            }
            else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_JP_State" localizedFromTable:@"WCFieldLabelString"];
            }
            else
            {
                addressLabelText = [@"MLS_Address_State" localizedFromTable:@"WCFieldLabelString"];
            }
            
            break;
        }
        case WC_FST2_Address_ZIP:
        {
            if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_TW_Zip" localizedFromTable:@"WCFieldLabelString"];
            }
            else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                addressLabelText = [@"MLS_Address_JP_Zip" localizedFromTable:@"WCFieldLabelString"];
            }
            else
            {
                addressLabelText = [@"MLS_Address_ZIP" localizedFromTable:@"WCFieldLabelString"];
            }

            break;
        }
        case WC_FST2_Address_Country:
        {
            addressLabelText = [@"MLS_Address_Country" localizedFromTable:@"WCFieldLabelString"];
            
            break;
        }
        case WC_FST2_Address_CountryCode:
        {
            addressLabelText = [@"MLS_Address_CountryCode" localizedFromTable:@"WCFieldLabelString"];
            
            break;
        }
        case WC_FST2_Address_Format:
        {
            addressLabelText = [@"MLS_Address_Format" localizedFromTable:@"WCFieldLabelString"];
            
            break;
        }
        case WC_FST2_Address_Location:
        {
            addressLabelText = [@"MLS_Address_GPS" localizedFromTable:@"WCFieldLabelString"];
            
            break;
        }
        default:
        {
            break;
        }
    }
    
    return addressLabelText;
}

@end
