//
//  WCCustomFieldInfo.m
//  Pods
//
//  Created by sanhue on 2016/10/28.
//
//

#import "WCCustomFieldInfo.h"

@implementation WCCustomFieldInfo





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.guid = nil;
    self.name = nil;
    self.picklistItems = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"{guid: %@,\n Name: %@,\n category: %@,\n contentType: %@,\n picklisItem: %@",
            self.guid,
            self.name,
            [[self class] stringFromCategory:self.category],
            [[self class] stringFromContentType:self.contentType],
            self.picklistItems];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromCategory:(WCCustomFieldCategory)category
{
    if (category==WCCustomFieldCategory_Task)
    {
        return @"Task";
    }
    else if (category==WCCustomFieldCategory_Contact)
    {
        return @"Contact";
    }
    else if (category==WCCustomFieldCategory_Activity)
    {
        return @"activity";
    }
    
    return @"Unknown";
}


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromContentType:(WCCustomFieldContentType)contentType
{
    if(contentType==WCCustomFieldContentType_Text)
    {
        return @"TEXT";
    }
    if(contentType==WCCustomFieldContentType_URL)
    {
        return @"URL";
    }
    else if(contentType==WCCustomFieldContentType_Integer)
    {
        return @"NUMBER";
    }
    else if(contentType==WCCustomFieldContentType_Float)
    {
        return @"FLOAT";
    }
    else if(contentType==WCCustomFieldContentType_Email)
    {
        return @"EMAIL";
    }
    else if(contentType==WCCustomFieldContentType_Picklist)
    {
        return @"PICKLIST";
    }
    
    return @"Unknown";
}


@end
