//
//  WCCacheModel.h
//  WorldCardMobile
//
//  Created by  Eddie on 12/4/13.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "WCSourceDefine.h"
#import "WCGroupDefine.h"
#import "WCImageDefine.h"
#import "WCCardSectionModel.h"
#import "WCCardModel.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCacheModel : NSObject

@property (assign          ) WC_SourceID    sourceID;                           /// < for WorldCardTeam Mac
@property (assign          ) WC_GroupID     groupID;                            /// < 目前cache中的資料所屬的groupID

@property (readonly        ) NSArray        *allCards;                          /// < 取得所有名片，array of WCCardModel

/// for WCM/WCT
@property (readonly, retain) NSMutableArray *allCardSectionArray;
@property (retain          ) NSMutableArray *searchResultSectionArray;

/// for WCMAC/WCTMAC, WCT也用這個，但內容結構不太一樣
@property (readonly, retain) NSMutableDictionary *allCardSectionDict;

// favorites
@property (readonly, retain) NSMutableArray *favoriteCardsArray;
@property (retain          ) NSMutableArray *searchFavoriteCardsArray;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - General methods

/// clear cache
- (void)clearCachedData;

/// assign card display section array to cache (for WCM/WCT)
- (void)updateFromAllCardSections:(NSMutableArray *)allCardSections;

/// assign card display section dict to cache (for WCMAC/WCTMAC)
- (void)updateFromAllCardSectionDict:(NSMutableDictionary *)allCardSectionDict;

#pragma mark - Card cahce methods
- (void)addCardToCache:(WCCardModel *)cardModel;
- (void)removeCardFromCacheWithCardID:(NSString *)cardID;
- (void)updateCardInCache:(WCCardModel *)cardModel;
- (WCCardModel *)cardFromCacheWithCardID:(NSString *)cardID;

#pragma mark - Favorite Card cahce methods
- (void)addFavoriteCardToCache:(WCCardModel *)cardModel;
- (void)removeFavoriteCardFromCacheWithCardID:(NSString *)cardID;
- (void)updateFavoriteCardInCache:(WCCardModel *)cardModel;
- (void)moveFavoriteCardToOrder:(NSInteger)toOrder withCardID:(NSString *)cardID;
- (WCCardModel *)favoriteCardFromCacheWithCardID:(NSString *)cardID;
- (void)clearFavoriteCachedData;

#pragma mark - Thumb image cache methods
- (CPImage *)thumbImageWithCardID:(NSString *)cardID;
- (void)addThumbImage:(CPImage *)image withCardID:(NSString *)cardID;
- (void)removeThumbImageWithCardID:(NSString *)cardID;

#pragma mark - IDPhoto image cache methods
- (CPImage *)idPhotoWithCardID:(NSString *)cardID;
- (void)addIDPhoto:(CPImage *)image withCardID:(NSString *)cardID;
- (void)removeIDPhotoWithCardID:(NSString *)cardID;


#pragma mark - Location cache methods
- (CLLocation *)locationWithAddress:(NSString *)address;
- (void)addLocation:(CLLocation *)location withAddress:(NSString *)address;


#pragma - Class methods
+ (WCCacheModel *)defaultCache;;
+ (NSMutableArray *)copyCardSectionArray:(NSArray *)srcCardSectionArray;

//  從cache中copy一份出來
+ (NSMutableArray *)copyCardSectionArrayFromCache;
// 從favorite的cache中copy一份出來
+ (NSMutableArray *)copyFavoriteCardSectionArrayFromCache;
+ (void)sectionArray:(NSMutableArray *)sectionArray sortByField:(WC_SortedByField)sortByField;

/// copy cards (for macOS)
+ (NSMutableArray *)copyCards:(NSArray *)srcCards;

@end
