//
//  WCABCardModel.m
//
//

#import "WCABCardModel.h"

@implementation WCABCardModel

//================================================================================
//
//================================================================================
- (instancetype)init
{
    if(self = [super init])
    {
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.abPhotoImage = nil;

    //////////////////////////////////////////////////
    self.abSourceID = nil;
    self.abPersonID = nil;

#if TARGET_OS_IPHONE
    self.abGroupID = nil;
#elif TARGET_OS_MAC
    self.parentGroupIDs = nil;
#endif
    
    //////////////////////////////////////////////////

    [super dealloc];
}


//================================================================================
//
//================================================================================
+ (WCABCardModel *)abCardModelFromCardModel:(WCCardModel *)cardModel
{
    WCABCardModel *abCardModel = [[WCABCardModel alloc] init];
    
    abCardModel.ID = cardModel.ID;
    abCardModel.sourceID = cardModel.sourceID;
    [abCardModel setGroupIDArray:cardModel.groupIDArray isInitCard:YES];
    
    abCardModel.displayName = cardModel.displayName;
    abCardModel.displayCompany = cardModel.displayCompany;
    abCardModel.displayPhone = cardModel.displayPhone;
    abCardModel.displayAddress = cardModel.displayAddress;
    abCardModel.displayGPS = cardModel.displayGPS;
    abCardModel.sectionTitle = cardModel.sectionTitle;
    abCardModel.createdTime = cardModel.createdTime;
    abCardModel.modifiedTime = cardModel.modifiedTime;
    abCardModel.frontRecogLang = cardModel.frontRecogLang;
    abCardModel.backRecogLang = cardModel.backRecogLang;
    abCardModel.tagMask = cardModel.tagMask;
    
    NSArray *allKeys = [cardModel.fieldArrayDict allKeys];
    
    for(NSString *key in allKeys)
    {
        NSMutableArray *array = [cardModel.fieldArrayDict objectForKey:key];
        
        for(WCFieldModel *fieldModel in array)
        {
            WCFieldModel *newFieldModel = [fieldModel copy];
            [abCardModel addField:newFieldModel];
            [newFieldModel release];
        }
    }
    
    return [abCardModel autorelease];
}




//================================================================================
//
//================================================================================
- (NSString *)simpleDescription
{
#if TARGET_OS_IPHONE
    
    return [NSString stringWithFormat:@"%@{abGroupID=%@}",
            [super simpleDescription],
            self.abGroupID];

    
#elif TARGET_OS_MAC
    
    return [NSString stringWithFormat:@"%@{parentGroupIDs=%@}",
            [super simpleDescription],
            [self.parentGroupIDs componentsJoinedByString:@","]];

#endif
}

@end
