//
//  WCABCardModel.h
//
//

#import <Foundation/Foundation.h>
#import <AddressBook/AddressBook.h>

// Define
#import "CrossPlatformDefine.h"
#import "WCImageDefine.h"

// Model
#import "WCCardModel.h"


/// AddressBook 轉換用cardModel
@interface WCABCardModel : WCCardModel


/// container ID, 一個聯絡人只屬於一個container
@property (nonatomic, retain) NSString *abSourceID;

/// contact ID
@property (nonatomic, retain) NSString *abPersonID;

#if TARGET_OS_IPHONE

/// group ID, 聯絡人所屬群組的ID
@property (nonatomic, retain) NSString *abGroupID;

#elif TARGET_OS_MAC

/// AddressBook裡的group GUID， WCCardModel的groupIDArray保留給WorldCard使用。
@property (nonatomic, retain) NSArray *parentGroupIDs;

#endif

/// ID photo image
@property (nonatomic, retain) CPImage *abPhotoImage;


/**
 * Create autoreleased instance from WCCardModel
 *
 * @param cardModel - WCCardModel instance
 * @return WCABCardModel instance
 */
+ (WCABCardModel *)abCardModelFromCardModel:(WCCardModel *)cardModel;

@end
