//
//  PPMutableDictionaryExt.m
//  WorldCardHD
//
//  Created by  Eddie on 2011/2/8.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "PPMutableDictionary+NSInteger.h"


@implementation NSMutableDictionary (NSInterger)


//===============================================================================
//
//===============================================================================
- (id)objectForIntKey:(NSInteger)intKey
{
    NSString *keyString = [[NSString alloc] initWithFormat:@"%ld", (long)intKey];
    id returnObj = [self objectForKey:keyString];
    [keyString release];

        return returnObj;
}


//===============================================================================
//
//===============================================================================
- (void)setObject:(id)anObject forIntKey:(NSInteger)intKey
{
    if (anObject == nil) return;

    NSString *keyString = [NSString stringWithFormat:@"%ld", (long)intKey];
    [self setObject:anObject forKey:keyString];
}


//===============================================================================
//
//===============================================================================
- (void)removeObjectForIntKey:(NSInteger)intKey
{
    NSString *keyString = [[NSString alloc] initWithFormat:@"%ld", (long)intKey];
    [self removeObjectForKey:keyString];
    [keyString release];
}


//===============================================================================
//
//===============================================================================
- (NSInteger)intValueForKey:(id)aKey
{
        return [[self objectForKey:aKey] intValue];
}


//===============================================================================
//
//===============================================================================
- (void)setIntValue:(NSInteger)intValue forKey:(id)aKey
{
    NSString *valueString = [[NSString alloc] initWithFormat:@"%ld", (long)intValue];
    [self setObject:valueString forKey:aKey];
    [valueString release];
}

@end
