//
//  WCSyncFlowDefine.h
//  Pods
//
//  Created by sanhue on 2016/8/5.
//
//

#ifndef WCSyncFlowDefine_h
#define WCSyncFlowDefine_h

/**
 * WCM，WCT共用的同步定義檔
 * 如果沒有相應的功能，也可以不使用
 */
////////////////////////////////////////////////////////////////////////////////////////////////////

// Notification
#define WCSyncFlow_Notification               @"WCSyncFlow_Notification"

// Notification userInfo key
#define WCSyncFlow_Notification_kStart        @"WCSyncFlow_Notification_kStart"     // value: NSNumber<WCSyncTarget>
#define WCSyncFlow_Notification_kProgress     @"WCSyncFlow_Notification_kProgress"  // value: NSNumber<float>
#define WCSyncFlow_Notification_kSuccess      @"WCSyncFlow_Notification_kSuccess"   // value: NSNumber<bool> (isAutoMode)
#define WCSyncFlow_Notification_kFailed       @"WCSyncFlow_Notification_kFailed"    // value: NSError
#define WCSyncFlow_Notification_kSuspended    @"WCSyncFlow_Notification_kSuspended" // value: NSNumber<WCSyncFlow_SuspendReason>



////////////////////////////////////////////////////////////////////////////////////////////////////

/// 目前在進行的流程
typedef NS_OPTIONS(NSInteger, WCSyncFlow_Flow)
{
    WCSyncFlow_Flow_None = 0,
    WCSyncFlow_Flow_Syncing,
    WCSyncFlow_Flow_Suspending,
    WCSyncFlow_Flow_LoggingIn
};

/// 錯誤碼
typedef NS_OPTIONS(NSInteger, WCSyncFlow_Error)
{
    WCSyncFlow_Error_None = 9000,
    WCSyncFlow_Error_UserCancel,                        // 使用者取消
    WCSyncFlow_Error_Unknown,                           // 底層沒有回傳error, 要檢查
    WCSyncFlow_Error_Undefined,
    WCSyncFlow_Error_InitObjectFailed,                  // 同步元件建立失敗，不應該發生
    WCSyncFlow_Error_GuidHasBeenUsed,                   // WCT, Guid重復，目前在底層已產生新的guid，不會出現
    WCSyncFlow_Error_ScopeIncorrect,                    // WCM 7, for google login with wrong scope
    WCSyncFlow_Error_AuthenticationFailed,              // token失效
    WCSyncFlow_Error_ServerInternalError,               // WCT, server 未知錯誤
    WCSyncFlow_Error_NetworkProblem,                    // 網路錯誤 ,
    WCSyncFlow_Error_FailedToConnectServer,             // 有開網路，但無法連線到server
    WCSyncFlow_Error_ServerBusy,                        // server忙碌，造成timeout
    WCSyncFlow_Error_ServerMaintenance,                 // server維護中，無法同步
    WCSyncFlow_Error_ServerTaskCollision,               // server執行緒衝突(多個client同時寫入同一筆資料)
    WCSyncFlow_Error_AccountIsInheriting,               // WCT, 帳號繼承中
    WCSyncFlow_Error_OverContactCountLimitation,        // WCT, 聯絡人數量超過上限
    WCSyncFlow_Error_OverPublicContactCountLimitation,  // WCT, 公有區聯絡人數量超過上限
    WCSyncFlow_Error_OverServerContactCountLimitation,  // WCT, 系統聯絡人總數量超過上限
    WCSyncFlow_Error_NotEnoughServerSpace,              // 伺服器空間不足
    WCSyncFlow_Error_NotEnoughClientSpace,              // 手機空間不足 (WCT: <10MB)
    WCSyncFlow_Error_ServerVersionIsNewer,              // 伺服器版本比較新目前可以離線登入，操作後會回傳這個錯誤
    WCSyncFlow_Error_UnsupportedServerVersion,          // 不支援此伺服器版本
    WCSyncFlow_Error_LimitedAccount,                // 超過續訂/試用期限6個月，無法使用
    WCSyncFlow_Error_CantRemoveSystemCategory,          // 不能刪除系統類別 
    WCSyncFlow_Error_SyncErrorWithContactInfo,          // 同步失敗，localiezdReason中會有錯誤訊息，直接顯示
};

/// 網路狀態
typedef NS_OPTIONS(NSInteger, WCSyncFlow_Network)
{
    WCSyncFlow_Network_None = 0,
    WCSyncFlow_Network_WiFi,
    WCSyncFlow_Network_WiFi_WWAN,
};

/// 暫停原因
typedef NS_OPTIONS(NSInteger, WCSyncFlow_SuspendReason)
{
    WCSyncFlow_SuspendReason_None = 0,
    WCSyncFlow_SuspendReason_LocalDeleteAllWarning,
    WCSyncFlow_SuspendReason_RemoteDeleteAllWarning,
};

#endif /* WCSyncFlowDefine_h */
