//
//  WCCloudFileDefine.h
//
//  交換及備份檔在網路空間操作時使用到的定義值
//

#ifndef WCCloudFileDefine_h
#define WCCloudFileDefine_h

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
/// zip passworld
#define WCCloudFileDefine_ZipPassword @"io9#IH93(mlkas@0"



////////////////////////////////////////////////////////////////////////////////////////////////////
/// iCloud的teamID
#define WCCloudFileDefine_iCloudTeamID @"67MBQ68QX2"



////////////////////////////////////////////////////////////////////////////////////////////////////
// 檔名格式

/// 檔名中的日期及時間格式
#define WCCloudFileDefine_DateTimeFormat @"yyyyMMdd_HHmmss"

/// 單一檔案包含多個聯絡人的匯出檔名格式 (DeviceName_Datetime.*) - ex: "MyPhone_20140101_112233.wcxf"
/// DeviceName有包含空白時，請用"_"替換空白。 - ex: "My_Phone_20140101_112233.wcxf"
#define WCCloudFileDefine_MultiContactsFileNameFormat @"%@_%@.%@"

/// 單一檔案只有一個聯絡人的匯出檔名格式 (Index.*) - ex: "01.vcf"
/// 若為相片的匯出檔名格式 (Index_Back/Front.*)  - ex: "01_Back.vcf"
/// 因為PC端會產生亂碼，所以改為只有Index
#define WCCloudFileDefine_SingleContactFileNameFormat @"%02d%@.%@"

/// 壓縮檔的匯出檔名格式 (Prefix_DeviceName_Datetime.*) - ex: "Vcf_MyPhone_20140101_112233.zip"
#define WCCloudFileDefine_ZipContactFileNameFormat @"%@_%@_%@.zip"

/// 壓縮影像檔的prefix
#define WCCloudFileDefine_ZipImagePrefix @"Img"

/// 壓縮vCard檔的prefix
#define WCCloudFileDefine_ZipVcfPrefix @"Vcf"



////////////////////////////////////////////////////////////////////////////////////////////////////
// Export/Import

/// 放置交換檔的路徑
#define WCCloudFileDefine_ExchangeDirPath @"/WorldCard/data_exchange"


/// file sharing交換檔路徑
#define WCCloudFileDefine_FileSharingDirPath @"/"


////////////////////////////////////////////////////////////////////////////////////////////////////
// Backup/Restore

/// 備份檔副檔名 (!! WorldCardHD 4.0.0 之前為"iwchd"，之後統一用iwc)
#define WCCloudFileDefine_iPhoneBackupFileExt @"iwc"

/// 跨平台備份檔副檔名
#define WCCloudFileDefine_GeneralBackupFileExt @"wcbk"

/// 備份檔檔名格式 (DeviceName_Datetime.iwc) - ex: "MyPhone_20140101-112233.iwc"
#define WCCloudFileDefine_BackupFileNameFormat @"%@_%@.%@"

/// 放置備份檔路徑 (!! WorldCardHD 4.0.0 之前為 "/WorldCard/backup_iwchd")
#define WCCloudFileDefine_BackupDirPath @"/WorldCard/backup_iwc"

/// 放置wcbk備份檔路徑 (!! WorldCardHD 4.0.0 之前為 "/WorldCard/Backup"), 大小寫要注意，因為android先用大寫所以這邊"B"也用大寫
#define WCCloudFileDefine_BackupDirPath_WCBK @"/WorldCard/Backup"


#endif
