//
//  CardImageReflectionView.m
//  Pods
//
//  Created by duke on 2016/6/16.
//
//

#import "CardImageReflectionView.h"

@implementation CardImageReflectionView





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc


//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
        
        do
        {
            _cardImageView = [[UIImageView alloc] initWithFrame:frame];
            
            if (_cardImageView == nil)
            {
                break;
            }
            
            _cardImageView.autoresizingMask = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
            [self addSubview:self.cardImageView];
            
        } while (NO);
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.cardImageView.image = nil;
    
    [self.cardImageView removeFromSuperview];
    self.cardImageView = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - instance methods


//==============================================================================
//
//==============================================================================
- (void)setImage:(UIImage *)image
{
    if (self.cardImageView)
    {
        self.cardImageView.image = image;
        // 如果不是動態更新，要手動呼叫|update|
        if (self.dynamic==NO)
        {
            if (self.bounds.size.width>image.size.width ||
                self.bounds.size.width>image.size.height)
            {
                [self update];
            }
        }
    }
}


@end
