//
//  PPContactRowObject.m
//
//  Created by Howard.Lin on 13/9/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPContactRowObject.h"
#import "ContactApperanceDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"

// Controller
#import "PPCountryCodeConvert.h"
#import "WCFormatCheckController.h"

// Category
#import "NSString+Additions.h"
#import "NSDictionary+SortKey.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger const PPContactRowObjectAddress_MaxNumber = 5;

@interface PPContactRowObject()

+ (NSString *)labelTextFromPPContactLabelType:(PPContactLabelType)ppContactLabelType;
+ (NSString *)labelTextFromPPContactMainType:(PPContactMainType)ppRecognitionFieldMainType;

@end
////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPContactRowObject


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        _imageRectDictionary = [[NSMutableDictionary alloc] init];
        
        //////////////////////////////////////////////////
        
        _inputValueDictionary = [[NSMutableDictionary alloc] init];

        //////////////////////////////////////////////////

        _tableViewCellStyle  = PPContactTableViewCellStyle_Default;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_imageRectDictionary removeAllObjects];
    [_imageRectDictionary release];
    _imageRectDictionary = nil;
    
    [_inputValueDictionary removeAllObjects];
    [_inputValueDictionary release];
    _inputValueDictionary = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Class Method

//====================================================================================================
//
//====================================================================================================
+ (NSString *)labelTextFromPPContactLabelType:(PPContactLabelType)ppContactLabelType
{
    NSString *text = @"";
    
    switch (ppContactLabelType)
    {
        case PPContactLabelType_Address_Home:
        {
            text = PPContactLabelText_Address_Home;
            
            break;
        }
        case PPContactLabelType_Address_Other:
        {
            text = PPContactLabelText_Address_Other;
            
            break;
        }
        case PPContactLabelType_Address_Work:
        {
            text = PPContactLabelText_Address_Work;
            
            break;
        }
        case PPContactLabelType_Date_Anniversary:
        {
            text = PPContactLabelText_Date_Anniversary;
            
            break;
        }
        case PPContactLabelType_Date_Other:
        {
            text = PPContactLabelText_Date_Other;
            
            break;
        }
        case PPContactLabelType_Email_Home:
        {
            text = PPContactLabelText_Email_Home;
            
            break;
        }
        case PPContactLabelType_Email_Other:
        {
            text = PPContactLabelText_Email_Other;
            
            break;
        }
        case PPContactLabelType_Email_Work:
        {
            text = PPContactLabelText_Email_Work;
            
            break;
        }
        case PPContactLabelType_InstantMessage_AIM:
        {
            text = PPContactLabelText_InstantMessage_AIM;
            
            break;
        }
        case PPContactLabelType_InstantMessage_GoogleTalk:
        {
            text = PPContactLabelText_InstantMessage_GoogleTalk;
            
            break;
        }
        case PPContactLabelType_InstantMessage_ICQ:
        {
            text = PPContactLabelText_InstantMessage_ICQ;
            
            break;
        }
        case PPContactLabelType_InstantMessage_Jabber:
        {
            text = PPContactLabelText_InstantMessage_Jabber;
            
            break;
        }
        case PPContactLabelType_InstantMessage_MSN:
        {
            text = PPContactLabelText_InstantMessage_MSN;
            
            break;
        }
        case PPContactLabelType_InstantMessage_QQ:
        {
            text = PPContactLabelText_InstantMessage_QQ;
            
            break;
        }
        case PPContactLabelType_InstantMessage_Skype:
        {
            text = PPContactLabelText_InstantMessage_Skype;
            
            break;
        }
        case PPContactLabelType_InstantMessage_Yahoo:
        {
            text = PPContactLabelText_InstantMessage_Yahoo;
            
            break;
        }
        case PPContactLabelType_InstantMessage_Other:
        {
            text = PPContactLabelText_InstantMessage_Other;
            
            break;
        }
        case PPContactLabelType_InstantMessage_GaduGadu:
        {
            text = PPContactLabelText_InstantMessage_GaduGadu;
            
            break;
        }
        case PPContactLabelType_Phone_GoogleVoice:
        {
            text = PPContactLabelText_Phone_GoogleVoice;
            
            break;
        }
        case PPContactLabelType_Phone_Home:
        {
            text = PPContactLabelText_Phone_Home;
            
            break;
        }
        case PPContactLabelType_Phone_HomeFax:
        {
            text = PPContactLabelText_Phone_HomeFax;
            
            break;
        }
        case PPContactLabelType_Phone_iPhone:
        {
            text = PPContactLabelText_Phone_iPhone;
            
            break;
        }
        case PPContactLabelType_Phone_Main:
        {
            text = PPContactLabelText_Phone_Main;
            
            break;
        }
        case PPContactLabelType_Phone_Mobile:
        {
            text = PPContactLabelText_Phone_Mobile;
            
            break;
        }
        case PPContactLabelType_Phone_Other:
        {
            text = PPContactLabelText_Phone_Other;
            
            break;
        }
        case PPContactLabelType_Phone_Pager:
        {
            text = PPContactLabelText_Phone_Pager;
            
            break;
        }
        case PPContactLabelType_Phone_Work:
        {
            text = PPContactLabelText_Phone_Work;
            
            break;
        }
        case PPContactLabelType_Phone_WorkFax:
        {
            text = PPContactLabelText_Phone_WorkFax;
            
            break;
        }
        case PPContactLabelType_URL_Blog:
        {
            text = PPContactLabelText_URL_Blog;
            
            break;
        }
        case PPContactLabelType_URL_Home:
        {
            text = PPContactLabelText_URL_Home;
            
            break;
        }
        case PPContactLabelType_URL_HomePage:
        {
            text = PPContactLabelText_URL_HomePage;
            
            break;
        }
        case PPContactLabelType_URL_Other:
        {
            text = PPContactLabelText_URL_Other;
            
            break;
        }
        case PPContactLabelType_URL_Profile:
        {
            text = PPContactLabelText_URL_Profile;
            
            break;
        }
        case PPContactLabelType_URL_Work:
        {
            text = PPContactLabelText_URL_Work;
            
            break;
        }
        case PPContactLabelType_Status_Status:
        {
            text = PPContactLabelText_Status;
            
            break;
        }
        case PPContactLabelType_Status_Rating:
        {
            text = PPContactLabelText_Rating;
            
            break;
        }
        case PPContactLabelType_Status_Industry:
        {
            text = PPContactLabelText_Industry;
            
            break;
        }
        case PPContactLabelType_Status_LeadSource:
        {
            text = PPContactLabelText_LeadSource;
            
            break;
        }
        case PPContactLabelType_Status_Description:
        {
            text = PPContactLabelText_Description;
            
            break;
        }
        case PPContactLabelType_Company_Name:
        {
            text = PPContactLabelText_Company_Name;
            
            break;
        }
        case PPContactLabelType_Company_JobTitle:
        {
            text = PPContactLabelText_Company_JobTitle;
            break;
        }
        case PPContactLabelType_Company_Department:
        {
            text = PPContactLabelText_Company_Department;
            break;
        }
        default:
        {
            break;
        }
    }
    
    return text;
}


//====================================================================================================
//
//====================================================================================================
+ (NSString *)labelTextFromPPContactMainType:(PPContactMainType)ppRecognitionFieldMainType
{
    NSString *text = @"";
    
    switch (ppRecognitionFieldMainType)
    {
        case PPContactMainType_Name:
        {
            text = PPContactLabelText_Name;
            
            break;
        }
        case PPContactMainType_Company:
        {
            text = PPContactLabelText_Company;
            
            break;
        }
        case PPContactMainType_Address:
        {
            //!!預設為公司
            text = PPContactLabelText_Address_Work;
            
            break;
        }
        case PPContactMainType_Note:
        {
            text = PPContactLabelText_Note;
            
            break;
        }
        case PPContactMainType_BirthDay:
        {
            text = PPContactLabelText_BirthDay;
            
            break;
        }
        case PPContactMainType_Salutation:
        {
            text = PPContactLabelText_Salutation;
            break;
        }
        default:
        {
            break;
        }
    }
    
    return text;
    
}


//================================================================================
//
//================================================================================


//================================================================================
//
//================================================================================
+ (NSString *)userDefinePlaceholderArrayWithContactSubType:(PPContactSubType)contactSubType
{
    NSString *placeholder = nil;
    
    switch (contactSubType)
    {
        case PPContactSubType_UserDefine_DateAndTime:
        {
            placeholder = WCCV_MLS_DateAndTime;
            break;
        }
        case PPContactSubType_UserDefine_Date:
        {
            placeholder = WCCV_MLS_Date;
            break;
        }
        case PPContactSubType_UserDefine_Integer:
        {
            placeholder = WCCV_MLS_Integer;
            break;
        }
        case PPContactSubType_UserDefine_Text:
        {
            placeholder = WCCV_MLS_Text;
            break;
        }
        case PPContactSubType_UserDefine_Email:
        {
            placeholder = WCCV_MLS_Email;
            break;
        }
        case PPContactSubType_UserDefine_URL:
        {
            // !! chung說都用URL就好
            placeholder = @"URL";
            break;
        }
        case PPContactSubType_UserDefine_Float:
        {
            placeholder = WCCV_MLS_Float;
            break;
        }
        case PPContactSubType_UserDefine_ListValue:
        {
            placeholder = WCCV_MLS_PleaseSelectItem;
            break;
        }
        default:
        {
            break;
        }
    }
    return placeholder;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)checkInputValueDictionaryKeyHasValidValue
{
    BOOL result = NO;
    
    do
    {
        if(self.inputValueDictionary==nil || self.inputValueDictionary.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(self.contactLabelType==PPContactLabelType_Other_ConstructTime ||
           self.contactLabelType==PPContactLabelType_Other_ModifyTime)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(id key in self.inputValueDictionary.allKeys)
        {
            //下列為隱藏欄位
            if([key integerValue]==PPContactSubType_Address_Country
               || [key integerValue]==PPContactSubType_Address_CountryCode
               || [key integerValue]==PPContactSubType_Address_RecognitionLanguageCode
               || [key integerValue]==PPContactSubType_Address_GPS
               || [key integerValue]==PPContactSubType_Address_Format
               || [key integerValue]==PPContactSubType_UserDefine_ID
               || [key integerValue]==PPContactSubType_UserDefine_UserInfo
               || [key integerValue]==PPContactSubType_UserDefine_ItemMenu
               || [key integerValue]==PPContactSubType_ItemMenu
               || [key integerValue]==PPContactSubType_SaveToSystemGroup)
            {
                continue;
            }
           
            //////////////////////////////////////////////////
            
            id object = [self.inputValueDictionary objectForKey:key];
            
            if([object isKindOfClass:[NSString class]]==YES)
            {
                NSString *text = object;
                
                if(text!=nil &&
                   [text isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==NO &&
                   [text isEqualToString:WCVC_EditViewControllerSelectDisableValue]==NO &&
                   [text stringByReplacingOccurrencesOfString:@" " withString:@""].length>0)
                {
                    result = YES;
                    break;
                }
            }
        }
        
    } while (0);
    
    return result;
}



//================================================================================
//
//================================================================================
- (NSArray *)sortAllKeys
{
    return [self.inputValueDictionary sortKeyByAscending];
}


//================================================================================
//
//================================================================================
- (NSString *)localizedPlaceholder
{
    NSString *placeholder = nil;
    
    switch (self.contactMainType)
    {
        case PPContactMainType_BirthDay:
        case PPContactMainType_Date:
        {
            placeholder = WCCV_MLS_Date;
            
            break;
        }
        case PPContactMainType_Email:
        {
            placeholder = WCCV_MLS_Email;
            
            break;
        }
        case PPContactMainType_Note:
        case PPContactMainType_PublicNote:
        {
            placeholder = WCCV_MLS_Note;
            
            break;
        }
        case PPContactMainType_Other:
        {
            if(self.contactLabelType==PPContactLabelType_Other_ConstructTime)
            {
                placeholder = WCCV_MLS_CreateTime;
            }
            else if(self.contactLabelType==PPContactLabelType_Other_ModifyTime)
            {
                placeholder = WCCV_MLS_ModifyTime;
            }
            else if(self.contactLabelType==PPContactLabelType_Other_NickName)
            {
                placeholder = WCCV_MLS_Nickname;
            }
            else if(self.contactLabelType==PPContactLabelType_Other_UnifiedBusinessNumber)
            {
                placeholder = WCCV_MLS_UnifiledBusinessNo;
            }
            else if(self.contactLabelType==PPContactLabelType_Other_URL_Work)
            {
                placeholder = WCCV_MLS_URL;
            }
            else if(self.contactLabelType==PPContactLabelType_Other_Birthday)
            {
                placeholder = WCCV_MLS_Date;
            }
            else
            {
                placeholder = WCCV_MLS_Other;
            }
            
            
            break;
        }
        case PPContactMainType_InstantMessage:
        {
            placeholder = WCCV_MLS_InstantMessage;
            
            break;
        }
        case PPContactMainType_Phone:
        {
            placeholder = WCCV_MLS_Phone;
            
            break;
        }
        case PPContactMainType_UserDefine:
        {
            placeholder = [PPContactRowObject userDefinePlaceholderArrayWithContactSubType:[self curEditingSubType]];
            break;
        }
        case PPContactMainType_URL:
        {
            placeholder = WCCV_MLS_URL;
            
            break;
        }
        case PPContactMainType_SocialNetwork:
        {
            placeholder = WCCV_MLS_SocialNetwork;
            break;
        }
        case PPContactMainType_Salutation:
        case PPContactMainType_Status:
        {
            placeholder = WCCV_MLS_PleaseSelectItem;
            break;
        }
        default:
        {
            break;
        }
    }
    return placeholder;
}


//================================================================================
//
//================================================================================
- (NSString *)placeholderForPPContactSubType:(PPContactSubType)contactSubType countryCode:(NSString *)countryCode
{
    NSString *placeholder = nil;
    
    do
    {
        switch(contactSubType)
        {
            // name section
            case PPContactSubType_Name_LastName:
            {
                placeholder = WCCV_MLS_Name_Last;
                
                break;
            }
            case PPContactSubType_Name_FirstName:
            {
                placeholder = WCCV_MLS_Name_First;
               
                break;
            }
            case PPContactSubType_Name_Prefix:
            {
                placeholder = WCCV_MLS_Name_Prefix;
                
                break;
            }
            case PPContactSubType_Name_FirstNamePhonetic:
            {
                placeholder = WCCV_MLS_Name_FirstPhonetic;
                
                break;
            }
            case PPContactSubType_Name_LastNamePhonetic:
            {
                placeholder = WCCV_MLS_Name_LastPhonetic;
               
                break;
            }
            case PPContactSubType_Name_Surffix:
            {
                placeholder = WCCV_MLS_Name_Suffix;
               
                break;
            }
            case PPContactSubType_Name_MiddleName:
            {
                placeholder = WCCV_MLS_Name_Middle;
               
                break;
            }
            // address
            case PPContactSubType_Address_Street:
            {
                placeholder = WCCV_MLS_Address_Street;
               
                break;
            }
            case PPContactSubType_Address_City:
            {
                if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_TW_City;
                }
                else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_JP_City;
                }
                else
                {
                    placeholder = WCCV_MLS_Address_City;
                }
               
                break;
            }
            case PPContactSubType_Address_State:
            {
                if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_TW_State;
                }
                else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_JP_State;
                }
                else
                {
                    placeholder = WCCV_MLS_Address_State;
                }
                
                break;
            }
            case PPContactSubType_Address_Zip:
            {
                if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_TW_Zip;
                }
                else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                {
                    placeholder = WCCV_MLS_Address_JP_Zip;
                }
                else
                {
                    placeholder = WCCV_MLS_Address_ZIP;
                }
                break;
            }
            case PPContactSubType_Address_Country:
            {
                placeholder = WCCV_MLS_Address_Country;
               
                break;
            }
            case PPContactSubType_Address_CountryCode:
            {
                break;
            }
            // company
            case PPContactSubType_Company_Name:
            {
                placeholder = WCCV_MLS_Company;
              
                break;
            }
            case PPContactSubType_Company_NamePhonetic:
            {
                placeholder = WCCV_MLS_Company_Phonetic;
                
                break;
            }
            case PPContactSubType_Company_JobTitle:
            {
                placeholder = WCCV_MLS_Company_JobTitle;
               
                break;
            }
            case PPContactSubType_Company_Department:
            {
                placeholder = WCCV_MLS_Company_Department;
               
                break;
            }
            // UserDefine
            case PPContactSubType_UserDefine_Integer:
            case PPContactSubType_UserDefine_Float:
            case PPContactSubType_UserDefine_Text:
            case PPContactSubType_UserDefine_ListValue:
            case PPContactSubType_UserDefine_Email:
            {
                placeholder = WCCV_MLS_UserDefine;
                
                break;
            }
            case PPContactSubType_ListValue:
            {
                placeholder = WCCV_MLS_Salutation;
                
                break;
            }
            default:
            {
                break;
            }
        }
    } while (0);

    return placeholder;
}


//================================================================================
//
//================================================================================
- (NSUInteger)validVisbleFieldNumberWithCountPhonetic:(BOOL)enablePhonetic
{
    NSUInteger validVisbleFieldNumber = self.inputValueDictionary.count;
    
    if(self.contactMainType==PPContactMainType_Address)
    {
        //地址的最大欄位為5
        validVisbleFieldNumber = PPContactRowObjectAddress_MaxNumber;
    }
    else
    {
        //不是日文版，要扣掉讀音高度
        if(enablePhonetic==NO)
        {
            if(self.contactMainType==PPContactMainType_Name)
            {
                for(id key in self.inputValueDictionary.allKeys)
                {
                    if([key unsignedIntegerValue]==PPContactSubType_Name_FirstNamePhonetic ||
                       [key unsignedIntegerValue]==PPContactSubType_Name_LastNamePhonetic)
                    {
                        validVisbleFieldNumber--;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(validVisbleFieldNumber==self.inputValueDictionary.count-2)
                    {
                        break;
                    }
                }
            }
            else if(self.contactMainType==PPContactMainType_Company &&
                validVisbleFieldNumber>1)
            {
                for(id key in self.inputValueDictionary.allKeys)
                {
                    if([key unsignedIntegerValue]==PPContactSubType_Company_NamePhonetic)
                    {
                        validVisbleFieldNumber--;
                        break;
                    }
                }
            }
        }
    }
    
    return validVisbleFieldNumber;
}


//================================================================================
//
//================================================================================
- (PPContactSubType)contactSubTypeWithLocalizedPlaceholder:(NSString *)placeholder
{
    PPContactSubType subType = PPContactSubType_None;
    
    do
    {
        switch(self.contactMainType)
        {
            case PPContactMainType_Name:
            {
                // name section
                if([placeholder isEqualToString:WCCV_MLS_Name_Last])
                {
                    subType = PPContactSubType_Name_LastName;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_First])
                {
                    subType = PPContactSubType_Name_FirstName;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_Prefix])
                {
                    subType = PPContactSubType_Name_Prefix;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_FirstPhonetic])
                {
                    subType = PPContactSubType_Name_FirstNamePhonetic;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_LastPhonetic])
                {
                    subType = PPContactSubType_Name_LastNamePhonetic;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_Suffix])
                {
                    subType = PPContactSubType_Name_Surffix;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Name_Middle])
                {
                    subType = PPContactSubType_Name_MiddleName;
                }
                
                break;
            }
            case PPContactMainType_Address:
            {
                // address section
                if([placeholder isEqualToString:WCCV_MLS_Address_Street])
                {
                    subType = PPContactSubType_Address_Street;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Address_Country])
                {
                    subType = PPContactSubType_Address_Country;
                }
                else
                {
                    // 先拿 Country Code 參考
                    NSString *countryCode =  [self.inputValueDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
                    
                    if([countryCode length]<=0)
                    {
                        countryCode = [PPCountryCodeConvert defaultCountryCode];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if([countryCode compare:@"TW" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                    {
                        if([placeholder isEqualToString:WCCV_MLS_Address_TW_City])
                        {
                            subType = PPContactSubType_Address_City;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_TW_State])
                        {
                            subType = PPContactSubType_Address_State;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_TW_Zip])
                        {
                            subType = PPContactSubType_Address_Zip;
                        }
                    }
                    else if([countryCode compare:@"JP" options:NSCaseInsensitiveSearch]==NSOrderedSame)
                    {
                        if([placeholder isEqualToString:WCCV_MLS_Address_JP_City])
                        {
                            subType = PPContactSubType_Address_City;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_JP_State])
                        {
                            subType = PPContactSubType_Address_State;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_JP_Zip])
                        {
                            subType = PPContactSubType_Address_Zip;
                        }
                    }
                    else
                    {
                        if([placeholder isEqualToString:WCCV_MLS_Address_City])
                        {
                            subType = PPContactSubType_Address_City;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_State])
                        {
                            subType = PPContactSubType_Address_State;
                        }
                        else if([placeholder isEqualToString:WCCV_MLS_Address_ZIP])
                        {
                            subType = PPContactSubType_Address_Zip;
                        }
                    }
                }
                
                break;
            }
            case PPContactMainType_Company:
            {
                // company section
                if([placeholder isEqualToString:WCCV_MLS_Company])
                {
                    subType = PPContactSubType_Company_Name;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Company_Phonetic])
                {
                    subType = PPContactSubType_Company_NamePhonetic;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Company_JobTitle])
                {
                    subType = PPContactSubType_Company_JobTitle;
                }
                else if([placeholder isEqualToString:WCCV_MLS_Company_Department])
                {
                    subType = PPContactSubType_Company_Department;
                }
                
                break;
            }
            case PPContactMainType_BirthDay:
            case PPContactMainType_Date:
            case PPContactMainType_InstantMessage:
            case PPContactMainType_Email:
            case PPContactMainType_Other:
            case PPContactMainType_Note:
            case PPContactMainType_PublicNote:
            case PPContactMainType_Phone:
            case PPContactMainType_SocialNetwork:
            case PPContactMainType_URL:
            case PPContactMainType_Salutation:
            case PPContactMainType_SalesforceSaveAs:
            {
                subType = PPContactSubType_None;
                
                break;
            }
            case PPContactMainType_Status:
            {
                //!! 無法透過 PPContactMainType_Status, 決定 subtype 的對應，所以拋出預設，給上層處理
                subType = PPContactSubType_None;
                break;
            }
            case PPContactMainType_UserDefine:
            {
                //!! 無法透過 PPContactMainType_UserDefine, 決定 subtype 的對應，所以拋出預設，給上層處理
                subType = PPContactSubType_None;
                break;
            }
            default:
            {
                break;
            }
        }
    } while (0);
    
    return subType;
}


//================================================================================
//
//================================================================================
- (NSString *)visibleTextFromSubType
{
    NSString *visibleTextFromSubType = @"";
    NSArray *hidenSubTypes = [self hidenSubTypes];
    
    for(id key in self.inputValueDictionary.allKeys)
    {
        if([hidenSubTypes indexOfObject:key]!=NSNotFound)
        {
            continue;
        }
        
        //////////////////////////////////////////////////

        id object = [self.inputValueDictionary objectForKey:key];
        
        if([object isKindOfClass:[NSString class]]==YES)
        {
            visibleTextFromSubType = object;
            break;
        }
    }
    
    return visibleTextFromSubType;
}


//================================================================================
//
//================================================================================
- (PPContactSubType)curEditingSubType
{
    PPContactSubType contactSubType = PPContactSubType_None;
    
    NSArray *hidenSubTypes = [self hidenSubTypes];
    
    for(id key in self.inputValueDictionary.allKeys)
    {
        if([hidenSubTypes indexOfObject:key]!=NSNotFound)
        {
            continue;
        }
        
        
        //////////////////////////////////////////////////

        contactSubType = [key integerValue];
        
        break;
    }
    
    return contactSubType;
}


//================================================================================
//
//================================================================================
- (NSArray *)hidenSubTypes
{
    return @[@(PPContactSubType_Address_Country),
             @(PPContactSubType_Address_CountryCode),
             @(PPContactSubType_Address_RecognitionLanguageCode),
             @(PPContactSubType_Address_GPS),
             @(PPContactSubType_Address_Format),
             @(PPContactSubType_UserDefine_ID),
             @(PPContactSubType_UserDefine_UserInfo),
             @(PPContactSubType_UserDefine_ItemMenu),
             @(PPContactSubType_SaveToSystemGroup),
             @(PPContactSubType_GroupID),
             @(PPContactSubType_ItemMenu)];
}


//================================================================================
//
//================================================================================
- (BOOL)checkValueIsLegal
{
    BOOL legal = YES;
    
    do
    {
        if(self.contactMainType!=PPContactMainType_Email &&
           self.contactMainType!=PPContactMainType_UserDefine)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        switch (self.contactMainType)
        {
            case PPContactMainType_Email:
            {
                id object = [[self.inputValueDictionary allValues] firstObject];
    
                if([object isKindOfClass:[NSString class]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////

                NSString *email = object;
                
                if([email length]<=0)
                {
                    break;
                }
                
                legal = [WCFormatCheckController legalEmail:email];
                
                break;
            }
            case PPContactMainType_UserDefine:
            {
                for(id key in [self.inputValueDictionary allKeys])
                {
                    if([key integerValue]!=PPContactSubType_UserDefine_Email &&
                       [key integerValue]!=PPContactSubType_UserDefine_Float &&
                       [key integerValue]!=PPContactSubType_UserDefine_Integer)
                    {
                        continue;
                    }
                    
                    //////////////////////////////////////////////////
                 
                    id object = [self.inputValueDictionary objectForKey:key];
                    
                    if([object isKindOfClass:[NSString class]]==NO ||
                       [object length]<=0)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    switch ([key integerValue])
                    {
                        case PPContactSubType_UserDefine_Email:
                        {
                            legal = [WCFormatCheckController legalEmail:object];
                            
                            break;
                        }
                        case PPContactSubType_UserDefine_Integer:
                        {
                            legal = [WCFormatCheckController legalInteger:object];
                            
                            break;
                        }
                        case PPContactSubType_UserDefine_Float:
                        {
                            legal = [WCFormatCheckController legalFloatValue:object];
                            
                            break;
                        }
                        default:
                        {
                            break;
                        }
                    }
                    
                    //////////////////////////////////////////////////

                    if(legal==NO)
                    {
                        break;
                    }
                }
            }
            default:
            {
                break;
            }
        }
    }
    while (0);
    
    //////////////////////////////////////////////////

    return legal;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSString *)labelTextFromPPContactLabelType:(PPContactLabelType)ppContactLabelType
                            ppContactMainType:(PPContactMainType)ppContactMainType
{
    NSString *labelText = [self labelTextFromPPContactLabelType:ppContactLabelType];
    
    if(labelText.length<=0)
    {
        labelText = [self labelTextFromPPContactMainType:ppContactMainType];
    }
    
    return labelText;
}


//================================================================================
//
//================================================================================
+ (PPContactLabelType)ppContactLabelTypeForPPContactMainType:(PPContactMainType)ppContactMainType
                                                   labelText:(NSString *)labelText
{
    PPContactLabelType ppContactLabelType = PPContactLabelType_None;
    
    switch (ppContactMainType)
    {
        case PPContactMainType_UserDefine:
        {
            ppContactLabelType = PPContactLabelType_UserDefine;
            
            break;
        }
        case PPContactMainType_Address:
        {
            if([PPContactLabelText_Address_Work compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Address_Work;
            }
            else if([PPContactLabelText_Address_Home compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Address_Home;
            }
            else if([PPContactLabelText_Address_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Address_Other;
            }
            
            break;
        }
        case PPContactMainType_Phone:
        {
            if([PPContactLabelText_Phone_Work compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Work;
            }
            else if([PPContactLabelText_Phone_Home compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Home;
            }
            else if([PPContactLabelText_Phone_Mobile compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Mobile;
            }
            else if([PPContactLabelText_Phone_Main compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Main;
            }
            else if([PPContactLabelText_Phone_WorkFax compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_WorkFax;
            }
            else if([PPContactLabelText_Phone_HomeFax compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_HomeFax;
            }
            else if([PPContactLabelText_Phone_Pager compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Pager;
            }
            else if([PPContactLabelText_Phone_GoogleVoice compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_GoogleVoice;
            }
            else if([PPContactLabelText_Phone_iPhone compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_iPhone;
            }
            else if([PPContactLabelText_Phone_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Phone_Other;
            }
     
            break;
        }
        case PPContactMainType_Email:
        {
            if([PPContactLabelText_Email_Work compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Email_Work;
            }
            else if([PPContactLabelText_Email_Home compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Email_Home;
            }
            else if([PPContactLabelText_Email_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Email_Other;
            }

            
            break;
        }
        case PPContactMainType_URL:
        {
            if([PPContactLabelText_URL_HomePage compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_HomePage;
            }
            else if([PPContactLabelText_URL_Work compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_Work;
            }
            else if([PPContactLabelText_URL_Home compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_Home;
            }
            else if([PPContactLabelText_URL_Profile compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_Profile;
            }
            else if([PPContactLabelText_URL_Blog compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_Blog;
            }
            else if([PPContactLabelText_URL_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_URL_Other;
            }
            
            break;
        }
        case PPContactMainType_InstantMessage:
        {
            if([PPContactLabelText_InstantMessage_MSN compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_MSN;
            }
            else if([PPContactLabelText_InstantMessage_Skype compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_Skype;
            }
            else if([PPContactLabelText_InstantMessage_QQ compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_QQ;
            }
            else if([PPContactLabelText_InstantMessage_Yahoo compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_Yahoo;
            }
            else if([PPContactLabelText_InstantMessage_ICQ compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_ICQ;
            }
            else if([PPContactLabelText_InstantMessage_GoogleTalk compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_GoogleTalk;
            }
            else if([PPContactLabelText_InstantMessage_Jabber compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_Jabber;
            }
            else if([PPContactLabelText_InstantMessage_AIM compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_AIM;
            }
            else if([PPContactLabelText_InstantMessage_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_Other;
            }
            else if([PPContactLabelText_InstantMessage_GaduGadu compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_InstantMessage_GaduGadu;
            }
            
            break;
        }
        case PPContactMainType_Date:
        {
            if([PPContactLabelText_Date_Anniversary compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Date_Anniversary;
            }
            else if([PPContactLabelText_Date_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Date_Other;
            }
            
            break;
        }
        case PPContactMainType_SocialNetwork:
        {
            if([PPContactLabelText_SN_Twitter compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_Twitter;
            }
            else if([PPContactLabelText_SN_Facebook compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_Facebook;
            }
            else if([PPContactLabelText_SN_Flicker compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_Flicker;
            }
            else if([PPContactLabelText_SN_LinkedIn compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_LinkedIn;
            }
            else if([PPContactLabelText_SN_MySpace compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_MySpace;
            }
            else if([PPContactLabelText_SN_SinaWebo compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_SinaWebo;
            }
            else if([PPContactLabelText_SN_Other compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_SN_Other;
            }
            
            break;
        }
        case PPContactMainType_Other:
        {
            if([PPContactLabelText_Other_ConstructTime compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_ConstructTime;
            }
            else if([PPContactLabelText_Other_ModifyTime compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_ModifyTime;
            }
            else if([PPContactLabelText_Other_NickName compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_NickName;
            }
            else if([PPContactLabelText_Other_UnifiedBuinessNumber compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_UnifiedBusinessNumber;
            }
            else if([PPContactLabelText_Other_URL_Work compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_URL_Work;
            }
            else if([PPContactLabelText_Other_Birthday compare:labelText options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                ppContactLabelType = PPContactLabelType_Other_Birthday;
            }
            break;
        }
        default:
        {
            break;
        }
    }
    
    return ppContactLabelType;
}


//================================================================================
//
//================================================================================
+ (PPContactRowObject *)ppContactRowObjectWithPPContactMainType:(PPContactMainType)contactMainType
                                             ppContactLabelType:(PPContactLabelType)contactLabelType
                                      tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                    ppContactTableViewCellStyle:(PPContactTableViewCellStyle)tableViewCellStyle
                                                       selected:(BOOL)selected
{
    PPContactRowObject *contactRowObject = [[PPContactRowObject alloc] init];
    
    if(contactRowObject!=nil)
    {
        contactRowObject.contactMainType     = contactMainType;
        contactRowObject.contactLabelType    = contactLabelType;
        contactRowObject.editingStyle        = editingStyle;
        contactRowObject.tableViewCellStyle  = tableViewCellStyle;
        contactRowObject.selected = selected;
    }
    
    return [contactRowObject autorelease];
}

@end
