//
//  PPContactLabelTypeDefine.h
//  WorldCardCloud
//
//  Created by Howard.Lin on 2014/3/19.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPContactMainTypeDefine.h"

#ifndef WorldCardCloud_PPContactLabelTypeDefine_h
#define WorldCardCloud_PPContactLabelTypeDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPContactMainTypeDistance 1000

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPContactLabelType)
{
	PPContactLabelType_None                         = 0,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_UserDefine                   = 1, //取labeltext
    
    //////////////////////////////////////////////////
    
	PPContactLabelType_Address_Work                 = (PPContactMainType_Address*PPContactMainTypeDistance),
    PPContactLabelType_Address_Home,
    PPContactLabelType_Address_Other,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_Phone_Work                   = (PPContactMainType_Phone*PPContactMainTypeDistance),
	PPContactLabelType_Phone_Home,
	PPContactLabelType_Phone_Mobile,
	PPContactLabelType_Phone_Main,
    PPContactLabelType_Phone_iPhone,
	PPContactLabelType_Phone_WorkFax,
	PPContactLabelType_Phone_HomeFax,
	PPContactLabelType_Phone_Pager,
    PPContactLabelType_Phone_GoogleVoice,
	PPContactLabelType_Phone_Other,

    //////////////////////////////////////////////////
    
    PPContactLabelType_Email_Work                   = (PPContactMainType_Email*PPContactMainTypeDistance),
    PPContactLabelType_Email_Home,
    PPContactLabelType_Email_Other,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_URL_HomePage                 = (PPContactMainType_URL*PPContactMainTypeDistance),
	PPContactLabelType_URL_Work,
	PPContactLabelType_URL_Home,
    PPContactLabelType_URL_Profile,
    PPContactLabelType_URL_Blog,
	PPContactLabelType_URL_Other,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_InstantMessage_MSN           = (PPContactMainType_InstantMessage*PPContactMainTypeDistance),
	PPContactLabelType_InstantMessage_Skype,
	PPContactLabelType_InstantMessage_QQ,
	PPContactLabelType_InstantMessage_Yahoo,
	PPContactLabelType_InstantMessage_ICQ,
	PPContactLabelType_InstantMessage_GoogleTalk,
	PPContactLabelType_InstantMessage_Jabber,
	PPContactLabelType_InstantMessage_AIM,
    PPContactLabelType_InstantMessage_Other,
    PPContactLabelType_InstantMessage_GaduGadu,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_Date_Anniversary             = (PPContactMainType_Date*PPContactMainTypeDistance),
    PPContactLabelType_Date_Other,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_Group_Info                   = (PPContactMainType_Group*PPContactMainTypeDistance),
    
    //////////////////////////////////////////////////

    PPContactLabelType_SystemGroup_Save             = (PPContactMainType_SystemGroup*PPContactMainTypeDistance),
    PPContactLabelType_SystemGroup_Info,
    
    //////////////////////////////////////////////////

    PPContactLabelType_VisibleAccount_Info          = (PPContactMaintype_VisibleAccount*PPContactMainTypeDistance),

    //////////////////////////////////////////////////

    PPContactLabelType_SN_Twitter       = (PPContactMainType_SocialNetwork*PPContactMainTypeDistance),
    PPContactLabelType_SN_Facebook,
    PPContactLabelType_SN_Flicker,
    PPContactLabelType_SN_LinkedIn,
    PPContactLabelType_SN_MySpace,
    PPContactLabelType_SN_SinaWebo,
    PPContactLabelType_SN_Other,
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_Other_UnifiedBusinessNumber  = (PPContactMainType_Other*PPContactMainTypeDistance),
    PPContactLabelType_Other_NickName,
    PPContactLabelType_Other_ConstructTime,
    PPContactLabelType_Other_ModifyTime,
    
    PPContactLabelType_Other_URL_Work,    // 公司url, for office365
    PPContactLabelType_Other_Birthday,    // 生日，for office365
    
    //////////////////////////////////////////////////

    PPContactLabelType_Status_Status = (PPContactMainType_Status*PPContactMainTypeDistance),
    PPContactLabelType_Status_LeadSource,
    PPContactLabelType_Status_Industry,
    PPContactLabelType_Status_Rating,
    PPContactLabelType_Status_Description,
    
    //////////////////////////////////////////////////

    PPContactLabelType_Salesforce_Info = (PPContactMainType_SalesforceSaveAs*PPContactMainTypeDistance),
    
    //////////////////////////////////////////////////
    
    PPContactLabelType_Company_Name = (PPContactMainType_Company*PPContactMainTypeDistance),
    PPContactLabelType_Company_Department,
    PPContactLabelType_Company_JobTitle
};

#endif
