//
//  ContactDataExchangeProtocol.h
//
//  Created by Howard.Lin on 13/10/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPContactMainTypeDefine.h"
#import "PPContactSubTypeDefine.h"


@protocol ContactDataExchangeProtocol <NSObject>

//!! NSDictionary = [NSDictionary setObject:NSArray forKey:PPContactMainType]
//!! NSArray = [NSArray arrayWithObjects:ContactDataExchangeModel,ContactDataExchangeModel,ContactDataExchangeModel,ContactDataExchangeModel,nil]

@required

/**
 * To set image for PPContactMainType
 * @param sender The request object
 * @param image The image you want to set
 * @param contactMainType The contactMainType you want to select
 * @param error    returnError
 * @return: The result for setting image
 */
- (BOOL)sender:(id)sender setImage:(UIImage *)image forPPContactMainType:(PPContactMainType)contactMainType error:(NSError **)error;

/**
 * To return image for PPContactMainType and PPContactSubType
 * @param sender The request object
 * @param contactMainType The contactMainType you want to select
 * @param contactSubType The contactSubType you want to select
 * @return: The image sender want
 */
 - (UIImage *)sender:(id)sender imageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType;


/**
 * To return fieldDictionary for contactMainTypeArray
 * @param sender The request object
 * @param contactMainTypeArray The contactMainType collections you want to select
 * @return: The fieldDictionary sender want
 */
 - (NSDictionary *)sender:(id)sender fieldDictionaryforPPContactMainTypeArray:(NSArray *)contactMainTypeArray;


/**
 * To set fieldDictionary
 * @param sender The request object
 * @param error    returnError
 * @return: The result for setting fieldDictionary
 */
 - (BOOL)sender:(id)sender setFieldsDictionary:(NSDictionary *)fieldDictionary error:(NSError **)error;


@optional

/**
 *  To set favorite BOOL value for contact
 *
 *  @param sender   sender: The request object
 *  @param favorite favorite: The favorite BOOL value you want to set
 *  @param error    returnError
 *
 *  @return The result for setting favorite BOOL value
 */
- (BOOL)sender:(id)sender setFavorite:(BOOL)favorite error:(NSError **)error;


/**
 *  To return favorite BOOL value from contact
 *
 *  @param sender sender: The request object
 *
 *  @return favorite BOOL value sender want
 */
- (BOOL)favoriteWithSender:(id)sender;

@end
