//
//  ContactTextViewTableViewCell.m
//
//  Created by Howard.Lin on 13/10/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactTextViewTableViewCell.h"

// Define
#import "ContactApperanceDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactViewController+PrivateParameterDefine.h"

// Category
#import "UIColor+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define ContactTextViewTableViewCell_ImageViewTableViewCellTopMargin 12
#define ContactTextViewTableViewCell_ImageViewTableViewCellLeftMargin 15

static CGFloat const ContactTextViewTableViewCell_FontSize = 17.0f;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactTextViewTableViewCell()

@property (nonatomic,readwrite) PPTableViewCellLineView *contactTableViewCellLineView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactTextViewTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    
    if(self!=nil)
    {
        [self.ppTextView setTextColor:[UIColor contactEditViewInputFieldTextColor]];
        [self.ppTextView setFont:[UIFont systemFontOfSize:ContactTextViewTableViewCell_FontSize]];
      
        //////////////////////////////////////////////////
        
        [self.textLabel setAdjustsFontSizeToFitWidth:YES];
        
        //////////////////////////////////////////////////
        
        _contactTableViewCellLineView = [[PPTableViewCellLineView alloc] init];
        
        if(_contactTableViewCellLineView!=nil)
        {
            _contactTableViewCellLineView.lineColor = WCAppearanceDefine_SeparatorColor;
            [self.contentView addSubview:_contactTableViewCellLineView];
            [self.contentView sendSubviewToBack:_contactTableViewCellLineView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactKeyboardToolBarViewDelegate = nil;
    
    [_contactTableViewCellLineView removeFromSuperview];
    [_contactTableViewCellLineView release];
    _contactTableViewCellLineView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.textLabel.frame;
    
    textLabelFrame.size.width = ContactTableViewCellLabelWidth;
    
    self.textLabel.frame = textLabelFrame;
    
    //////////////////////////////////////////////////
    
    self.contactTableViewCellLineView.frame = self.contentView.bounds;
    self.contactTableViewCellLineView.leftMargin = textLabelFrame.origin.x + textLabelFrame.size.width + ContactTableViewCellContentEdgeInset.left;
    [self.contactTableViewCellLineView performSelectorOnMainThread:@selector(setNeedsDisplay) withObject:nil waitUntilDone:NO];
    
    //////////////////////////////////////////////////
    
    CGRect textViewFrame = self.ppTextView.frame;
    if (self.style==UITableViewCellStyleDefault)
    {
        if (self.imageView.image!=nil)
        {
            CGRect imageViewFrame = self.imageView.frame;
            imageViewFrame.origin.y = imageViewFrame.origin.y+ContactTextViewTableViewCell_ImageViewTableViewCellTopMargin;
            imageViewFrame.size.width = ContactTextViewTableViewCellImageViewSize.width;
            imageViewFrame.size.height = ContactTextViewTableViewCellImageViewSize.height;
            self.imageView.frame = imageViewFrame;
        }
        
        textViewFrame.origin.x    = self.imageView.frame.origin.x+self.imageView.frame.size.width+ContactTextViewTableViewCell_ImageViewTableViewCellLeftMargin;
        textViewFrame.size.width -= self.imageView.frame.size.width+ContactTextViewTableViewCell_ImageViewTableViewCellLeftMargin;
    }
    else
    {
        textViewFrame.origin.x   = self.contactTableViewCellLineView.leftMargin + ContactTableViewCellContentEdgeInset.left;
        textViewFrame.size.width = self.contentView.bounds.size.width - ContactTableViewCellContentEdgeInset.right - textViewFrame.origin.x ;
    }
    
    self.ppTextView.frame = textViewFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setContactKeyboardToolBarViewDelegate:(id<ContactKeyboardToolBarViewDelegate>)contactKeyboardToolBarViewDelegate
{
    if(_contactKeyboardToolBarViewDelegate==nil)
    {
        _contactKeyboardToolBarViewDelegate = contactKeyboardToolBarViewDelegate;
        
        //////////////////////////////////////////////////
        
        ContactKeyboardToolBarView *toolBarView = [[ContactKeyboardToolBarView alloc] init];
        
        if(toolBarView!=nil)
        {
            self.ppTextView.inputAccessoryView = toolBarView;
            toolBarView.contactKeyboardToolBarViewDelegate = self.contactKeyboardToolBarViewDelegate;
        }
        
        [toolBarView release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    BOOL result = [self textViewShouldChangeCharactersInRange:range replacementString:text];
    
    if(result==NO)
    {
        [[NSNotificationCenter defaultCenter] postNotificationName:WCCV_InputTextFieldArriveMaxLengthNotification object:@(self.maxLength)];
    }
    return result;
}
@end
