//
//  ContactInfoLeftSideView.m
//  Pods
//
//  Created by AndrewLai on 2016/6/24.
//
//

#import "ContactInfoLeftSideView.h"

//Define
#import "WCAppearanceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoLeftSideView Extension

@interface ContactInfoLeftSideView () <PPButtonDelegate>
@property (nonatomic, retain) UIActivityIndicatorView *cardImageIndicatorView;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoLeftSideView Implementation

@implementation ContactInfoLeftSideView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Cretaing, Copying, and Dellocation object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        self.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
        
        //////////////////////////////////////////////////
        _contactCardImageButton = [[PPButton buttonWithType:UIButtonTypeCustom] retain];
        if (self.contactCardImageButton!=nil)
        {
            self.contactCardImageButton.backgroundColor       = [UIColor colorWithHexString:@"#DAE3F1"];
            self.contactCardImageButton.imageView.contentMode = UIViewContentModeScaleAspectFit;
            self.contactCardImageButton.delegate              = self;
            
            [self.contactCardImageButton addControlEvents:UIControlEventTouchUpInside];
            [self addSubview:self.contactCardImageButton];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_contactCardImageButton removeFromSuperview];
    [_contactCardImageButton release];
    _contactCardImageButton = nil;
    
    [self.cardImageIndicatorView removeFromSuperview];
    self.cardImageIndicatorView = nil;
    
    [self.emptyErrorLabel removeFromSuperview];
    self.emptyErrorLabel = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)cardImageIndicatorViewVisible:(BOOL)visible
{
    if (visible==YES)
    {
        if (self.cardImageIndicatorView==nil)
        {
            _cardImageIndicatorView = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(0, 0, self.contactCardImageButton.bounds.size.width, self.contactCardImageButton.bounds.size.height)];
        }
        
        if (self.cardImageIndicatorView!=nil)
        {
            self.cardImageIndicatorView.activityIndicatorViewStyle = UIActivityIndicatorViewStyleWhiteLarge;
            self.cardImageIndicatorView.color = [UIColor colorWithHexString:@"#75A6F0"];
            
            [self.cardImageIndicatorView startAnimating];
            [self.contactCardImageButton addSubview:self.cardImageIndicatorView];
        }
    }
    else
    {
        [self.cardImageIndicatorView stopAnimating];
        [self.cardImageIndicatorView removeFromSuperview];
        self.cardImageIndicatorView = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)emptyErrorMessageLabelVisible:(BOOL)visible
{
    self.emptyErrorLabel.hidden = !visible;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    self.contactCardImageButton.frame = self.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactImage Protocol Method

//================================================================================
//
//================================================================================
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage
{
    if (contactFrontCardImage!=nil)
    {
        [self.contactCardImageButton setImage:contactFrontCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage
{
    if (contactRearCardImage!=nil)
    {
        [self.contactCardImageButton setImage:contactRearCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactHeadImage:(UIImage *)contactHeadImage
{
    // do nothing
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(contactInfoLeftSideViewDidClickedContactCardImage:)]==YES)
    {
        [self.delegate contactInfoLeftSideViewDidClickedContactCardImage:self];
    }
}

@end
