//
//  ContactInfoHeaderView.m
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/5/21.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//

#import "ContactInfoHeaderView.h"

// Define
#import "ContactApperanceDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactInfoViewController+ResouceDefine.h"

// Controller
#import "PPLogController.h"
#import "PPMakeVirtualCardController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define ContactInfoHeaderView_SwitchButtonRect   CGRectMake(0, 0, 50, 50)

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSInteger const ContactInfoHeaderView_SwitchButtonImageInset = 10;
static NSInteger const ContactInfoHeaderView_InfoViewMargin         = 16;//下方大頭照＆名稱＆切換鈕區塊的margin & 名片圖Focus
CGFloat ContactInfoHeaderView_ContactNameShortPressDuration         = 0.5;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoHeaderView Extension

@interface ContactInfoHeaderView ()
@property (nonatomic, assign) BOOL      canUpdateConstraint;

@property (nonatomic, retain) UIActivityIndicatorView *cardImageIndicatorView;
@property (nonatomic, retain) UIActivityIndicatorView *headImageIndicatorView;

@property (nonatomic, retain) UIView   *contactCardMaskView;
@property (nonatomic, retain) UIView   *contactCardGuideFocusView; //主要用來進行導覽Focus時，Focus的區域View

@property (nonatomic, retain) UILongPressGestureRecognizer *shortPressGestureRecognizer;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma  mark - ContactInfoHeaderView Implementation

@implementation ContactInfoHeaderView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        self.backgroundColor     = [UIColor colorWithHexString:@"#75A6F0"];
        self.canUpdateConstraint = NO;
        
        //////////////////////////////////////////////////
        
        _contactCardSwitchButtonVisible = NO;
        
        //////////////////////////////////////////////////
        
        _contactCardGuideFocusView = [[UIView alloc] initWithFrame:CGRectZero];
        if (self.contactCardGuideFocusView!=nil)
        {
            self.contactCardGuideFocusView.backgroundColor = [UIColor clearColor];
            self.contactCardGuideFocusView.ppGuideIndex    = PPGuideDataModel_GuideIndex_InfoContactCardButton;
            
            [self addSubview:self.contactCardGuideFocusView];
        }
        
        //////////////////////////////////////////////////
        
        _contactCardImageButton = [[PPButton buttonWithType:UIButtonTypeCustom] retain];
        if (self.contactCardImageButton!=nil)
        {
            self.contactCardImageButton.backgroundColor       = [UIColor colorWithHexString:@"#DAE3F1"];
            self.contactCardImageButton.imageView.contentMode = UIViewContentModeScaleAspectFit;
            self.contactCardImageButton.delegate              = self;
            self.contactCardImageButton.tag                   = ContactInfoHeaderViewButtonTag_CardImage;
            
            [self.contactCardImageButton addControlEvents:UIControlEventTouchUpInside];
            [self addSubview:self.contactCardImageButton];
        }
        
        //////////////////////////////////////////////////
        
        _separatorView = [[UIView alloc] init];
        if (self.separatorView!=nil)
        {
            //!! 必須adjustsFontSizeToFitWidth設定為NO，否則font.pointSize無法抓到正確大小
            self.separatorView.backgroundColor = WCAppearanceDefine_SeparatorColor;
            self.separatorView.hidden = YES;
            [self addSubview:self.separatorView];
        }

        //////////////////////////////////////////////////
        
        _saveAsLabel = [[UILabel alloc] init];
        if (self.saveAsLabel!=nil)
        {
            //!! 必須adjustsFontSizeToFitWidth設定為NO，否則font.pointSize無法抓到正確大小
            self.saveAsLabel.backgroundColor = [UIColor whiteColor];
            self.saveAsLabel.adjustsFontSizeToFitWidth = NO;
            self.saveAsLabel.font = [UIFont systemFontOfSize:ContactInfoHeaderView_SaveAsLabelMaxFont];
            self.saveAsLabel.textColor = WCAppearanceDefine_CellTitleColor;
            self.saveAsLabel.userInteractionEnabled = NO;
            self.saveAsLabel.hidden = YES;
            [self addSubview:self.saveAsLabel];
        }
        
        //////////////////////////////////////////////////
        
        _contactCardMaskView = [[UIView alloc] initWithFrame:CGRectZero];
        if (self.contactCardMaskView!=nil)
        {
            self.contactCardMaskView.alpha                  = 0;
            self.contactCardMaskView.backgroundColor        = WCAppearanceDefine_NavigationBarColor;
            self.contactCardMaskView.userInteractionEnabled = NO;
            
            [self addSubview:self.contactCardMaskView];
        }
        
        //////////////////////////////////////////////////
        
        _contactHeadImageButton = [[PPButton buttonWithType:UIButtonTypeCustom] retain];
        if (self.contactHeadImageButton!=nil)
        {
            self.contactHeadImageButton.delegate =self;
            self.contactHeadImageButton.tag      = ContactInfoHeaderViewButtonTag_HeadImage;
            self.contactHeadImageButton.imageView.contentMode = UIViewContentModeScaleAspectFit;
            
            [self.contactHeadImageButton addControlEvents:UIControlEventTouchUpInside];
            [self addSubview:self.contactHeadImageButton];
        }
        
        //////////////////////////////////////////////////
        
        _contactNameLabel = [[UILabel alloc] init];
        if (self.contactNameLabel!=nil)
        {
            //!! 必須adjustsFontSizeToFitWidth設定為NO，否則font.pointSize無法抓到正確大小
            self.contactNameLabel.adjustsFontSizeToFitWidth = NO;
            self.contactNameLabel.font = [UIFont boldSystemFontOfSize:ContactInfoHeaderView_ContactNameLabelMaxFont];
            self.contactNameLabel.textColor = [UIColor whiteColor];
            self.contactNameLabel.userInteractionEnabled = YES;
            
            [self addShortPressGestureRecognizer];
            [self addSubview:self.contactNameLabel];
        }
      
        //////////////////////////////////////////////////
        
        _emptyErrorLabel = [[UILabel alloc] init];
        if (self.emptyErrorLabel!=nil)
        {
            self.emptyErrorLabel.text          = WCCV_MLS_FailedToLoadDatWithID;
            self.emptyErrorLabel.numberOfLines = 0;
            self.emptyErrorLabel.lineBreakMode = NSLineBreakByWordWrapping;
            self.emptyErrorLabel.textAlignment = NSTextAlignmentCenter;
            self.emptyErrorLabel.font          = [UIFont boldSystemFontOfSize:ContactInfoHeaderView_EmptyErrorLabelFontSize];
            self.emptyErrorLabel.textColor     = [UIColor redColor];
            self.emptyErrorLabel.hidden        = YES;
        }
        
        //////////////////////////////////////////////////
        
        _contactCardSwitchButton = [[PPButton buttonWithType:UIButtonTypeCustom] retain];
        if (self.contactCardSwitchButton!=nil)
        {
            self.contactCardSwitchButton.delegate = self;
            self.contactCardSwitchButton.hidden   = YES;
            self.contactCardSwitchButton.tag      = ContactInfoHeaderViewButtonTag_SwitchCard;
            self.contactCardSwitchButton.ppGuideIndex = PPGuideDataModel_GuideIndex_InfoContactCardSwitch;
            
            [self.contactCardSwitchButton addControlEvents:UIControlEventTouchUpInside];
            [self.contactCardSwitchButton setImageWithName:ImageNameWCContactViewControllerButtonChangeSide];
            [self.contactCardSwitchButton setImageEdgeInsets:UIEdgeInsetsMake(ContactInfoHeaderView_SwitchButtonImageInset, ContactInfoHeaderView_SwitchButtonImageInset, ContactInfoHeaderView_SwitchButtonImageInset, ContactInfoHeaderView_SwitchButtonImageInset)];
            [self addSubview:self.contactCardSwitchButton];
        }
        
        if (self.emptyErrorLabel!=nil)
        {
            //!! 單名片和雙名片擺放位置不一致
            [self.contactCardImageButton addSubview:self.emptyErrorLabel];
        }
    }
    
    return self;
}


//================================================================================
// 
//================================================================================
- (void)dealloc
{
    [self removeShortPressGestureRecognizer];
    
    [self.contactCardImageButton removeFromSuperview];
    self.contactCardImageButton.delegate = nil;
    self.contactCardImageButton = nil;
    
    [self.saveAsLabel removeFromSuperview];
    self.saveAsLabel = nil;
    
    [self.separatorView removeFromSuperview];
    self.separatorView = nil;
    
    [self.contactCardGuideFocusView removeFromSuperview];
    self.contactCardGuideFocusView = nil;
    
    [self.contactCardMaskView removeFromSuperview];
    self.contactCardMaskView = nil;
    
    [self.contactHeadImageButton removeFromSuperview];
    self.contactHeadImageButton.delegate = nil;
    self.contactHeadImageButton = nil;
    
    [self.contactNameLabel removeFromSuperview];
    self.contactNameLabel = nil;
    
    [self.emptyErrorLabel removeFromSuperview];
    self.emptyErrorLabel = nil;
    
    [self.contactCardSwitchButton removeFromSuperview];
    self.contactCardSwitchButton.delegate = nil;
    self.contactCardSwitchButton = nil;
    
    [self.cardImageIndicatorView removeFromSuperview];
    self.cardImageIndicatorView = nil;
    
    [self.headImageIndicatorView removeFromSuperview];
    self.headImageIndicatorView = nil;
    
    self.delegate = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
// 因為需進行比例的切割，需要得到界面高度
//================================================================================
- (void)layoutSubviews
{
    if (self.canUpdateConstraint==NO)
    {
        [self layoutInfoHeaderSubViews];
        
        self.canUpdateConstraint = YES;
    }
    
    //////////////////////////////////////////////////
    
    [super layoutSubviews];
}


//================================================================================
//
//================================================================================
- (void)setContactCardSwitchButtonVisible:(BOOL)contactCardSwitchButtonVisible
{
    _contactCardSwitchButtonVisible = contactCardSwitchButtonVisible;
    
    if (self.contactCardSwitchButtonVisible==YES)
    {
        self.contactCardSwitchButton.hidden = NO;
    }
    else
    {
        self.contactCardSwitchButton.hidden = YES;
    }
}


//==============================================================================
//
//==============================================================================
- (void)setShowSaveAsLabel:(BOOL)showSaveAsLabel
{
    _showSaveAsLabel = showSaveAsLabel;
    
    //////////////////////////////////////////////////
    
    self.saveAsLabel.hidden = !self.showSaveAsLabel;
    self.separatorView.hidden = !self.showSaveAsLabel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - LayoutConstraint

//================================================================================
//
//================================================================================
- (void)layoutInfoHeaderSubViews
{
    do
    {
        //////////////////////////////////////////////////
        // 界面例外判斷
        
        if (self.contactHeadImageButton==nil ||
            self.contactNameLabel==nil ||
            self.contactCardImageButton==nil ||
            self.contactCardSwitchButton==nil ||
            self.saveAsLabel==nil||
            self.separatorView==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        CGFloat contactHeadImageButtonSquareSize = ContactInfoHeaderView_ContactInfoHeight-ContactInfoHeaderView_InfoViewMargin*2;
        
        //////////////////////////////////////////////////
        // 水平Layout
        
        CGRect cardGuideFocusFrame   = self.bounds;
        CGRect cardMaskViewFrame     = self.bounds;
        CGRect headImageButtonFrame  = self.bounds;
        CGRect contactNameLabelFrame = self.bounds;

        cardGuideFocusFrame.size.width   = (cardGuideFocusFrame.size.height-ContactInfoHeaderView_ContactInfoHeight)/1.414;
        cardGuideFocusFrame.origin.x     = (self.bounds.size.width-cardGuideFocusFrame.size.width)/2;

        headImageButtonFrame.size.width  = contactHeadImageButtonSquareSize;
        headImageButtonFrame.origin.x    = ContactInfoHeaderView_InfoViewMargin;
        
         contactNameLabelFrame.origin.x   = headImageButtonFrame.origin.x+headImageButtonFrame.size.width+ContactInfoHeaderView_InfoViewMargin;
        contactNameLabelFrame.size.width = self.bounds.size.width-contactNameLabelFrame.origin.x;

        //////////////////////////////////////////////////
        // 垂直Layout
        CGFloat saveAsLabelHeight = 0;
        if (self.showSaveAsLabel)
        {
            saveAsLabelHeight = ContactInfoHeaderView_SaveAsInfoHeight;
        }

        cardGuideFocusFrame.size.height   = (cardGuideFocusFrame.size.height-ContactInfoHeaderView_ContactInfoHeight)/1.414;
        cardGuideFocusFrame.origin.y      = (self.bounds.size.height-ContactInfoHeaderView_ContactInfoHeight-saveAsLabelHeight-cardGuideFocusFrame.size.height)/2;

        headImageButtonFrame.size.height  = contactHeadImageButtonSquareSize;
        headImageButtonFrame.origin.y     = self.bounds.size.height-ContactInfoHeaderView_InfoViewMargin-headImageButtonFrame.size.height;
        
        contactNameLabelFrame.size.height = contactHeadImageButtonSquareSize;
        contactNameLabelFrame.origin.y    = self.bounds.size.height-ContactInfoHeaderView_InfoViewMargin-contactNameLabelFrame.size.height;
        
        //////////////////////////////////////////////////
        // 設定該頁面的SubView的frame
        
        self.contactCardGuideFocusView.frame = cardGuideFocusFrame;
        self.contactCardMaskView.frame = cardMaskViewFrame;
        self.contactHeadImageButton.frame = headImageButtonFrame;
        self.contactNameLabel.frame = contactNameLabelFrame;
        //////////////////////////////////////////////////
        // 定義大頭照的邊緣圓弧
        
        if(self.contactHeadImageButton.bounds.size.width>0 &&
           self.contactHeadImageButton.bounds.size.height>0)
        {
            UIBezierPath *bezierPath = [UIBezierPath bezierPath];
            
            if(bezierPath!=nil)
            {
                [bezierPath addArcWithCenter:CGPointMake(self.contactHeadImageButton.bounds.size.width/2, self.contactHeadImageButton.bounds.size.height/2)
                                      radius:MIN(self.contactHeadImageButton.bounds.size.width/2,self.contactHeadImageButton.bounds.size.height/2)
                                  startAngle:0
                                    endAngle:2*M_PI
                                   clockwise:YES];
                
                //////////////////////////////////////////////////
                
                CAShapeLayer *shapeLayer = [CAShapeLayer layer];
                
                if(shapeLayer!=nil)
                {
                    [shapeLayer setFrame:self.contactHeadImageButton.bounds];
                    [shapeLayer setPath:bezierPath.CGPath];
                    
                    self.contactHeadImageButton.layer.mask = shapeLayer;
                }
            }
        }
        
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        //////////////////////////////////////////////////
        
        CGFloat ContactInfoHeaderView_SwitchButtonBottomMargin = (ContactInfoHeaderView_ContactInfoHeight-ContactInfoHeaderView_SwitchButtonRect.size.height)/2;
        
        //////////////////////////////////////////////////
        // 水平Layout
        
        CGRect cardImageButtonFrame  = self.bounds;
        CGRect separatorFrame = self.bounds;
        CGRect saveAsLabelFrame = self.bounds;
        CGRect emptyErrorLabelFrame  = self.bounds;
        CGRect cardSwitchButtonFrame = self.bounds;
        contactNameLabelFrame = self.contactNameLabel.frame;
        
        emptyErrorLabelFrame.size.width  = emptyErrorLabelFrame.size.width-ContactInfoHeaderView_ErrorLabelMargin*2;
        
        cardSwitchButtonFrame.size.width = ContactInfoHeaderView_SwitchButtonRect.size.width;
        cardSwitchButtonFrame.origin.x   = self.bounds.size.width-cardSwitchButtonFrame.size.width;
        
        contactNameLabelFrame.size.width = contactNameLabelFrame.size.width-cardSwitchButtonFrame.size.width;
        
        //////////////////////////////////////////////////
        // 垂直Layout

        cardImageButtonFrame.size.height = cardImageButtonFrame.size.height-ContactInfoHeaderView_ContactInfoHeight-saveAsLabelHeight;
        
        separatorFrame.size.height = 1;
        separatorFrame.origin.y    = cardImageButtonFrame.origin.y+cardImageButtonFrame.size.height;

        saveAsLabelFrame.size.height = ContactInfoHeaderView_SaveAsInfoHeight;
        saveAsLabelFrame.origin.y    = separatorFrame.origin.y+separatorFrame.size.height;

        cardSwitchButtonFrame.size.height = ContactInfoHeaderView_SwitchButtonRect.size.height;
        cardSwitchButtonFrame.origin.y    = self.bounds.size.height-ContactInfoHeaderView_SwitchButtonBottomMargin-cardSwitchButtonFrame.size.height;
        
        //////////////////////////////////////////////////
        // 錯誤Label訊息Layout
        
        self.emptyErrorLabel.frame = emptyErrorLabelFrame;
        
        [self.emptyErrorLabel sizeToFit];
        
        self.emptyErrorLabel.center = CGPointMake(CGRectGetMidX(cardImageButtonFrame), CGRectGetMidY(cardImageButtonFrame));
        
        //////////////////////////////////////////////////
        // 設定該頁面的SubView的frame
        
        self.contactCardImageButton.frame = cardImageButtonFrame;
        self.contactCardSwitchButton.frame = cardSwitchButtonFrame;
        self.contactNameLabel.frame = contactNameLabelFrame;
        self.saveAsLabel.frame = saveAsLabelFrame;
        self.separatorView.frame = separatorFrame;
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactImageProtocol

//================================================================================
//
//================================================================================
- (void)setContactHeadImage:(UIImage *)contactHeadImage
{
    if (contactHeadImage!=nil)
    {
        //////////////////////////////////////////////////

        CGFloat scale = 0.0;
        UIImage *temp = nil;
        CGFloat headImageSize = ContactInfoHeaderView_ContactInfoHeight-ContactInfoHeaderView_InfoViewMargin*2;
        
        if (contactHeadImage.size.width>=contactHeadImage.size.height)
        {
            scale = headImageSize/contactHeadImage.size.height;
            temp = [contactHeadImage imageScalingMaxLength:contactHeadImage.size.width*scale];
        }
        else
        {
            scale = headImageSize/contactHeadImage.size.width;
            temp = [contactHeadImage imageScalingMaxLength:contactHeadImage.size.height*scale];
        }
        
        [self.contactHeadImageButton setImage:temp];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage
{
    if (contactFrontCardImage!=nil)
    {
        [self.contactCardImageButton setImage:contactFrontCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage
{
    if (contactRearCardImage!=nil)
    {
        [self.contactCardImageButton setImage:contactRearCardImage];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)addShortPressGestureRecognizer
{
    if(self.shortPressGestureRecognizer==nil)
    {
        _shortPressGestureRecognizer = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(handleShortNamePress:)];
        
        if(self.shortPressGestureRecognizer!=nil)
        {
            self.shortPressGestureRecognizer.minimumPressDuration = ContactInfoHeaderView_ContactNameShortPressDuration; //seconds
            [self.contactNameLabel addGestureRecognizer:self.shortPressGestureRecognizer];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)handleShortNamePress:(UILongPressGestureRecognizer *)sender
{
    if(sender.state==UIGestureRecognizerStateBegan)
    {        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(contactInfoHeaderViewDidShortPressContactName:)]==YES)
        {
            [self.delegate contactInfoHeaderViewDidShortPressContactName:self];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)removeShortPressGestureRecognizer
{
    [self removeGestureRecognizer:self.shortPressGestureRecognizer];
    self.shortPressGestureRecognizer = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//==============================================================================
//
//==============================================================================
- (void)setCardImagePositionY:(CGFloat)positionY
{
    CGRect cardFrame = self.contactCardImageButton.frame;
    cardFrame.origin.y = positionY;
    self.contactCardImageButton.frame = cardFrame;
    
    // salesforce下方會多一條線，一個label
    if(self.showSaveAsLabel)
    {
        CGRect lineFrame =self.separatorView.frame;
        lineFrame.origin.y = cardFrame.origin.y+cardFrame.size.height;
        self.separatorView.frame = lineFrame;
        
        CGRect labelFrame =self.saveAsLabel.frame;
        labelFrame.origin.y = lineFrame.origin.y+lineFrame.size.height;
        self.saveAsLabel.frame = labelFrame;
    }
}


//================================================================================
//
//================================================================================
- (void)cardImageIndicatorViewVisible:(BOOL)visible
{
    if (visible==YES)
    {
        if (self.cardImageIndicatorView==nil)
        {
            _cardImageIndicatorView = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(0, 0, self.contactCardImageButton.bounds.size.width, self.contactCardImageButton.bounds.size.height)];
        }
        
        if (self.cardImageIndicatorView!=nil)
        {
            self.cardImageIndicatorView.activityIndicatorViewStyle = UIActivityIndicatorViewStyleWhiteLarge;
            self.cardImageIndicatorView.color = [UIColor colorWithHexString:@"#75A6F0"];
            
            [self.cardImageIndicatorView startAnimating];
            [self.contactCardImageButton addSubview:self.cardImageIndicatorView];
        }
    }
    else
    {
        [self.cardImageIndicatorView stopAnimating];
        [self.cardImageIndicatorView removeFromSuperview];
        self.cardImageIndicatorView = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)headImageIndicatorViewVisible:(BOOL)visible
{
    if (visible==YES)
    {
        if(self.headImageIndicatorView==nil)
        {
            _headImageIndicatorView = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(0, 0, self.contactHeadImageButton.bounds.size.width, self.contactHeadImageButton.bounds.size.height)];
        }
        
        if(self.headImageIndicatorView!=nil)
        {
            self.headImageIndicatorView.activityIndicatorViewStyle = UIActivityIndicatorViewStyleWhiteLarge;
            self.headImageIndicatorView.color = [UIColor colorWithHexString:@"#75A6F0"];
            
            [self.headImageIndicatorView startAnimating];
            [self.contactHeadImageButton addSubview:self.headImageIndicatorView];
        }
    }
    else
    {
        [self.headImageIndicatorView stopAnimating];
        [self.headImageIndicatorView removeFromSuperview];
        self.headImageIndicatorView = nil;
    }
}

//================================================================================
//
//================================================================================
- (void)emptyErrorMessageLabelVisible:(BOOL)visible
{
    self.emptyErrorLabel.hidden = !visible;
}


//================================================================================
//
//================================================================================
- (void)showDefaultHeadImage
{
    [self.contactHeadImageButton setImageWithName:ImageNameWCContactInfoViewControllerDefaultHead];
}


//================================================================================
//
//================================================================================
- (void)setContactName:(NSString *)contactName
{
    self.contactNameLabel.text = contactName;
}


//================================================================================
//
//================================================================================
- (void)setContactCardMaskAlpha:(CGFloat)colorAlpha switchButtonHidden:(BOOL)isHidden
{
    self.contactCardMaskView.alpha = colorAlpha;
    
    if (isHidden==NO)
    {
        self.contactCardImageButton.userInteractionEnabled = YES;
        self.contactHeadImageButton.userInteractionEnabled = YES;
        
        //////////////////////////////////////////////////
        //!! 需判斷是否AP端要求顯示按鈕
        if (self.contactCardSwitchButtonVisible==YES)
        {
            self.contactCardSwitchButton.hidden = NO;
        }
    }
    else
    {
        self.contactCardImageButton.userInteractionEnabled = NO;
        self.contactHeadImageButton.userInteractionEnabled = NO;
        self.contactCardSwitchButton.hidden = YES;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(contactInfoHeaderView:ppButton:didControlEvents:)]==YES)
    {
        [self.delegate contactInfoHeaderView:self ppButton:ppButton didControlEvents:controlEvent];
    }
}

@end
