//
//  PPContactInfoSectionController.m
//
//  Created by Howard.Lin on 13/10/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPContactInfoSectionController.h"
#import "ContactDataExchangeModel.h"
#import "PPContactRowObject.h"
#import "NSDictionary+SortKey.h"
#import "PPRowModel+Contact.h"
#import "WCContactViewController+PublicParameterDefine.h"

@interface PPContactInfoSectionController()
{
   @private
    ContactInfoDataModel   *dataModel_;
    NSDictionary           *currentFieldDictionary_;
    PPContactNameOrder     easterNameOrder_;
    PPContactNameOrder     westernNameOrder_;
}

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPContactInfoSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 dataModel              = dataModel_,
 currentFieldDictionary = currentFieldDictionary_,
 easterNameOrder        = easterNameOrder_,
 westernNameOrder       = westernNameOrder_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        dataModel_ = [[ContactInfoDataModel alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [dataModel_ release];
    dataModel_ = nil;
    
    [currentFieldDictionary_ release];
    currentFieldDictionary_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)validPhone
{
    BOOL result = NO;
    
    
    for (PPContactSectionModel *contactSectionModel in self.sectionModelsForDefault)
    {
        if(contactSectionModel.contactMainType!=PPContactMainType_Phone)
        {
            continue;
        }
        
        //////////////////////////////////////////////////
        
        for (PPRowModel *rowModel in contactSectionModel.rowModels)
        {
            NSDictionary *inputValueDictionary = [rowModel ppContactRowObjectOfRowModel].inputValueDictionary;
            
            if(inputValueDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for (id key in inputValueDictionary.allKeys)
            {
                id object = [inputValueDictionary objectForKey:key];
                
                if([object respondsToSelector:@selector(length)]==YES &&
                   [object performSelector:@selector(length)]>0)
                {
                    result = YES;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(result==YES)
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(result==YES)
        {
            break;
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)fetchFieldDictionary:(NSDictionary *)fieldDictionary toSectionModelsForSearching:(BOOL)searching frontCardBCRRecognitionLanguage:(NSUInteger)frontCardBCRRecognitionLanguage backCardBCRRecognitionLanguage:(NSUInteger)backCardBCRRecognitionLanguage orders:(NSArray *)orders
{
    NSMutableArray *sectionModels = nil;
    do
    {
        if(fieldDictionary==nil)
        {
            break;
        }
    
        sectionModels = [NSMutableArray array];
        //////////////////////////////////////////////////
        
        //!移除現在存在的資料
//        [[self sectionModelsForSearching:searching]removeAllObjects];
        
        //////////////////////////////////////////////////
        
        self.currentFieldDictionary = fieldDictionary;
        
        //////////////////////////////////////////////////
    
        NSArray *allkey = [fieldDictionary sortKeyByAscending];
        
        //////////////////////////////////////////////////
        
        for(id key in orders)
        {
            if([allkey indexOfObject:key]!=NSNotFound)
            {
                @autoreleasepool
                {
                    NSArray *targetFields = [fieldDictionary objectForKey:key];
                    
                    //////////////////////////////////////////////////
                    
                    PPContactSectionModel *sectionModel = nil;
                    
                    switch ([key unsignedIntegerValue])
                    {
                        case PPContactMainType_Name:
                        {
                            NSString *salutationString = nil;
                            ContactDataExchangeModel *salutationDataModel = [[fieldDictionary objectForKey:@(PPContactMainType_Salutation)] firstObject];
                            
                            if (salutationDataModel)
                            {
                                salutationString = [salutationDataModel.propertyDictionary objectForKey:@(PPContactSubType_ListValue)];
                                
                                // !! 如果是空值或是disable, 要過濾
                                if ([salutationString isEqualToString:WCVC_EditViewControllerSelectEmptyValue]||
                                    [salutationString isEqualToString:WCVC_EditViewControllerSelectDisableValue])
                                {
                                    salutationString = nil;
                                }
                            }
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingNameContactDataExchangeModels:targetFields
                                                                                                                     salutation:salutationString
                                                                                                                easterNameOrder:self.easterNameOrder
                                                                                                               westernNameOrder:self.westernNameOrder
                                                                                                                   showPhonetic:self.showPhonetic];
                            
                            break;
                        }
                        case PPContactMainType_Company:
                        {
#if defined (PRODUCTLINE_WCSF)
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingSalesforceCompanyDataExchangeModels:targetFields];
#else
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingCompanyContactDataExchangeModels:targetFields
                                                                                                                      showPhonetic:self.showPhonetic];
#endif     
                            break;
                        }
                        case PPContactMainType_Address:
                        {
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingAddressContactDataExchangeModels:targetFields frontCardBCRRecognitionLanguage:frontCardBCRRecognitionLanguage backCardBCRRecognitionLanguage:backCardBCRRecognitionLanguage];
                            
                            break;
                        }
                        case PPContactMainType_Group:
                        case PPContactMainType_SystemGroup:
                        {
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingGroupContactDataExchangeModels:targetFields];
                            
                            break;
                        }
                        case PPContactMaintype_VisibleAccount:
                        {
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingVisibleAccountContactDataExchangeModels:targetFields];
                            
                            break;
                        }
                        case PPContactMainType_Status:
                        {
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingSalesforceStatusDataExchangeModels:targetFields];
                            break;
                        }
                        case PPContactMainType_SalesforceSaveAs:
                        {
                            // !! 這個不在檢視的table中，而是在headerView上
                            break;
                        }
                        case PPContactMainType_Salutation:
                        {
                            // !! 不用顯示為section, 在Name中處理
                            break;
                        }
                        default:
                        {
                            sectionModel = [[self.dataModel class] ppContactSectionModelForParsingNormalContactDataExchangeModels:targetFields ppContactMainType:[key unsignedIntegerValue]];
                            
                            break;
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(sectionModel!=nil && sectionModel.rowModels.count>0)
                    {
                        [sectionModels addObject:sectionModel];
                    }
                }
            }
        }
        
        // 取代
        
    } while (0);
    
    return sectionModels;
}


//==============================================================================
//
//==============================================================================
- (NSString *)fetchSaveAsStringFromFieldDictionary:(NSDictionary *)fieldDictionary
{
    NSString *saveAsString = nil;
    do
    {
        if(fieldDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSArray *targetFields = [fieldDictionary objectForKey:@(PPContactMainType_SalesforceSaveAs)];

        ContactDataExchangeModel *exchangeModel =  [targetFields firstObject];
        saveAsString = [exchangeModel.propertyDictionary objectForKey:@(PPContactSubType_ListValue)];
    } while (0);
    
    return saveAsString;
}

@end
