//
//  ContactInfoViewController.h
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/5/20.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//

// Model
#import "WCContactInfoViewController+ResouceDefine.h"
#import "ContactDataExchangeProtocol.h"
#import "WCDisplayNameDefine.h"

// View
#import "ContactInfoNavigationBarView.h"

// Controller
#import "WCContactViewController.h"
#import "PPGuideController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat const ContactInfoViewController_LandscapeContactCardWidthPercent = 0.60f;
static CGFloat const ContactInfoViewController_PortraitContactCardHeightPercent = 0.35f;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ContactInfoViewControllerAction)
{
    ContactInfoViewControllerAction_Back = 1,
    ContactInfoViewControllerAction_Favorite,
    ContactInfoViewControllerAction_Note,
    ContactInfoViewControllerAction_Edit,
    ContactInfoViewControllerAction_ShareContact,
    ContactInfoViewControllerAction_SaveContact,
    ContactInfoViewControllerAction_Translate,
    ContactInfoViewControllerAction_Recognize,
    ContactInfoViewControllerAction_CommunitySearch,
    ContactInfoViewControllerAction_DeleteContact,
    ContactInfoViewControllerAction_ChangeGroup,
    ContactInfoViewControllerAction_ClickCardImage,
    ContactInfoViewControllerAction_ChangeVisibleAccount
};

typedef NS_ENUM(NSUInteger, ContactInfoViewControllerInterfaceStyle)
{
    ContactInfoViewControllerInterfaceStyle_Browse,             ///<- 可修改我的最愛，群組，可檢視用戶，有更多選項, note, 也可操作action
    ContactInfoViewControllerInterfaceStyle_CompanyContacts,      ///<- 只能看，可操作action，不能編輯，不能修改我的最愛，群組，可檢視用戶
    ContactInfoViewControllerInterfaceStyle_DuplicateBrowse,    ///<- 只能看，不能編輯或操作action
    ContactInfoViewControllerInterfaceStyle_NearbyContacts,     ///<- 可修改我的最愛，群組，可檢視用戶, 也可操作action，只有navigation bar不同，無法進入編輯，note。
    ContactInfoViewControllerInterfaceStyle_ContactsForSalesforce,  ///<- action 只有copy, 沒有我的最愛，選單沒有分享，
    ContactInfoViewControllerInterfaceStyle_Translate           ///<- 目前沒有這個模式
};

typedef NS_ENUM(NSUInteger, ContactInfoViewControllerUserInterfaceIdom)
{
    ContactInfoViewControllerUserInterfaceIdom_Phone,
    ContactInfoViewControllerUserInterfaceIdom_Pad
};

typedef NS_ENUM(NSUInteger, ContactInfoViewControllerTranslateLocation)
{
    ContactInfoViewControllerTranslateLocation_Source,
    ContactInfoViewControllerTranslateLocation_Destination
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoViewControllerDataSource

@class ContactInfoViewController;
@protocol ContactInfoViewControllerDataSource <NSObject>

@required
- (BOOL)shouldShowPhoneticOnContactInfoViewController:(ContactInfoViewController *)contactInfoViewController;

- (WCDisplayNameOrder)contactNameEastOrderInContactInfoViewController:(ContactInfoViewController *)contactInfoViewController;
- (WCDisplayNameOrder)contactNameWestOrderInContactInfoViewController:(ContactInfoViewController *)contactInfoViewController;

- (NSMutableArray *)ppContactMainTypeArrayFetchingDataForContactInfoViewController:(ContactInfoViewController *)contactInfoViewController ;

- (NSUInteger)contactInfoTableViewCellTextMaxLengthInContactInfoViewController:(ContactInfoViewController *)contactInfoViewController
                                                             ppContactMainType:(PPContactMainType)contactMainType;

- (NSArray *)translateLanguageArrayInContactInfoViewController:(ContactInfoViewController *)contactInfoViewController
                                             translateLocation:(ContactInfoViewControllerTranslateLocation)translateLocation;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoViewControllerDelegate

@protocol ContactInfoViewControllerDelegate <NSObject>

@required
- (void)contactInfoViewController:(ContactInfoViewController *)contactInfoViewController
                    responderView:(UIView *)responderView
                           action:(ContactInfoViewControllerAction)action;

@optional
- (void)contactInfoViewController:(ContactInfoViewController *)contactInfoViewController
         didSelectValueDictionary:(NSDictionary *)valueDictionary;

/**
 *  將當前點擊電話號碼後方按鈕事件傳出去，因為目前只有"傳簡訊功能"所以只傳電話號碼
 *
 *  @param contactInfoViewController contactInfoViewController
 *  @param phoneNumber               phoneNumber
 */
- (void)contactInfoViewController:(ContactInfoViewController *)contactInfoViewController
             didSelectPhoneNumber:(NSString *)phoneNumber;

/**
 *  通知外部將contactMainType內資料索引為fieldIndex的資料設定為第一筆
 *
 *  @param contactInfoViewController contactInfoViewController
 *  @param fieldIndex                點選的CellIndexRow，將設定為第一筆的資料
 *  @param contactMainType           對哪一個contactMainType進行順序的變動
 */
- (void)contactInfoViewController:(ContactInfoViewController *)contactInfoViewController
                    setFieldIndex:(NSUInteger)fieldIndex
            toDefaultWithMainType:(PPContactMainType)contactMainType;


/**
 *  通知外部在翻譯聯絡人介面時，變更了翻譯語系
 *
 *  @param contactInfoViewController contactInfoViewController
 *  @param fromLanguage              來源語系
 *  @param toLanguage                目的語系
 */
- (void)contactInfoViewController:(ContactInfoViewController *)contactInfoViewController
            translateFromLanguage:(NSString *)fromLanguage
                       toLanguage:(NSString *)toLanguage;


/**
 *  當改筆聯絡人前後名片圖皆沒有，需外部提供該聯絡人的假名片
 *
 *  @param contactInfoViewController contactInfoViewController
 *
 *  @return 假名片圖(若內部自行製作，因為需聯絡人資料進行製作，擔心時間上問題)
 */
- (UIImage *)defaultCardImageInContactInfoViewController:(ContactInfoViewController *)contactInfoViewController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoViewController Interface

@interface ContactInfoViewController : WCContactViewController
@property (nonatomic, assign) id<ContactInfoViewControllerDataSource> dataSource;
@property (nonatomic, assign) id<ContactInfoViewControllerDelegate>   delegate;

@property (nonatomic, assign)   BOOL isShowDefaultView;
@property (nonatomic, readonly) BOOL isContactCardSwitchShowed;
@property (nonatomic, readonly) BOOL haveLongPressCell;
@property (nonatomic, assign)   BOOL isBackButtonShowed; //Default is YES, In iPad may not show back button.
@property (nonatomic, assign)   ContactInfoViewControllerInterfaceStyle    interfaceStyle;
@property (nonatomic, assign)   ContactInfoViewControllerUserInterfaceIdom interfaceIdom;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * 將NavigationBar上的按鈕隱藏
 *
 *  @param offsetX 透過左右滾動的距離，計算按鈕的透明度，以至於隱藏動畫
 */
- (void)contactInfoNavigationBarButtonsAlphaWithOffset:(CGFloat)offsetX;

/**
 *  當進行聯絡人切換或重載當前聯絡人時需清除所有影像紀錄
 */
- (void)clearImageForAllPPContactMainType;

/**
 * 當進行聯絡人切換或重載當前聯絡人時需清除所有資訊紀錄
 */
- (void)clearFieldDictionaryForAllAllPPContactMainType;

/**
 *  回復界面初始位置設定
 */
- (void)recoveryInterfaceInitialSetting;

/**
 *  準備要呈現的資料(fieldDictionary)
 */
- (void)prepareContactFieldDictionary;

/**
 *  重新抓取聯絡人的資料
 *  當isReload設定為YES時，即進行TableView內容更新，可自行決定是否接收完成資料擷取訊息complete
 */
- (void)fetchContactFieldDictionaryWithReload:(BOOL)isReload loadDictionaryCompleted:(void (^)(void))loadDictionaryCompleted;


- (void)updateInfoLayoutWithKeyboardHeight:(CGFloat)keyboardHeight;

@end
