//
//  WCContactEditViewController+Salesforce.m
//  
//
//  Created by Howard on 2019/2/19.
//

#import "WCContactEditViewController+Salesforce.h"


#import "WCContactEditViewController+ContactEditViewDelegate.h"

// Define
#import "PPDateSectionController+ParameterDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactEditViewController+ResouceDefine.h"
#import "WCContactEditViewController+SettingKey.h"

#import "WCFieldDefine.h"

// Category
#import "NSDate+Format.h"
#import "PPRowModel+Contact.h"
#import "UIView+PPGuideController.h"
#import "WCContactEditViewController+ContactEditViewDelegate.h"

// View
#import "ContactDataPickerTableViewCell.h"
#import "ContactDatePickerTableViewCell.h"
#import "ContactDateAndTimeTextFieldTableViewCell.h"
#import "ContactPhoneTextFieldTableViewCell.h"
#import "ContactMultipleTextFieldButtonTableViewCell.h"
#import "ContactEditNavigationBarView.h"
#import "ContactTextFieldTableViewCell.h"
#import "ContactTextViewTableViewCell.h"
#import "PPSwitchTableViewCell.h"
#import "PPTableViewCell.h"

// Controller
#import "PPGuideController.h"
#import "PPSettingsController.h"




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation WCContactEditViewController (Salesforce)


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)addSalesforceGuidesData
{
    BOOL result = NO;
    
    [PPGuideController setDelegate:self];
    
    //////////////////////////////////////////////////
    // prepare guide data
    
    [PPGuideController clearAllGuideScripts];
    
    @autoreleasepool
    {
        NSMutableArray *guideDataModels = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        
        if(guideDataModels!=nil)
        {
            if([PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideSalesforceTarget]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideSalesforceTarget];
                
                //////////////////////////////////////////////////
                
                PPGuideFocusModel *rectFocusModel = [PPGuideFocusModel modelWithGuideFocusShape:PPGuideFocusShape_Rectangle
                                                                                canTouchThrough:NO
                                                                                targetAreaInset:CGSizeZero
                                                                                    infoAreaGap:WCAppearanceDefine_RectFocusModeInfoAreaGap];
                
                
                
                [guideDataModels addObject:[PPGuideDataModel modelWithGuideFocusModel:rectFocusModel
                                                                      targetClassName:NSStringFromClass([self class])
                                                                           guideIndex:WCContactEditViewControllerGuideIndex_SalesforceTarget
                                                                                title:@""
                                                                              message:WCCV_MLS_GuideToSalesforceTargetMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            
            //////////////////////////////////////////////////

            BOOL existFrontCardImage = NO;
            
            if([self respondsToSelector:@selector(existFrontCardImage)]==YES)
            {
                existFrontCardImage = [self performSelector:@selector(existFrontCardImage)];
            }
            
            BOOL existRearCardImage = NO;
            
            if([self respondsToSelector:@selector(existRearCardImage)]==YES)
            {
                existRearCardImage = [self performSelector:@selector(existRearCardImage)];
            }
            
            //////////////////////////////////////////////////

            if(existFrontCardImage==YES &&
               existRearCardImage==YES &&
               [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideFlipCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideFlipCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_Flip
                                                                                title:WCCV_MLS_GuideFlipTitle
                                                                              message:WCCV_MLS_GuideFlipMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if(existFrontCardImage==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddFrontCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddFrontCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard
                                                                                title:WCCV_MLS_GuideAddFrontCardTitle
                                                                              message:WCCV_MLS_GuideAddFrontCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if(existFrontCardImage==YES &&
                    existRearCardImage==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddRearCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddRearCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddBackCard
                                                                                title:WCCV_MLS_GuideAddBackCardTitle
                                                                              message:WCCV_MLS_GuideAddBackCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
           
            //////////////////////////////////////////////////
            
            if(guideDataModels.count>0)
            {
                [PPGuideController addGuideScriptWithName:NSStringFromClass([self class]) guideDataModels:guideDataModels];
                
                result = YES;
            }
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)salesforceMoreButtons
{
    NSMutableArray *moreButtons = nil;
    
    do
    {
        moreButtons = [NSMutableArray array];
        
        if(moreButtons==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPCommentButton *noteButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                             buttonImageName:ImageNameWCContactViewControllerMoreButtonNote
                                                               buttonComment:WCCV_MLS_Note];
        
        if(noteButton==nil)
        {
            break;
        }
        
        noteButton.tag = WCContactEditViewControllerButtonTag_Note;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:noteButton];
        
        [noteButton release];
        
        //////////////////////////////////////////////////
        
        if(self.hideAddOrFlipContactCardButton==NO)
        {
            PPCommentButton *replaceImageButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                         buttonImageName:ImageNameContactEditViewControllerMoreButtonChange
                                                                           buttonComment:WCCV_MLS_ReplaceCard];
            
            if(replaceImageButton==nil)
            {
                break;
            }
            
            replaceImageButton.tag = WCContactEditViewControllerButtonTag_ReplaceCard;
            
            //////////////////////////////////////////////////
            
            [moreButtons addObject:replaceImageButton];
            
            [replaceImageButton release];
        }
        
        //////////////////////////////////////////////////
        
        PPCommentButton *deleteContactButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                      buttonImageName:ImageNameWCContactViewControllerMoreButtonDelete
                                                                        buttonComment:WCCV_MLS_DeleteContacter];
        
        if(deleteContactButton==nil)
        {
            break;
        }
        
        deleteContactButton.tag = WCContactEditViewControllerButtonTag_DeleteContact;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:deleteContactButton];
        
        [deleteContactButton release];
        
        //////////////////////////////////////////////////
        
        for(PPCommentButton *button in moreButtons)
        {
            [button.titleLabel setFont:[UIFont systemFontOfSize:PPTopButtonFontSize]];
            
            //////////////////////////////////////////////////
            
            [button setBackgroundImage:[UIImage imageWithColor:PPTopButtonBackgroundColorHighlighted]
                              forState:UIControlStateHighlighted];
            
            [button setCommentTextColorNormal:PPTopButtonFontColorNormal];
            [button setCommentTextColorHighlighted:PPTopButtonFontColorHighlighted];
        }
        
    }
    while (0);
    
    return moreButtons;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)contactEditView:(ContactEditView *)contactEditView
     salesforceCellForRowAtIndexPath:(NSIndexPath *)indexPath
                            rowModel:(PPRowModel *)rowModel
{
    UITableViewCell *cell = nil;

    //////////////////////////////////////////////////

    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
    
    switch (contactRowObject.contactMainType)
    {
        case PPContactMainType_Salutation:
        case PPContactMainType_Status:
        {
            if(contactRowObject.tableViewCellStyle==PPContactTableViewCellStyle_TextField)
            {
                cell = [self contactEditView:contactEditView
                     wcCellForRowAtIndexPath:indexPath
                                    rowModel:rowModel];
            }
            else
            {
                // MARK: 資料選擇欄位
                
                cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:DataPickerCellIdentifier];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[ContactDataPickerTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:DataPickerCellIdentifier] autorelease];
                }
                else if([cell respondsToSelector:@selector(reuse)]==YES)
                {
                    [cell performSelector:@selector(reuse)];
                }
                
                //////////////////////////////////////////////////
                
                ContactDataPickerTableViewCell *dataPickerFieldCell = (ContactDataPickerTableViewCell *)cell;
                
                //!!讓游標顏色消失
                if([[[UIDevice currentDevice]systemVersion]floatValue]>=7.0)
                {
                    dataPickerFieldCell.textField.tintColor = [UIColor clearColor];
                }
                else
                {
                    [[dataPickerFieldCell.textField valueForKey:@"textInputTraits"] setValue:[UIColor clearColor]
                                                                                      forKey:@"insertionPointColor"];
                }
                
                dataPickerFieldCell.delegate = contactEditView;
                dataPickerFieldCell.contactKeyboardToolBarViewDelegate = contactEditView;
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, contactEditView.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.ignoreCustomLabelFrame = YES;
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textLabel.text = rowModel.text;
                [dataPickerFieldCell.textLabel setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////
                
                if(contactRowObject.inputValueDictionary.count>0)
                {
                    NSString *text = [contactRowObject visibleTextFromSubType];
                    
                    if([text isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES)
                    {
                        dataPickerFieldCell.textField.text = @"";
                    }
                    else if([text isEqualToString:WCVC_EditViewControllerSelectDisableValue]==YES)
                    {
                        dataPickerFieldCell.textField.text = WCCV_MLS_EditListDisable;
                    }
                    else
                    {
                        dataPickerFieldCell.textField.text = text;
                    }
                }
                else
                {
                    dataPickerFieldCell.textField.text = @"";
                }
                
                //////////////////////////////////////////////////
                
                dataPickerFieldCell.textField.placeholder = [contactRowObject localizedPlaceholder];
                [dataPickerFieldCell.textField setFont:[UIFont systemFontOfSize:WCContactEditViewControllerTableViewCellTextFontSize]];
                
                //////////////////////////////////////////////////

                NSArray *itemsMenu = [contactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_ItemMenu)];

                dataPickerFieldCell.itemsMenu = itemsMenu;
                
                //////////////////////////////////////////////////

                dataPickerFieldCell.textField.clearButtonMode = ([[itemsMenu firstObject] isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES) ? UITextFieldViewModeWhileEditing : UITextFieldViewModeNever;
                
                //////////////////////////////////////////////////

                BOOL disable = [[contactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_ListValue)] isEqualToString:WCVC_EditViewControllerSelectDisableValue];
                
                if(disable==YES)
                {
                    dataPickerFieldCell.userInteractionEnabled = NO;
                    dataPickerFieldCell.textField.backgroundColor = [UIColor lightGrayColor];
                    dataPickerFieldCell.textField.textColor = [UIColor whiteColor];
                }
                else
                {
                    dataPickerFieldCell.userInteractionEnabled = YES;
                    dataPickerFieldCell.textField.backgroundColor = [UIColor clearColor];
                    dataPickerFieldCell.textField.textColor = WCContactEditViewCOntrollerTableViewCellTextColor;
                }
                
                //////////////////////////////////////////////////
                
                NSInteger row = [dataPickerFieldCell.itemsMenu indexOfObject:dataPickerFieldCell.textField.text];
                
                if(row==NSNotFound)
                {
                    row = 0;
                }
                
                [dataPickerFieldCell selectRow:row
                                      animated:NO];
            }
          
            break;
        }
        case PPContactMainType_SalesforceSaveAs:
        {
            cell = [contactEditView.contactEditTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td",PPContactMainType_SalesforceSaveAs]];
            
            //////////////////////////////////////////////////
            
            if(cell==nil)
            {
                cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                               reuseIdentifier:[NSString stringWithFormat:@"%td",PPContactMainType_SalesforceSaveAs]] autorelease];
            }
  
            cell.ppGuideIndex = WCContactEditViewControllerGuideIndex_SalesforceTarget;
            cell.textLabel.text = rowModel.text;
            
            //////////////////////////////////////////////////
            
            cell.textLabel.numberOfLines = 0;
            cell.textLabel.lineBreakMode = NSLineBreakByWordWrapping;
            cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
            
            break;
        }
        default:
        {
            cell = [self contactEditView:contactEditView
                 wcCellForRowAtIndexPath:indexPath
                                rowModel:rowModel];
            
            break;
        }
    }
        
    //////////////////////////////////////////////////
    
    cell.selectionStyle = UITableViewCellSelectionStyleDefault;

    //////////////////////////////////////////////////

    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - cell 勾選相關流程



//==============================================================================
//
//==============================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wcsfDidSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [rowModel ppContactRowObjectOfRowModel].selected = YES;
        
        self.edited = YES;
        
        //////////////////////////////////////////////////
        
        // 單選其它反白
        PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        for(NSInteger rowIndex=0; rowIndex<sectionModel.rowModels.count; rowIndex++)
        {
            if(rowIndex==indexPath.row)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            PPRowModel *iterRowModel = [sectionModel.rowModels objectAtIndex:rowIndex];
            
            if([iterRowModel ppContactRowObjectOfRowModel].selected==NO)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            // 不是同類型的欄位，不用反白
            if([iterRowModel ppContactRowObjectOfRowModel].contactLabelType!=[rowModel ppContactRowObjectOfRowModel].contactLabelType)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            [iterRowModel ppContactRowObjectOfRowModel].selected = NO;
            
            [contactEditView.contactEditTableView deselectRowAtIndexPath:[NSIndexPath indexPathForRow:rowIndex inSection:indexPath.section]
                                                                animated:NO];
        }
    }
    while (0);
}

//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wcsfDidDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:indexPath];
    
    // MARK: 取消框選
    if (cell.editingStyle==(UITableViewCellEditingStyleDelete|UITableViewCellEditingStyleInsert))
    {
        NSUInteger validCountOnLabelType = 0;
        
        do
        {
            PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForDefault] objectAtIndex:indexPath.section];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(PPRowModel *iterRowModel in sectionModel.rowModels)
            {
                if([rowModel ppContactRowObjectOfRowModel].contactLabelType!=[iterRowModel ppContactRowObjectOfRowModel].contactLabelType)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                if([iterRowModel ppContactRowObjectOfRowModel].selected==NO)
                {
                    continue;
                }
                
                validCountOnLabelType ++;
            }
            
            //////////////////////////////////////////////////
            
            if(validCountOnLabelType>1)
            {
                [rowModel ppContactRowObjectOfRowModel].selected = NO;
            }
            else
            {
                // 至少存在一個，所以在點擊一次
                [contactEditView.contactEditTableView selectRowAtIndexPath:indexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
            }
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wcsfWillDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if(contactRowObject.editingStyle==UITableViewCellEditingStyleNone)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(contactRowObject.selected==NO)
        {
            break;
        }
        
        [contactEditView.contactEditTableView selectRowAtIndexPath:indexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    }
    while (0);
}
@end
