//
//  SalesforceEditDataModel.m
//  
//
//  Created by Howard on 2019/2/18.
//

#import "SalesforceEditDataModel.h"

@implementation SalesforceEditDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
+ (NSUInteger)labelType:(PPContactLabelType)labelType
         countForFields:(NSArray <ContactDataExchangeModel *> *)fields
{
    NSUInteger count = 0;
    
    for(ContactDataExchangeModel *dataExchangeModel in fields)
    {
        if(dataExchangeModel.labelType==labelType)
        {
            count++;
        }
    }
    
    return count;
}


//================================================================================
//
//================================================================================
+ (NSUInteger)labelType:(PPContactLabelType)labelType countForSectionModel:(PPSectionModel *)sectionModel
{
    NSUInteger count = 0;
    
    for(PPRowModel *rowModel in sectionModel.rowModels)
    {
        PPContactRowObject *rowObject = rowModel.object;
        
        if(rowObject.contactLabelType==labelType)
        {
            count++;
        }
    }
    
    return count;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
{
    NSMutableArray *workArray = [NSMutableArray array];
    
    do
    {
        if(workArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (contactMainType)
        {
            case PPContactMainType_AddField:
            {
                break;
            }
            case PPContactMainType_Address:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Address_Work]];
                
                break;
            }
            case PPContactMainType_Company:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Company]];
                
                break;
            }
            case PPContactMainType_BirthDay:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date_Birthday]];
                
                break;
            }
            case PPContactMainType_Date:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Date_Anniversary]];
                
                break;
            }
            case PPContactMainType_InstantMessage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_IM_MSN]];
                
                break;
            }
            case PPContactMainType_Email:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Email_Work]];
                
                break;
            }
            case PPContactMainType_Name:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Name]];
                
                break;
            }
            case PPContactMainType_Note:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Note]];
                
                break;
            }
            case PPContactMainType_PublicNote:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_PublicNote]];
                
                break;
            }
            case PPContactMainType_Other:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_UnifiledBusinessNo,WCCV_MLS_Nickname]];
                
                break;
            }
            case PPContactMainType_Phone:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Phone_Mobile]];
                
                break;
            }
            case PPContactMainType_URL:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_URL_HomePage]];
                
                break;
            }
            case PPContactMainType_UserDefine:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_UserDefine]];
                
                break;
            }
            case PPContactMainType_HeadImage:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Photo]];
                break;
            }
            case PPContactMainType_SocialNetwork:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_SocialNetwork]];
                break;
            }
            case PPContactMainType_Salutation:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Salutation]];
                
                break;
            }
            case PPContactMainType_Status:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_Other]];
                break;
            }
            case PPContactMainType_SalesforceSaveAs:
            {
                [workArray addObjectsFromArray:@[WCCV_MLS_SaveAs]];
                break;
            }
            default:
            {
                break;
            }
        }
        
    } while (0);
    
    return workArray;
    
}


//================================================================================
// MARK: 解析 Salesforce 資料
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingFields:(NSArray *)fields
                                               ppContactMainType:(PPContactMainType)contactMainType
                                                    showPhonetic:(BOOL)showPhonetic
{
    PPContactSectionModel *sectionModel = nil;
    
    //////////////////////////////////////////////////
    
    UITableViewCellEditingStyle editingStyle = UITableViewCellEditingStyleNone;
    
    //////////////////////////////////////////////////

    switch (contactMainType)
    {
            // MARK: 地址
        case PPContactMainType_Address:
        {
            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                [contactDataExchangeModel.propertyDictionary removeObjectForKey:@(0)];
                
                //////////////////////////////////////////////////

                UITableViewCellEditingStyle editingStyle = UITableViewCellEditingStyleNone;
                
                if([self labelType:contactDataExchangeModel.labelType countForFields:fields]>1)
                {
                    editingStyle = UITableViewCellEditingStyleDelete + UITableViewCellEditingStyleInsert;
                }
                //////////////////////////////////////////////////

                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:editingStyle
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_MultiTextFields
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                //////////////////////////////////////////////////
               
                //!!若是地址欄位要補齊顯示欄位格數，顯示才不會出錯
                
                NSString *city = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                
                if(city==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *street = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                
                if(street==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *zip = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                
                if(zip==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *state = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                
                if(state==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *country = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                
                if(country==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                }
                
                //////////////////////////////////////////////////

                NSString *countryCode = [newContactRowObject.inputValueDictionary objectForKey:@(PPContactSubType_Address_CountryCode)];
                
                if(countryCode.length<=0)
                {
                    countryCode = [PPCountryCodeConvert defaultCountryCode];
                    
                    [newContactRowObject.inputValueDictionary setObject:countryCode
                                                              forKey:@(PPContactSubType_Address_CountryCode)];
                    
                    //////////////////////////////////////////////////
                    
                    [newContactRowObject.inputValueDictionary setObject:@([PPCountryCodeConvert defaultRecogLangWithCountryCode:countryCode])
                                                              forKey:@(PPContactSubType_Address_RecognitionLanguageCode)];
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
                {
                    [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:detailText
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
                
            }
            break;
        }
            // MARK: 姓名
        case PPContactMainType_Name:
        {
            if(fields.count>1)
            {
                editingStyle = UITableViewCellEditingStyleDelete | UITableViewCellEditingStyleInsert;
            }
           
            //////////////////////////////////////////////////

            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:editingStyle
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_MultiTextFields
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                //////////////////////////////////////////////////
                
                
                NSString *firstName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                
                if(firstName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *lastName = [newContactRowObject.inputValueDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                
                if(lastName==nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:@"" forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];
                }
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
                {
                    [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:detailText
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
                
            }
            
            break;
        }
            // MARK: 公司
        case PPContactMainType_Company:
        {
            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                PPContactTableViewCellStyle style = PPContactTableViewCellStyle_TextField;
                
                //////////////////////////////////////////////////
                
                UITableViewCellEditingStyle editingStyle = UITableViewCellEditingStyleNone;
     
                if([self labelType:contactDataExchangeModel.labelType countForFields:fields]>1)
                {
                    editingStyle = UITableViewCellEditingStyleDelete + UITableViewCellEditingStyleInsert;
                }
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:editingStyle
                                                                                          ppContactTableViewCellStyle:style
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
  
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:nil
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
            }
            break;
        }
            // MARK: 稱謂，Status
        case PPContactMainType_Salutation:
        case PPContactMainType_Status:
        {
            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                PPContactTableViewCellStyle style = PPContactTableViewCellStyle_DataPicker;
                
                if(contactDataExchangeModel.labelType==PPContactLabelType_Status_Description)
                {
                    style = PPContactTableViewCellStyle_TextField;
                }
                
                //////////////////////////////////////////////////

                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:style
                                                                                                             selected:contactDataExchangeModel.valid];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////

                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                NSString *labelText = contactDataExchangeModel.labelText;
                
                if(labelText==nil && labelText.length<=0)
                {
                    labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:labelText
                                                           detailText:nil
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
            }
            
            break;
        }
            // MARK: Salesforce Save As
        case PPContactMainType_SalesforceSaveAs:
        {
            //////////////////////////////////////////////////

            sectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in fields)
            {
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                                                                             selected:NO];
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    [newContactRowObject.inputValueDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////

                NSString *text = [[newContactRowObject.inputValueDictionary allValues] firstObject];
                
                //////////////////////////////////////////////////
                
                PPRowModel *newRowModel = [PPRowModel rowModelWithRow:sectionModel.rowModels.count
                                                                 text:text
                                                           detailText:nil
                                                               object:newContactRowObject];
                
                [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                
                if(newRowModel!=nil)
                {
                    [sectionModel.rowModels addObject:newRowModel];
                }
            }
            
            break;
        }
            // Other
        default:
        {
            sectionModel = [super ppContactSectionModelForParsingFields:fields
                                                      ppContactMainType:contactMainType
                                                           showPhonetic:showPhonetic];
            
            //////////////////////////////////////////////////

            for(PPRowModel *rowModel in sectionModel.rowModels)
            {
                PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
                
                if([self labelType:contactRowObject.contactLabelType countForSectionModel:sectionModel]>1)
                {
                    editingStyle = UITableViewCellEditingStyleInsert | UITableViewCellEditingStyleDelete;
                }
                else
                {
                    editingStyle = UITableViewCellEditingStyleNone;
                }
      
                contactRowObject.editingStyle = editingStyle;
            }
            
            break;
        }
    }
    
    return sectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *contactSectionModel = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        //!!使用者欄位無法自已新增，只能從外部給予
        if(contactMainType==PPContactMainType_UserDefine)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSArray *itemTextLabelArray   = [self defaultTitleArrayForPPContactMainType:contactMainType];
        
        if(itemTextLabelArray==nil || itemTextLabelArray.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UITableViewCellEditingStyle tableViewCellEditingStyle = UITableViewCellEditingStyleNone;
        
        //////////////////////////////////////////////////
        
        contactSectionModel = [self ppContactSectionModelForPPContactMainType:contactMainType
                                                                itemTextArray:itemTextLabelArray
                                                    tableViewCellEditingStyle:tableViewCellEditingStyle
                                                         ppContactFieldSource:PPContactFieldSource_None];
        
    } while (0);
    
    return contactSectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                                       itemTextArray:(NSArray *)itemTextArray
                                           tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                                ppContactFieldSource:(PPContactFieldSource)contactFieldSource
{
    
    PPContactSectionModel *contactSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    do
    {
        PPContactTableViewCellStyle style = [self contactTableViewCellStyleForContactMainType:contactMainType];
        
        @autoreleasepool
        {
            //新增欄位只要取一個就行了
            if(editingStyle==UITableViewCellEditingStyleInsert)
            {
                itemTextArray = @[[itemTextArray firstObject]];
            }
            
            //////////////////////////////////////////////////
            
            for(NSString *text in itemTextArray)
            {
                PPContactLabelType contactLabelType = [PPContactRowObject ppContactLabelTypeForPPContactMainType:contactMainType labelText:text];
                
                //////////////////////////////////////////////////
                
                PPContactRowObject *contactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                ppContactLabelType:contactLabelType
                                                                                         tableViewCellEditingStyle:editingStyle
                                                                                       ppContactTableViewCellStyle:style
                                                                                                          selected:NO];
                
                if(contactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                switch (contactMainType)
                {
                    case PPContactMainType_Name:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_LastName)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Name_FirstName)];
                        break;
                    }
                    case PPContactMainType_Phone:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_Work)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_WorkFax)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Phone_Mobile)];
                        break;
                    }
                    case PPContactMainType_Email:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_Email_Work)];
                        break;
                    }
                    case PPContactMainType_Company:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_Name)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Company_JobTitle)];
                        break;
                    }
                    case PPContactMainType_Address:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Country)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Zip)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_State)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_City)];
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_Address_Street)];
                        break;
                    }
                    case PPContactMainType_URL:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactLabelType_URL_Work)];
                        break;
                    }
                    case PPContactMainType_Other:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                        break;
                    }
                    case PPContactMainType_HeadImage:
                    {
                        [contactRowObject.inputValueDictionary setObject:@"" forKey:@(PPContactSubType_None)];
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
        
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:contactSectionModel.rowModels.count text:text detailText:nil object:contactRowObject];
                
                [rowModel setPPContactFieldSource:contactFieldSource];
                
                if(rowModel!=nil)
                {
                    [contactSectionModel.rowModels addObject:rowModel];
                }
            }
        }
        
    } while (0);
    
    return contactSectionModel;
}

@end
