//
//  WCContactEditViewController+Salesforce.m
//  
//
//  Created by Howard on 2019/2/19.
//

#import "WCContactEditViewController+Office365.h"


#import "WCContactEditViewController+ContactEditViewDelegate.h"

// Define
#import "PPDateSectionController+ParameterDefine.h"
#import "WCAppearanceDefine.h"
#import "WCContactViewController+PublicParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactEditViewController+ResouceDefine.h"
#import "WCContactEditViewController+SettingKey.h"

#import "WCFieldDefine.h"

// Category
#import "NSDate+Format.h"
#import "PPRowModel+Contact.h"
#import "UIView+PPGuideController.h"
#import "WCContactEditViewController+ContactEditViewDelegate.h"

// Model
#import "Office365EditDataModel.h"

// View
#import "ContactDataPickerTableViewCell.h"
#import "ContactDatePickerTableViewCell.h"
#import "ContactDateAndTimeTextFieldTableViewCell.h"
#import "ContactPhoneTextFieldTableViewCell.h"
#import "ContactMultipleTextFieldButtonTableViewCell.h"
#import "ContactEditNavigationBarView.h"
#import "ContactTextFieldTableViewCell.h"
#import "ContactTextViewTableViewCell.h"
#import "PPSwitchTableViewCell.h"
#import "PPTableViewCell.h"
#import "WCToastController.h"

// Controller
#import "PPGuideController.h"
#import "PPSettingsController.h"




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation WCContactEditViewController (Office365)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (NSInteger)fieldMaxCountWithMainType:(PPContactMainType)mainType labelType:(PPContactLabelType)labelType
{
    return [Office365EditDataModel fieldMaxCountWithMainType:mainType labelType:labelType];
}


//==============================================================================
//
//==============================================================================
- (NSInteger)currentSelectedCountWithsectionModel:(PPSectionModel *)sectionModel labelType:(PPContactLabelType)labelType
{
    NSInteger curSelectedCount = 0;
//    for(NSInteger rowIndex=0; rowIndex<sectionModel.rowModels.count; rowIndex++)
//    {
//        PPRowModel *iterRowModel = [sectionModel.rowModels objectAtIndex:rowIndex];
//        //////////////////////////////////////////////////
//
//        if([iterRowModel ppContactRowObjectOfRowModel].selected==YES)
//        {
//            curSelectedCount ++;
//        }
//    }
//
    for(PPRowModel *iterRowModel in sectionModel.rowModels)
    {
        if(labelType!=[iterRowModel ppContactRowObjectOfRowModel].contactLabelType)
        {
            continue;
        }
        
        //////////////////////////////////////////////////
        
        if([iterRowModel ppContactRowObjectOfRowModel].selected==NO)
        {
            continue;
        }
        
        curSelectedCount ++;
    }
    return curSelectedCount;
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)addOffice365GuidesData
{
    BOOL result = NO;
    
    [PPGuideController setDelegate:self];
    
    //////////////////////////////////////////////////
    // prepare guide data
    
    [PPGuideController clearAllGuideScripts];
    
    @autoreleasepool
    {
        NSMutableArray *guideDataModels = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        
        if(guideDataModels!=nil)
        {
          //////////////////////////////////////////////////

            BOOL existFrontCardImage = NO;
            
            if([self respondsToSelector:@selector(existFrontCardImage)]==YES)
            {
                existFrontCardImage = [self performSelector:@selector(existFrontCardImage)];
            }
            
            BOOL existRearCardImage = NO;
            
            if([self respondsToSelector:@selector(existRearCardImage)]==YES)
            {
                existRearCardImage = [self performSelector:@selector(existRearCardImage)];
            }
            
            //////////////////////////////////////////////////

            if(existFrontCardImage==YES &&
               existRearCardImage==YES &&
               [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideFlipCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideFlipCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_Flip
                                                                                title:WCCV_MLS_GuideFlipTitle
                                                                              message:WCCV_MLS_GuideFlipMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if(existFrontCardImage==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddFrontCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddFrontCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard
                                                                                title:WCCV_MLS_GuideAddFrontCardTitle
                                                                              message:WCCV_MLS_GuideAddFrontCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
            else if(existFrontCardImage==YES &&
                    existRearCardImage==NO &&
                    [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddRearCard]==1)
            {
                [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddRearCard];
                
                //////////////////////////////////////////////////
                
                [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                           guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddBackCard
                                                                                title:WCCV_MLS_GuideAddBackCardTitle
                                                                              message:WCCV_MLS_GuideAddBackCardMessage
                                                                      layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
            }
           
            //////////////////////////////////////////////////
            
            if(guideDataModels.count>0)
            {
                [PPGuideController addGuideScriptWithName:NSStringFromClass([self class]) guideDataModels:guideDataModels];
                
                result = YES;
            }
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)office365MoreButtons
{
    NSMutableArray *moreButtons = nil;
    
    do
    {
        moreButtons = [NSMutableArray array];
        
        if(moreButtons==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPCommentButton *noteButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                             buttonImageName:ImageNameWCContactViewControllerMoreButtonNote
                                                               buttonComment:WCCV_MLS_Note];
        
        if(noteButton==nil)
        {
            break;
        }
        
        noteButton.tag = WCContactEditViewControllerButtonTag_Note;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:noteButton];
        
        [noteButton release];
        
        //////////////////////////////////////////////////
        
        if(self.hideAddOrFlipContactCardButton==NO)
        {
            PPCommentButton *replaceImageButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                         buttonImageName:ImageNameContactEditViewControllerMoreButtonChange
                                                                           buttonComment:WCCV_MLS_ReplaceCard];
            
            if(replaceImageButton==nil)
            {
                break;
            }
            
            replaceImageButton.tag = WCContactEditViewControllerButtonTag_ReplaceCard;
            
            //////////////////////////////////////////////////
            
            [moreButtons addObject:replaceImageButton];
            
            [replaceImageButton release];
        }
        
        //////////////////////////////////////////////////
        
        PPCommentButton *deleteContactButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                                      buttonImageName:ImageNameWCContactViewControllerMoreButtonDelete
                                                                        buttonComment:WCCV_MLS_DeleteContacter];
        
        if(deleteContactButton==nil)
        {
            break;
        }
        
        deleteContactButton.tag = WCContactEditViewControllerButtonTag_DeleteContact;
        
        //////////////////////////////////////////////////
        
        [moreButtons addObject:deleteContactButton];
        
        [deleteContactButton release];
        
        //////////////////////////////////////////////////
        
        for(PPCommentButton *button in moreButtons)
        {
            [button.titleLabel setFont:[UIFont systemFontOfSize:PPTopButtonFontSize]];
            
            //////////////////////////////////////////////////
            
            [button setBackgroundImage:[UIImage imageWithColor:PPTopButtonBackgroundColorHighlighted]
                              forState:UIControlStateHighlighted];
            
            [button setCommentTextColorNormal:PPTopButtonFontColorNormal];
            [button setCommentTextColorHighlighted:PPTopButtonFontColorHighlighted];
        }
        
    }
    while (0);
    
    return moreButtons;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)contactEditView:(ContactEditView *)contactEditView
      office365CellForRowAtIndexPath:(NSIndexPath *)indexPath
                            rowModel:(PPRowModel *)rowModel
{
    UITableViewCell *cell = nil;

    //////////////////////////////////////////////////

    PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
    
    switch (contactRowObject.contactMainType)
    {
        default:
        {
            cell = [self contactEditView:contactEditView
                 wcCellForRowAtIndexPath:indexPath
                                rowModel:rowModel];
            
            break;
        }
    }
        
    //////////////////////////////////////////////////
    
    cell.selectionStyle = UITableViewCellSelectionStyleDefault;

    //////////////////////////////////////////////////

    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - cell 勾選相關流程
/**
 * office 勾選規則
 * 1. 支援多個欄位的話，預設都勾選
 * 2. 超過支援的欄位限制時，不能讓使用者勾選，要顯示toast，要先取消一個，才能勾選下一個
 * 3. 使用者沒勾選時就不上傳，也不保留
 */


//==============================================================================
//
//==============================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wco365DidSelectRowAtIndexPath:(NSIndexPath *)indexPath;
{
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        PPContactRowObject *rowObject = [rowModel ppContactRowObjectOfRowModel];
        PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        NSInteger curSelectedCount = [self currentSelectedCountWithsectionModel:sectionModel labelType:rowObject.contactLabelType];
        NSInteger maxSelectCount = [self fieldMaxCountWithMainType:rowObject.contactMainType labelType:rowObject.contactLabelType];
        if (curSelectedCount<maxSelectCount)
        {
            rowObject.selected = YES;
            
            self.edited = YES;
        }
        else
        {
            // show toast
            [WCToastController showMessageToastFromSuperView:self.view
                                                 withMessage:[NSString stringWithFormat:WCCV_MLS_ArriveMaxFieldCount, maxSelectCount]
                                                    position:PPToastPositionCenter];
            
            [contactEditView.contactEditTableView deselectRowAtIndexPath:indexPath
                                                                animated:NO];
        }
    }
    while (0);
}



//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wco365DidDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [self.contactEditView.contactEditTableView cellForRowAtIndexPath:indexPath];
    
    // MARK: 取消框選
    // 沒有限制，只要把model設對就好
    if (cell.editingStyle==(UITableViewCellEditingStyleDelete|UITableViewCellEditingStyleInsert))
    {
        do
        {
            PPSectionModel *sectionModel = [[self.contactEditSectionController sectionModelsForDefault] objectAtIndex:indexPath.section];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            [rowModel ppContactRowObjectOfRowModel].selected = NO;

        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)contactEditView:(ContactEditView *)contactEditView wco365WillDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        PPRowModel *rowModel = [self.contactEditSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPContactRowObject *contactRowObject = [rowModel ppContactRowObjectOfRowModel];
        
        if(contactRowObject.editingStyle==UITableViewCellEditingStyleNone)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(contactRowObject.selected==NO)
        {
            break;
        }
        
        [contactEditView.contactEditTableView selectRowAtIndexPath:indexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    }
    while (0);
}
@end
